/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ui;

import com.wewebu.ow.server.log.OwLogCore;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class OwBootstrapToIdMapping {
    private static OwBootstrapToIdMapping instance = null;
    private static Logger LOG = OwLogCore.getLogger(OwBootstrapToIdMapping.class);
    private static String BOOTSTRAP2ID = "owbootstrap2id.properties";
    private Map<String, Properties> adapter2PropsMap = new HashMap<String, Properties>();

    private OwBootstrapToIdMapping() {
    }

    public static synchronized OwBootstrapToIdMapping getInstance() {
        if (instance == null) {
            instance = new OwBootstrapToIdMapping();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void writeMappings(String adaptorFullPath_p, String owBootstrapName_p, String identifier_p) {
        FileInputStream fileInputStream = null;
        OutputStream fileOutputStream = null;
        try {
            Properties currentProperties = this.adapter2PropsMap.get(adaptorFullPath_p);
            File propFile = new File(this.getPropertiesFullPath(adaptorFullPath_p));
            if (currentProperties == null) {
                currentProperties = new Properties();
                if (propFile.exists()) {
                    fileInputStream = new FileInputStream(propFile);
                    currentProperties.load(fileInputStream);
                }
            }
            currentProperties.put(owBootstrapName_p, identifier_p);
            fileOutputStream = new FileOutputStream(propFile);
            currentProperties.store(fileOutputStream, "Mappings between owbootstrap*.xml files and identifiers.");
            this.adapter2PropsMap.put(adaptorFullPath_p, currentProperties);
        }
        catch (Exception e) {
            LOG.error((Object)"Cannot write the mappings!", (Throwable)e);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException e) {}
                fileInputStream = null;
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.flush();
                    ((FileOutputStream)fileOutputStream).close();
                }
                catch (IOException e) {}
                fileOutputStream = null;
            }
        }
    }

    private String getPropertiesFullPath(String adaptorFullPath_p) {
        return adaptorFullPath_p + "/" + BOOTSTRAP2ID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String getIdentifier(String adaptorFullPath_p, String owBootstrapName_p) {
        String result = null;
        FileInputStream propStream = null;
        try {
            Properties currentProperties = this.adapter2PropsMap.get(adaptorFullPath_p);
            if (currentProperties == null) {
                currentProperties = new Properties();
                File propFile = new File(this.getPropertiesFullPath(adaptorFullPath_p));
                if (propFile.exists()) {
                    propStream = new FileInputStream(propFile);
                    currentProperties.load(propStream);
                }
            }
            result = currentProperties.getProperty(owBootstrapName_p);
        }
        catch (Exception e) {
            LOG.error((Object)"Cannot read the mappings!", (Throwable)e);
        }
        finally {
            if (propStream != null) {
                try {
                    propStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }
}

