/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ui;

import com.wewebu.ow.server.ui.OwDialog;
import com.wewebu.ow.server.ui.OwView;
import java.io.Writer;
import java.util.List;

public class OwDialogManager
extends OwView {
    public void openDialog(OwDialog dialog_p, OwDialog.OwDialogListener listener_p) throws Exception {
        int iDetachedTargetCount = this.getContext().getTargetCount();
        dialog_p.m_iDEBUG_InitDocument = dialog_p.getDocument();
        dialog_p.m_iDEBUG_DocumentViewSize = this.getDocument().m_ViewList.size();
        this.addView(dialog_p, null);
        if (listener_p != null) {
            dialog_p.getDocument().attachView(listener_p);
        }
        dialog_p.setListener(listener_p);
        dialog_p.m_iDEBUG_TargetCount = this.getContext().getTargetCount() - iDetachedTargetCount;
    }

    public void closeDialog(OwDialog dialog_p) throws Exception {
        List viewList = this.getViewList();
        if (viewList.size() > 0) {
            int iAttachedTargetCount = this.getContext().getTargetCount();
            OwView dlgView = (OwView)viewList.get(viewList.size() - 1);
            if (dialog_p != dlgView) {
                throw new Exception("Can only close the topmost dialog!");
            }
            dialog_p.detach();
            if (dialog_p.m_Listener != null) {
                dialog_p.getDocument().detachView(dialog_p.m_Listener);
            }
            viewList.remove(viewList.size() - 1);
            if (dialog_p.m_iDEBUG_DocumentViewSize != this.getDocument().m_ViewList.size()) {
                throw new Exception("Attached views count exceeded. Did you forget to detach a view in your dialog document or did you not correctly assign a document in your dialog?");
            }
            if (iAttachedTargetCount - this.getContext().getTargetCount() < dialog_p.m_iDEBUG_TargetCount) {
                throw new Exception("Target count exceeded. Did you forget to detach an event target in your dialog?");
            }
            if (dialog_p.m_iDEBUG_InitDocument == null && dialog_p.getDocument() != this.getDocument()) {
                throw new Exception("Document changed in dialog after construction. Please set dialog in constructor.");
            }
            if (dialog_p.m_iDEBUG_InitDocument != null && dialog_p.m_iDEBUG_InitDocument != dialog_p.getDocument()) {
                throw new Exception("Document changed in dialog after construction. Please set dialog in constructor.");
            }
        }
    }

    public boolean isDialogOpen() {
        return null != this.getCurrentDialog();
    }

    public void closeAllDialogs() throws Exception {
        OwDialog dlg = this.getCurrentDialog();
        while (null != dlg) {
            dlg.closeDialog();
            dlg = this.getCurrentDialog();
        }
    }

    protected OwDialog getCurrentDialog() {
        List viewList = this.getViewList();
        if (viewList.size() > 0) {
            return (OwDialog)viewList.get(viewList.size() - 1);
        }
        return null;
    }

    @Override
    protected void onRender(Writer w_p) throws Exception {
        OwDialog Dialog = this.getCurrentDialog();
        if (Dialog != null) {
            Dialog.render(w_p);
        }
    }

    @Override
    public String getTitle() {
        if (this.getCurrentDialog() != null) {
            return this.getCurrentDialog().getTitle();
        }
        return "";
    }
}

