/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ui;

import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.ui.OwBaseView;
import com.wewebu.ow.server.ui.OwEventTarget;
import com.wewebu.ow.server.ui.OwMultipanel;
import com.wewebu.ow.server.ui.OwView;
import com.wewebu.ow.server.ui.helper.OwInnerViewWrapper;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public abstract class OwNavigationView
extends OwView {
    private static final String TAB_ID = "tabID";
    protected boolean m_fValidatePanels;
    protected int m_iCurrentTabIndex = 0;
    private OwInnerViewWrapper m_InnerViewWrapper = new OwInnerViewWrapper();
    protected ArrayList m_TabList = new ArrayList();

    public int addDelimiter() {
        OwDelimiterTabInfo Info = new OwDelimiterTabInfo();
        this.m_TabList.add(Info);
        return this.m_TabList.indexOf(Info);
    }

    protected int addMenuItem(OwTabInfo info_p) throws Exception {
        this.m_TabList.add(info_p);
        return this.m_TabList.indexOf(info_p);
    }

    protected int addView(OwTabInfo info_p, String strViewName_p) throws Exception {
        if (this.getDocument() != null && info_p.getView().getDocument() == null) {
            info_p.getView().setDocument(this.getDocument());
        }
        if (info_p.getView().getContext() == null) {
            info_p.getView().attach(this.getContext(), strViewName_p);
        }
        info_p.getView().setParent(this);
        this.m_TabList.add(info_p);
        this.getViewList().add(info_p.getView());
        return this.m_TabList.indexOf(info_p);
    }

    public void clear() {
        for (OwTabInfo tabInfo : this.m_TabList) {
            if (tabInfo.getView() == null) continue;
            tabInfo.getView().detach();
        }
        this.m_TabList.clear();
    }

    public void enable(int iIndex_p, boolean fEnable_p) {
        OwTabInfo Tab = (OwTabInfo)this.m_TabList.get(iIndex_p);
        Tab.setDisabled(!fEnable_p);
    }

    public void enableAll(boolean fEnable_p) {
        for (int i = 0; i < this.m_TabList.size(); ++i) {
            OwTabInfo Tab = (OwTabInfo)this.m_TabList.get(i);
            Tab.setDisabled(!fEnable_p);
        }
    }

    public String getNavigateEventURL(int iIndex_p) {
        OwTabInfo CurrentTab = (OwTabInfo)this.m_TabList.get(iIndex_p);
        if (CurrentTab != null) {
            if (CurrentTab.getFormName() != null) {
                return this.getContext().getFormEventURL(this, "Navigate", "tabID=" + String.valueOf(iIndex_p), CurrentTab.getFormName());
            }
            return this.getEventURL("Navigate", "tabID=" + String.valueOf(iIndex_p));
        }
        return null;
    }

    public String getNavigationFormAction(int iIndex_p) {
        return this.getEventURL("Navigate", "tabID=" + String.valueOf(iIndex_p));
    }

    public int getNavigationIndex() {
        return this.m_iCurrentTabIndex;
    }

    public List getTabList() {
        return this.m_TabList;
    }

    public OwBaseView getViewReference() {
        return this.m_InnerViewWrapper;
    }

    public boolean isLastTabIndex(int i_p) {
        return i_p >= this.m_TabList.size() - 1;
    }

    public boolean isPreviousPanelValid(int iIndex_p) {
        block6: {
            try {
                OwTabInfo PrevActiveInfo;
                if (!this.m_fValidatePanels) {
                    return true;
                }
                if (iIndex_p <= 0 || (PrevActiveInfo = (OwTabInfo)this.m_TabList.get(iIndex_p - 1)).getView() == null) break block6;
                try {
                    if (!((OwMultipanel)((Object)PrevActiveInfo.getView())).isValidated()) {
                        return false;
                    }
                }
                catch (ClassCastException classCastException) {}
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    public void navigate(int iIndex_p) throws Exception {
        this.navigate(iIndex_p, null);
    }

    private void navigate(int iIndex_p, HttpServletRequest request_p) throws Exception {
        if (iIndex_p >= this.m_TabList.size()) {
            throw new OwInvalidOperationException("OwNavigationView.navigate: Navigation index is out of bound.");
        }
        OwTabInfo ActiveInfo = (OwTabInfo)this.m_TabList.get(iIndex_p);
        if (ActiveInfo.getView() != null) {
            if (!this.isPreviousPanelValid(iIndex_p)) {
                return;
            }
            this.m_iCurrentTabIndex = iIndex_p;
            this.m_InnerViewWrapper.setView(ActiveInfo.getView());
            ActiveInfo.getView().onActivate(iIndex_p, ActiveInfo.getReasonObject());
            this.getContext().m_DEBUG_ActivateViewID = ActiveInfo.getView().getID();
        }
        if (ActiveInfo.getEventTarget() != null) {
            this.m_iCurrentTabIndex = iIndex_p;
            if (request_p == null) {
                throw new Exception("Request must not be null with handlers.");
            }
            Method method = ActiveInfo.getEventTarget().getClass().getMethod("on" + ActiveInfo.getEventMethod(), HttpServletRequest.class, Object.class);
            method.invoke((Object)ActiveInfo.getEventTarget(), request_p, ActiveInfo.getReasonObject());
            this.getContext().m_DEBUG_NavigationTargetID = ActiveInfo.getEventTarget().getID();
            this.getContext().m_DEBUG_NavigationEvent = "on" + ActiveInfo.getEventMethod();
        }
    }

    public void navigate(String strTargetID_p) throws Exception {
        for (int i = 0; i < this.m_TabList.size(); ++i) {
            OwView View = ((OwTabInfo)this.m_TabList.get(i)).getView();
            if (View == null || !View.getID().equals(strTargetID_p)) continue;
            this.navigate(i);
            return;
        }
        throw new Exception("View with Target ID " + strTargetID_p + " not found");
    }

    public void navigateFirst() throws Exception {
        Exception lastException = null;
        for (int i = 0; i < this.getTabList().size(); ++i) {
            try {
                if (((OwTabInfo)this.getTabList().get(i)).getDelimiter()) continue;
                this.navigate(i);
                return;
            }
            catch (Exception e) {
                lastException = e;
            }
        }
        if (null != lastException) {
            throw lastException;
        }
    }

    @Override
    public void onFormEvent(HttpServletRequest request_p) throws Exception {
        String strID = request_p.getParameter(TAB_ID);
        if (strID != null) {
            int iIndex = Integer.parseInt(strID);
            if (iIndex >= this.m_TabList.size()) {
                throw new OwInvalidOperationException("OwNavigationView.onFormEvent: Navigation index is out of bound.");
            }
            OwTabInfo ActiveInfo = (OwTabInfo)this.m_TabList.get(iIndex);
            if (ActiveInfo.getEventTarget() != null) {
                ActiveInfo.getEventTarget().onFormEvent(request_p);
            }
        }
    }

    public void onNavigate(HttpServletRequest request_p) throws Exception {
        String strID = request_p.getParameter(TAB_ID);
        if (strID != null) {
            int iOldIndex = this.m_iCurrentTabIndex;
            int iNewIndex = Integer.parseInt(strID);
            try {
                this.navigate(iNewIndex, request_p);
            }
            catch (Exception e) {
                OwTabInfo info = (OwTabInfo)this.getTabList().get(iNewIndex);
                if (info.getEventMethod() == null && iOldIndex != iNewIndex) {
                    this.navigate(iOldIndex, request_p);
                }
                throw e;
            }
        }
    }

    @Override
    protected void onRender(Writer w_p) throws Exception {
        for (int i = 0; i < this.m_TabList.size(); ++i) {
            OwTabInfo naviitem = (OwTabInfo)this.m_TabList.get(i);
            this.renderNavigationLink(w_p, naviitem, i, this.m_TabList.size() - 1, this.getNavigationIndex());
        }
    }

    public void renderCurrentView(Writer w_p) throws Exception {
        OwTabInfo CurrentTab = (OwTabInfo)this.m_TabList.get(this.m_iCurrentTabIndex);
        if (CurrentTab != null) {
            CurrentTab.getView().render(w_p);
        }
    }

    public void renderNavigationLink(Writer w_p, OwTabInfo tabInfo_p, int index_p, int last_p, int selected_p) throws Exception {
    }

    public void setValidatePanels(boolean fValidatePanels_p) {
        this.m_fValidatePanels = fValidatePanels_p;
    }

    public int size() {
        return this.m_TabList.size();
    }

    @Override
    public String getTitle() {
        return ((OwTabInfo)this.m_TabList.get(this.getNavigationIndex())).getName();
    }

    public static interface OwTabInfo {
        public boolean getDelimiter();

        public boolean getDisabled();

        public String getEvent();

        public String getEventMethod();

        public OwEventTarget getEventTarget();

        public String getFormEventAction();

        public String getFormName();

        public boolean getLastTab();

        public boolean getPreviousPanelValid();

        public Object getReasonObject();

        public boolean getSelected();

        public OwView getView();

        public void setDisabled(boolean var1);

        public String getName();
    }

    public class OwDelimiterTabInfo
    implements OwTabInfo {
        @Override
        public boolean getDelimiter() {
            return true;
        }

        @Override
        public boolean getDisabled() {
            return false;
        }

        @Override
        public String getEvent() {
            return "";
        }

        @Override
        public String getEventMethod() {
            return null;
        }

        @Override
        public OwEventTarget getEventTarget() {
            return null;
        }

        @Override
        public String getFormEventAction() {
            return "";
        }

        @Override
        public String getFormName() {
            return null;
        }

        @Override
        public boolean getLastTab() {
            return false;
        }

        @Override
        public boolean getPreviousPanelValid() {
            return true;
        }

        @Override
        public Object getReasonObject() {
            return null;
        }

        @Override
        public boolean getSelected() {
            return false;
        }

        @Override
        public OwView getView() {
            return null;
        }

        @Override
        public void setDisabled(boolean fDisabled_p) {
        }

        @Override
        public String getName() {
            return "";
        }
    }
}

