/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ui;

import com.wewebu.ow.server.ui.OwAppContext;
import com.wewebu.ow.server.util.OwString;
import java.io.IOException;
import java.io.Writer;
import java.util.Locale;

public class OwScriptTable {
    protected static final String CONTEXT_MENU_LABEL_POSTFIX = "_label";
    protected static final String CONTEXT_MENU_ICON_POSTFIX = "_icon";
    protected static final String ROW_PREFIX_MULTISELECT = "mwrowid_";
    protected static final String ROW_PREFIX_SINGLESELECT = "swrowid_";
    protected static final String CHECKBOX_PREFIX = "owcbid_";

    public static String getSelectableListCheckBoxName(String sTableId_p) {
        return "owmcb_" + sTableId_p;
    }

    public static String getSelectableListContextMenuID(String sTableId_p) {
        return "owctx_" + sTableId_p;
    }

    public static void writeSelectableListHandlerScript(String sTableId_p, Writer w_p, String sJavaScriptCode_p) throws IOException {
        w_p.write("\n\n<script language='JavaScript'>\n\nfunction onRowSelectHandler(fIndex_p,rownode_p,fSelected_p)");
        w_p.write("\n{\n\n");
        w_p.write(sJavaScriptCode_p);
        w_p.write("\n\n}\n\n</script>\n\n");
    }

    public static void writeSelectableListEnableScript(String sTableId_p, Writer w_p, OwAppContext context_p) throws IOException {
        w_p.write("\n\n<script language='JavaScript'> enableScriptTable() </script>\n\n");
    }

    public static void writeSelectableListRowStart(Locale locale_p, String sTableId_p, Writer w_p, int iIndex_p, String strRowClass_p, boolean fMultiselect_p) throws IOException {
        OwScriptTable.writeSelectableListRowStart(locale_p, sTableId_p, w_p, iIndex_p, strRowClass_p, null, fMultiselect_p, false);
    }

    public static void writeSelectableListRowStart(Locale locale_p, String sTableId_p, Writer w_p, int iIndex_p, String strRowClass_p, String strSelectedRowClass_p, boolean fMultiselect_p, boolean fSelected_p) throws IOException {
        String sID = null;
        sID = fMultiselect_p ? ROW_PREFIX_MULTISELECT : ROW_PREFIX_SINGLESELECT;
        String sIndex = String.valueOf(iIndex_p);
        w_p.write("\n<tr id='");
        w_p.write(sID);
        w_p.write(sTableId_p);
        w_p.write("_");
        w_p.write(sIndex);
        if (fSelected_p) {
            w_p.write("' class='");
            w_p.write(strSelectedRowClass_p);
            w_p.write("' backupClassName='");
            w_p.write(strRowClass_p);
        } else {
            w_p.write("' class='");
            w_p.write(strRowClass_p);
        }
        w_p.write("'>\n");
        w_p.write("\n<td align='center'><input onclick=\"onClickItemCheckBox('");
        w_p.write(sIndex);
        w_p.write("','");
        w_p.write(sTableId_p);
        w_p.write("');\" type='checkbox' id='");
        w_p.write(CHECKBOX_PREFIX);
        w_p.write(sTableId_p);
        w_p.write("_");
        w_p.write(sIndex);
        w_p.write("' title='");
        w_p.write(OwString.localize1(locale_p, "app.OwScriptTable.row.checkbox.title", "Row %1", "" + (iIndex_p + 1)));
        w_p.write("' name='");
        w_p.write(OwScriptTable.getSelectableListCheckBoxName(sTableId_p));
        w_p.write("' value='");
        w_p.write(sIndex);
        w_p.write("'");
        if (fSelected_p) {
            w_p.write(" checked");
        }
        w_p.write("></td>");
    }

    public static void writeSelectableListHeaderStart(String sTableId_p, Writer w_p, String strHeaderClass_p, OwAppContext context_p) throws Exception {
        w_p.write("\n<tr class='");
        w_p.write(strHeaderClass_p);
        w_p.write("'>\n");
        String strToolTip = context_p.localize("app.OwObjectListView.toggleselectall", "Alles (de)selektieren");
        String strURL = "javascript:toggleCheckBoxes('" + OwScriptTable.getSelectableListCheckBoxName(sTableId_p) + "');";
        w_p.write("\n<th align='center'><a href=\"");
        w_p.write(strURL);
        w_p.write("\" id=\"toggleCheckBoxesID\"><img border='0' title='");
        w_p.write(strToolTip);
        w_p.write("' alt='");
        w_p.write(strToolTip);
        w_p.write("' src='");
        w_p.write(context_p.getDesignURL());
        w_p.write("/images/ok_btn16.png");
        w_p.write("'></a></th>");
        context_p.registerKeyEvent(65, 512, "javascript:keyboardSelectAll();", strToolTip);
        w_p.write("\n\n<script type=\"text/javascript\">activeListCheckBoxId='");
        w_p.write(sTableId_p);
        w_p.write("'");
        w_p.write(";</script>\n\n");
    }

    public static void writeSelectableListContextMenuStart(String sTableId_p, Writer w_p, String strClass_p) throws Exception {
        w_p.write("\n<span id='");
        w_p.write(OwScriptTable.getSelectableListContextMenuID(sTableId_p));
        w_p.write("' class='");
        w_p.write(strClass_p);
        w_p.write("' onMouseout='starTimeOut(this)' onMouseenter='clearTimeOut(this)' onFocusout='hideMenu()' onMouseover='clearTimeOut(this)'>");
        w_p.write("<table border='0' cellpadding='0' cellspacing='0'>");
    }

    public static void writeSelectableListContextMenuEnd(String sTableId_p, Writer w_p) throws Exception {
        w_p.write("</table>");
        w_p.write("\n</span>");
        w_p.write("\n\n<script type=\"text/javascript\">");
        w_p.write("\n\n\tappendMenuId(");
        w_p.write(sTableId_p);
        w_p.write(");");
        w_p.write("\n</script>\n\n");
    }

    public static void writeSelectableListContextMenuTREntry(String sTableId_p, Writer w_p, String sClassNamePrefix_p, int iIndex_p, String sEventURL_p, String sFormName_p, String sIcon_p, String sLabel_p) throws Exception {
        String strID = OwScriptTable.getSelectableListContextMenuID(sTableId_p) + "_" + String.valueOf(iIndex_p);
        w_p.write("\n<tr id='");
        w_p.write(strID);
        w_p.write("' class='");
        w_p.write(sClassNamePrefix_p);
        w_p.write("_Item' onmouseover = 'overctx(this)' onmouseout = 'outctx(this)' onclick =\"clickctx(this,'");
        w_p.write(sEventURL_p);
        w_p.write("','");
        w_p.write(sFormName_p);
        w_p.write("');\">");
        w_p.write("<td id='");
        w_p.write(strID);
        w_p.write(CONTEXT_MENU_ICON_POSTFIX);
        w_p.write("' class='");
        w_p.write(sClassNamePrefix_p);
        w_p.write("_Icon'>");
        w_p.write(sIcon_p);
        w_p.write("</td>");
        w_p.write("<td id='");
        w_p.write(strID);
        w_p.write(CONTEXT_MENU_LABEL_POSTFIX);
        w_p.write("' class='");
        w_p.write(sClassNamePrefix_p);
        w_p.write("_Label'>");
        w_p.write(sLabel_p);
        w_p.write("</td>");
        w_p.write("</tr>\n");
    }
}

