/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ui;

import com.wewebu.ow.server.conf.OwBaseUserInfo;
import com.wewebu.ow.server.log.OwLogCore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class OwUsageCounter {
    private static final Logger LOG = OwLogCore.getLogger(OwUsageCounter.class);
    private static final int INTERVAL_TIME = 60000;
    private static final int MAX_24H_STAT_ENTRIES = 1440;
    private static volatile Map m_sessions = new Hashtable();
    private static volatile Map m_users = new Hashtable();
    private static volatile ArrayList m_24hstats = new ArrayList();
    private static volatile Date m_lastinterval = new Date();

    public static void onLogin(String sessionid_p, OwBaseUserInfo userid_p) {
        String userid = userid_p.getUserID();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("OwUsageCounter.onLogin: userid=" + userid));
        }
        m_sessions.put(sessionid_p, userid);
        HashSet<String> sessions = (HashSet<String>)m_users.get(userid);
        if (sessions == null) {
            sessions = new HashSet<String>();
            m_users.put(userid, sessions);
        }
        sessions.add(sessionid_p);
        Date currentDate = new Date();
        if (60000L + m_lastinterval.getTime() < currentDate.getTime()) {
            OwUsageCounter.onLoggerInterval(currentDate);
        }
    }

    public static void onLogout(String sessionid_p, OwBaseUserInfo userid_p) {
        Set sessions;
        String userid = userid_p.getUserID();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("OwUsageCounter.onLogout: Userid = " + userid));
        }
        if ((sessions = (Set)m_users.get(userid)) != null) {
            for (String session : sessions) {
                m_sessions.remove(session);
            }
        }
        m_users.remove(userid);
    }

    private static synchronized void onLoggerInterval(Date currentDate_p) {
        if (60000L + m_lastinterval.getTime() < currentDate_p.getTime()) {
            m_lastinterval = currentDate_p;
            if (m_24hstats.size() >= 1440) {
                m_24hstats.remove(0);
            }
            m_24hstats.add(new OwUsageState(m_users, m_sessions, currentDate_p));
        }
    }

    public static Collection getStatistics() {
        return m_24hstats;
    }

    public static int getIntervalTime() {
        return 60000;
    }

    public static void onSessionCreated(String sessionid_p) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("OwUsageCounter.onSessionCreated: Sessioid = " + sessionid_p));
        }
    }

    public static void onSessionDestroyed(String sessionid_p) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("OwUsageCounter.onSessionDestroyed: Sessioid = " + sessionid_p));
        }
        String userid = (String)m_sessions.get(sessionid_p);
        m_sessions.remove(sessionid_p);
        if (userid != null) {
            Set sessions = (Set)m_users.get(userid);
            if (sessions != null) {
                sessions.remove(sessionid_p);
            }
            if (sessions == null || sessions.size() == 0) {
                m_users.remove(userid);
            }
        }
    }

    public static class OwUsageState {
        private int m_iusercount;
        private int m_isessioncount;
        private Date m_Date;

        public OwUsageState(Map users_p, Map sessions_p, Date date_p) {
            this.m_iusercount = users_p.size();
            this.m_isessioncount = sessions_p.size();
            this.m_Date = date_p;
        }

        public Date getDate() {
            return this.m_Date;
        }

        public int getUserCount() {
            return this.m_iusercount;
        }

        public int getSessionCount() {
            return this.m_isessioncount;
        }
    }
}

