/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ui;

import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.ui.OwBaseView;
import com.wewebu.ow.server.ui.OwDocument;
import com.wewebu.ow.server.ui.OwEventTarget;
import com.wewebu.ow.server.ui.OwNavigationView;
import com.wewebu.ow.server.ui.OwUpdateTarget;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class OwView
extends OwEventTarget
implements OwBaseView,
OwUpdateTarget {
    public static final String CURRENT_MODULE_KEY = "ow_current_module";
    private static final Logger LOG = OwLogCore.getLogger(OwView.class);
    public static final String FORMULAR_PLACEHOLDER_START_DELIMITER = "{#";
    public static final String FORMULAR_PLACEHOLDER_END_DELIMITER = "#}";
    private LinkedList m_InnerViewList = null;
    private OwDocument m_Document;
    private boolean m_fMinimized = false;
    private OwView m_ParentView;
    protected OwEventTarget m_externalFormEventTarget = this;

    public String getIcon() throws Exception {
        return null;
    }

    public Iterator getIterator() {
        if (this.m_InnerViewList != null) {
            return this.m_InnerViewList.iterator();
        }
        return Collections.emptyList().iterator();
    }

    public List getViewList() {
        if (this.m_InnerViewList == null) {
            this.m_InnerViewList = new LinkedList();
        }
        return this.m_InnerViewList;
    }

    @Override
    public String getTitle() {
        return "";
    }

    protected void setParent(OwView parent_p) {
        this.m_ParentView = parent_p;
    }

    public OwView getParent() {
        return this.m_ParentView;
    }

    protected void setMaximizeView(OwView view_p) {
        OwView parentView = this.getParent();
        if (parentView != null) {
            parentView.setMaximizeView(view_p);
        }
    }

    protected OwView getMaximizeView() {
        OwView parentView = this.getParent();
        if (parentView != null) {
            return parentView.getMaximizeView();
        }
        return null;
    }

    public void showMaximized() {
        this.setMaximizeView(this);
        this.m_fMinimized = false;
    }

    public void showMinimized() {
        if (this.isShowMaximized()) {
            this.setMaximizeView(null);
        }
        this.m_fMinimized = true;
    }

    public void showNormal() {
        if (this.isShowMaximized()) {
            this.setMaximizeView(null);
        }
        this.m_fMinimized = false;
    }

    public boolean isShowMaximized() {
        return this == this.getMaximizeView();
    }

    public boolean isShowMinimized() {
        return this.m_fMinimized;
    }

    public boolean isShowNormal() {
        return !this.isShowMinimized() && !this.isShowMaximized();
    }

    @Override
    public void onUpdate(OwEventTarget caller_p, int iCode_p, Object param_p) throws Exception {
    }

    public void activate() throws Exception {
        this.setMaximizeView(null);
        OwView parent = this.getParent();
        if (parent != null) {
            parent.activate();
            if (parent instanceof OwNavigationView) {
                ((OwNavigationView)parent).navigate(this.getID());
            }
        }
    }

    public void addView(OwView view_p, String strName_p) throws Exception {
        if (this.m_Document != null) {
            view_p.setDocument(this.m_Document);
        }
        view_p.setParent(this);
        view_p.attach(this.getContext(), strName_p);
        this.getViewList().add(view_p);
    }

    public void setDocument(OwDocument doc_p) {
        if (null != this.m_Document) {
            return;
        }
        this.m_Document = doc_p;
        doc_p.attachView(this);
        Iterator it = this.getIterator();
        while (it.hasNext()) {
            OwView View = (OwView)it.next();
            View.setDocument(doc_p);
        }
    }

    @Override
    public void detach() {
        super.detach();
        if (this.m_Document != null) {
            this.m_Document.detachView(this);
        }
        Iterator it = this.getIterator();
        while (it.hasNext()) {
            OwView View = (OwView)it.next();
            View.detach();
        }
    }

    public OwDocument getDocument() {
        return this.m_Document;
    }

    @Override
    public final void render(Writer w_p) throws Exception {
        w_p.write("\n<!-- Start View [ID: ");
        w_p.write(this.getID());
        w_p.write("; Class: ");
        w_p.write(this.getClass().getName());
        w_p.write("] -->\n");
        if (this.m_externalFormEventTarget == this && this.usesFormWithAttributes() != null) {
            String formName = this.getFormName();
            if (formName == null) {
                formName = "null";
                LOG.warn((Object)("null value for form name in = " + this.getClass() + " externalForm = " + this.m_externalFormEventTarget));
            }
            w_p.write("<form method=\"post\" name=\"");
            w_p.write(formName);
            w_p.write("\" id=\"");
            w_p.write(formName);
            w_p.write("\" ");
            w_p.write(this.usesFormWithAttributes());
            w_p.write(">");
            this.onRender(w_p);
            w_p.write("</form>");
        } else {
            this.onRender(w_p);
        }
        w_p.write("\n<!-- End View [ID: ");
        w_p.write(this.getID());
        w_p.write("; Class: ");
        w_p.write(this.getClass().getName());
        w_p.write("] -->\n");
    }

    protected void onRender(Writer w_p) throws Exception {
        Iterator it = this.getIterator();
        while (it.hasNext()) {
            OwView View = (OwView)it.next();
            View.render(w_p);
        }
    }

    @Override
    public void renderRegion(Writer w_p, int iRegion_p) throws Exception {
        throw new OwInvalidOperationException("OwView.renderRegion: Implement renderRegion in derived class");
    }

    public String getRenderedRegion(int iRegion_p) throws Exception {
        StringWriter buf = new StringWriter();
        this.renderRegion(buf, iRegion_p);
        return buf.toString();
    }

    @Override
    public boolean isRegion(int iRegion_p) throws Exception {
        return false;
    }

    @Override
    public boolean isNamedRegion(String strRegion_p) throws Exception {
        return false;
    }

    @Override
    protected void init() throws Exception {
    }

    protected void onActivate(int iIndex_p, Object oReason_p) throws Exception {
    }

    public void serverSideInclude(String path_p, Writer w_p) throws Exception {
        Object previous = this.setRequestAttribute(CURRENT_MODULE_KEY, this);
        this.getContext().serverSideInclude(path_p, w_p);
        this.setRequestAttribute(CURRENT_MODULE_KEY, previous);
    }

    private Object setRequestAttribute(String key_p, Object value_p) {
        Object previousObject = this.getContext().getHttpRequest().getAttribute(key_p);
        if (value_p != null) {
            this.getContext().getHttpRequest().setAttribute(key_p, value_p);
        } else {
            this.getContext().getHttpRequest().removeAttribute(key_p);
        }
        return previousObject;
    }

    public void serverSideDesignInclude(String path_p, Writer w_p) throws Exception {
        this.serverSideInclude(this.getContext().getDesignDir() + "/" + path_p, w_p);
    }

    protected void renderHTMLFormular(Writer w_p, String strHTMLFormular_p) throws Exception {
        int iStart = -1;
        int iEnd = 0;
        while (-1 != (iStart = strHTMLFormular_p.indexOf(FORMULAR_PLACEHOLDER_START_DELIMITER, iEnd))) {
            w_p.write(strHTMLFormular_p.substring(iEnd, iStart));
            iEnd = strHTMLFormular_p.indexOf(FORMULAR_PLACEHOLDER_END_DELIMITER, iEnd + 1);
            if (iEnd == -1) {
                throw new Exception("Formular parser error. Missing placeholder end tag.!");
            }
            String strPlaceholder = strHTMLFormular_p.substring(iStart + FORMULAR_PLACEHOLDER_START_DELIMITER.length(), iEnd);
            this.renderNamedRegion(w_p, strPlaceholder);
            iEnd += FORMULAR_PLACEHOLDER_END_DELIMITER.length();
        }
        w_p.write(strHTMLFormular_p.substring(iEnd, strHTMLFormular_p.length()));
    }

    @Override
    public void renderNamedRegion(Writer w_p, String strRegion_p) throws Exception {
        throw new OwInvalidOperationException("OwView.renderNamedRegion: Implement renderRegion in derived class.");
    }

    public String getRenderedNamedRegion(String strRegion_p) throws Exception {
        StringWriter buf = new StringWriter();
        this.renderNamedRegion(buf, strRegion_p);
        return buf.toString();
    }

    public boolean isFormTargetExternal() {
        return this.m_externalFormEventTarget != this;
    }

    @Override
    public OwEventTarget getFormTarget() {
        return this.m_externalFormEventTarget;
    }

    @Override
    public void setExternalFormTarget(OwEventTarget eventtarget_p) throws Exception {
        this.m_externalFormEventTarget = eventtarget_p;
    }

    public OwEventTarget getExternalFormEventTarget() {
        return this.m_externalFormEventTarget;
    }

    protected String usesFormWithAttributes() {
        return null;
    }

    @Override
    public String getFormName() {
        if (this == this.m_externalFormEventTarget) {
            return "FORM_" + String.valueOf(this.hashCode());
        }
        return this.m_externalFormEventTarget.getFormName();
    }

    @Override
    public String getBreadcrumbPart() {
        return this.getTitle();
    }
}

