/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ui;

import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.ui.OwAppContext;
import com.wewebu.ow.server.ui.OwPendingSessionException;
import com.wewebu.ow.server.ui.OwView;
import com.wewebu.ow.server.util.OwExceptionManager;
import com.wewebu.ow.server.util.OwHTMLHelper;
import com.wewebu.ow.server.util.OwString;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.SocketException;
import java.util.Date;
import java.util.Locale;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.apache.log4j.NDC;
import org.perf4j.log4j.Log4JStopWatch;

public class OwWebApplication {
    private static final Logger LOG = OwLogCore.getLogger(OwWebApplication.class);
    public static final String LOGIN_VIEW_KEY = "ow_LoginView";
    public static final String CONTEXT_KEY = "ow_Context";
    private static final String VIEW_KEY = "ow_View";
    public static final String BODY_ID = "owbody";
    public static final String SESSION_KEY_LOGGEDOUT_HEADER = "ow_loggedout_header";
    public static final String SESSION_KEY_LOGGEDOUT_MESSAGE = "ow_loggedout_message";
    protected Class m_LoginClass = null;
    protected Class m_ContextClass = null;
    protected Class m_ViewClass = null;
    protected String m_strMainJspPage;
    protected OwView m_MainView = null;
    protected OwView m_LoginView = null;
    protected OwAppContext m_Context = null;

    public void setContextClass(Class docClass_p) {
        this.m_ContextClass = docClass_p;
    }

    public void setViewClass(Class viewClass_p) {
        this.m_ViewClass = viewClass_p;
    }

    public void setLoginClass(Class loginClass_p) {
        this.m_LoginClass = loginClass_p;
    }

    public void setJspPath(String strJspPath_p) {
        this.m_strMainJspPage = strJspPath_p;
    }

    public static OwView getMainView(HttpSession session_p) {
        return (OwView)session_p.getAttribute(VIEW_KEY);
    }

    public static OwView getLoginView(HttpSession session_p) {
        return (OwView)session_p.getAttribute(LOGIN_VIEW_KEY);
    }

    public static OwAppContext getContext(HttpSession session_p) {
        return (OwAppContext)session_p.getAttribute(CONTEXT_KEY);
    }

    public static void invalidateSessionObjects(HttpServletRequest request_p) {
        HttpSession Session = request_p.getSession();
        Session.setAttribute(VIEW_KEY, null);
        Session.setAttribute(LOGIN_VIEW_KEY, null);
        Session.setAttribute(CONTEXT_KEY, null);
        Session.invalidate();
    }

    public void logSessionInfo(HttpServletRequest request_p, boolean fAllSessions_p) {
        HttpSession session = request_p.getSession();
        if (session.isNew() || fAllSessions_p) {
            StringBuffer logBuf = new StringBuffer();
            logBuf.append("OW WEB-SESSION INFO ");
            if (session.isNew()) {
                logBuf.append("(NEW) - ");
            } else {
                logBuf.append("(OLD) - ");
            }
            logBuf.append(" ID: ");
            logBuf.append(session.getId());
            logBuf.append(" CreateTime: ");
            logBuf.append(new Date(session.getCreationTime()).toString());
            logBuf.append(" LastAccessTime: ");
            logBuf.append(new Date(session.getLastAccessedTime()).toString());
            logBuf.append(" Age: ");
            logBuf.append((session.getLastAccessedTime() - session.getCreationTime()) / 1000L);
            logBuf.append(" [sec.] ");
            logBuf.append(" MaxIntactiveInterval: ");
            logBuf.append(session.getMaxInactiveInterval());
            logBuf.append(" [sec.]");
            try {
                OwAppContext ctx = (OwAppContext)session.getAttribute(CONTEXT_KEY);
                logBuf.append(" Login: ");
                logBuf.append(ctx.getSessionDisplayName());
            }
            catch (Exception e) {
                // empty catch block
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)logBuf.toString());
            }
        }
    }

    public void checkSessionObjects(ServletContext context_p, HttpServletRequest request_p, HttpServletResponse response_p, HttpSession session_p) throws Exception {
        OwAppContext context = (OwAppContext)session_p.getAttribute(CONTEXT_KEY);
        if (context == null) {
            context = (OwAppContext)this.m_ContextClass.newInstance();
            context.setRequest(context_p, request_p, response_p);
            context.init(this.m_Context);
            session_p.setAttribute(CONTEXT_KEY, (Object)context);
            this.m_LoginView = (OwView)this.m_LoginClass.newInstance();
            session_p.setAttribute(LOGIN_VIEW_KEY, (Object)this.m_LoginView);
            this.m_LoginView.attach(context, LOGIN_VIEW_KEY);
            this.m_MainView = null;
            session_p.setAttribute(VIEW_KEY, null);
        } else {
            context.setRequest(context_p, request_p, response_p);
            this.m_MainView = (OwView)session_p.getAttribute(VIEW_KEY);
            this.m_LoginView = (OwView)session_p.getAttribute(LOGIN_VIEW_KEY);
        }
        this.m_Context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleAjaxRequest(ServletContext context_p, HttpServletRequest request_p, HttpServletResponse response_p) throws Exception {
        Log4JStopWatch handleAjaxRequestStopWatch = new Log4JStopWatch("handleAjaxRequest");
        try {
            request_p.setAttribute("AJAX_REQUEST_TYPE", (Object)Boolean.TRUE);
            this.checkSessionObjects(context_p, request_p, response_p, request_p.getSession());
            NDC.push((String)this.m_Context.getUserInfo().getUserName());
            this.m_Context.setAjaxRequest(true);
            this.m_Context.handleAjaxRequest(request_p, response_p);
            this.m_Context.setAjaxRequest(false);
        }
        finally {
            NDC.pop();
            NDC.remove();
            handleAjaxRequestStopWatch.stop();
        }
    }

    private void beginRequest(HttpSession session_p) throws OwPendingSessionException {
        OwAppContext context = (OwAppContext)session_p.getAttribute(CONTEXT_KEY);
        if (context != null) {
            context.beginRequest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRequest(ServletContext context_p, HttpServletRequest request_p, HttpServletResponse response_p) throws Exception {
        try {
            Log4JStopWatch handleRequestLogicStopWatch = new Log4JStopWatch("handleRequest(Logic)");
            this.checkSessionObjects(context_p, request_p, response_p, request_p.getSession());
            this.beginRequest(request_p.getSession());
            response_p.setHeader("Cache-Control", "no-cache");
            response_p.setHeader("Pragma", "no-cache");
            response_p.setHeader("Expires", "Thu, 01 Dec 1994 16:00:00 GMT");
            if (this.m_Context.prepareRequest(request_p, response_p)) {
                this.m_Context.endRequest();
                return;
            }
            if (this.m_Context.isLogin()) {
                NDC.push((String)this.m_Context.getUserInfo().getUserName());
                this.m_Context.handleRequest(request_p, response_p);
                if (!this.m_Context.isLogin() && this.m_Context.isContainerBasedAuthenticated()) {
                    request_p.getSession().setAttribute(SESSION_KEY_LOGGEDOUT_HEADER, (Object)this.m_Context.localize("ui.OwWebApplication.loggedout.header", "Goodbye"));
                    request_p.getSession().setAttribute(SESSION_KEY_LOGGEDOUT_MESSAGE, (Object)this.m_Context.localize("ui.OwWebApplication.loggedout.message", "You have successfully logged out from Workdesk. You may close this window."));
                    response_p.sendRedirect(this.m_Context.getBaseURL() + "/loggedout.jsp");
                    this.m_Context.endRequest();
                    return;
                }
            } else {
                if (!this.m_Context.handleRequest(request_p, response_p)) {
                    this.m_Context.endRequest();
                    return;
                }
                if (this.m_Context.isLogin() && this.m_MainView == null) {
                    NDC.push((String)this.m_Context.getUserInfo().getUserName());
                    this.m_Context.loginInit();
                    this.m_MainView = (OwView)this.m_ViewClass.newInstance();
                    request_p.getSession().setAttribute(VIEW_KEY, (Object)this.m_MainView);
                    this.m_MainView.attach(this.m_Context, "ow_MainView");
                    if (this.m_Context.isExternalTargetRequest(request_p)) {
                        this.m_Context.handleExternalTargetRequest(request_p, response_p);
                    }
                }
            }
            this.checkSessionObjects(context_p, request_p, response_p, request_p.getSession());
            handleRequestLogicStopWatch.stop();
            Log4JStopWatch handleRequestRenderStopWatch = new Log4JStopWatch("handleRequest(Render)");
            RequestDispatcher rd = context_p.getRequestDispatcher("/" + this.m_strMainJspPage);
            rd.include((ServletRequest)request_p, (ServletResponse)response_p);
            handleRequestRenderStopWatch.stop();
            this.m_Context.endRequest();
        }
        catch (OwPendingSessionException e2) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"OwWebApplication.handleRequest: OwPendingSessionException, user clicked too fast, ignore second request.");
            }
            this.handleRequestPendingSessionException(context_p, request_p, response_p);
        }
        catch (SocketException e) {
            if (this.m_Context != null) {
                this.m_Context.endRequest();
            }
        }
        catch (Throwable e) {
            if (this.m_Context != null) {
                this.m_Context.endRequest();
            }
            if (LOG.isDebugEnabled()) {
                LOG.error((Object)("OwWebApplication.handleRequest: Request error, Thread = " + Thread.currentThread().getName() + ", Error = " + e.getMessage()), e);
            }
            this.printHandleRequestException(response_p.getWriter(), request_p.getRequestURI(), e, context_p);
            OwWebApplication.invalidateSessionObjects(request_p);
        }
        finally {
            NDC.pop();
            NDC.remove();
        }
    }

    protected void printHandleRequestPendingSessionException(PrintWriter out_p, OwAppContext context_p) {
        out_p.write("<html><head>");
        out_p.write("<meta http-equiv=\"refresh\" content=\"2\">");
        out_p.write("</head>");
        out_p.write("<body>");
        out_p.write(context_p.localize("ui.OwWebApplication.concurrentrequest", "Server is still busy with current request, please wait ..."));
        out_p.write("</body>");
        out_p.write("</html>");
        out_p.flush();
    }

    protected void handleRequestPendingSessionException(ServletContext srvContext, HttpServletRequest request, HttpServletResponse response) throws Exception {
        RequestDispatcher dispatcher = request.getRequestDispatcher(this.m_Context.getDesignDir() + "/serverBusy.jsp");
        dispatcher.forward((ServletRequest)request, (ServletResponse)response);
    }

    protected void printHandleRequestException(PrintWriter out_p, String resetUri_p, Throwable t_p) throws IOException {
        this.printHandleRequestException(out_p, resetUri_p, t_p, null);
    }

    protected void printHandleRequestException(PrintWriter out_p, String resetUri_p, Throwable t_p, ServletContext context_p) throws IOException {
        Locale locale = Locale.getDefault();
        if (this.m_Context != null) {
            locale = this.m_Context.getLocale();
        }
        out_p.write("<html><head>\n");
        out_p.write("<title>" + OwString.localize(locale, "app.OwMainAppContext.apptitle", "Alfresco Workdesk") + "</title>\n\n");
        out_p.write("<style type=\"text/css\">");
        out_p.write("body {\n");
        out_p.write("background-color: #DADBFE;\n");
        out_p.write("font: normal 12px Arial, Helvetica, sans-serif;\n");
        out_p.write("}\n");
        out_p.write("a.OwErrorStack {\n");
        out_p.write("font-weight: bold;\n");
        out_p.write("display: block;\n");
        out_p.write("background-color: #FFF7B0;\n");
        out_p.write("color: #cc0000;\n");
        out_p.write("border-top: 1px solid #8f9bac;\n");
        out_p.write("border-bottom: 1px solid #787895;\n");
        out_p.write("padding: 4px 10px;\n");
        out_p.write("}\n");
        out_p.write("</style>\n");
        out_p.write("<script language=\"JavaScript\" type=\"text/javascript\">\n");
        out_p.write("function toggleElementDisplay(id)\n");
        out_p.write("{\n");
        out_p.write("   var details = document.getElementById(id);\n");
        out_p.write("   if ( details )\n");
        out_p.write("   {\n");
        out_p.write("       if (details.style.display == 'none')\n");
        out_p.write("       {\n");
        out_p.write("           details.style.display = '';\n");
        out_p.write("       }\n");
        out_p.write("       else\n");
        out_p.write("       {\n");
        out_p.write("           details.style.display = 'none';\n");
        out_p.write("       }\n");
        out_p.write("   }\n");
        out_p.write("}\n");
        out_p.write("</script>\n");
        out_p.write("</head><body>\n\n");
        out_p.write("<BR>\n\n");
        out_p.write("<B>" + OwString.localize(locale, "app.OwMainAppContext.apptitle", "Alfresco Workdesk") + "</B> - Handle Request Exception...");
        out_p.write("<BR><BR>\n\n");
        out_p.write("<a href=\"");
        OwHTMLHelper.writeSecureHTML(out_p, resetUri_p);
        out_p.write("\">" + OwString.localize(locale, "ui.OwWebApplication.reset", "Reset") + "</a>");
        out_p.write("\n<br><br><br>\n");
        out_p.write("<b>Request Error:</b><br>");
        OwExceptionManager.PrintCatchedException(locale, t_p, out_p, "OwErrorStack");
        out_p.write("\n<br>\n");
        if (context_p != null && context_p.getAttribute("STARTUP_ERROR_KEY") != null) {
            out_p.write("<br>");
            out_p.write("<b>Startup / Configuration Error</b><br>");
            out_p.write("\n\n");
            OwExceptionManager.PrintCatchedException(locale, (Exception)context_p.getAttribute("STARTUP_ERROR_KEY"), out_p, "OwErrorStack", "owexceptiondetails1");
        }
        out_p.write("</body>\n");
        out_p.write("</html>");
        out_p.flush();
    }

    public OwAppContext getContext() {
        return this.m_Context;
    }
}

