/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ui.ua;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public enum OwOSFamily {
    WINDOWS("Windows", Pattern.compile("Windows")),
    OS_X("OS X", Pattern.compile("(Mac OS X|OS X)")),
    UNKNOWN("UNKNOWN", Pattern.compile("^$"));

    private static Map<String, OwOSFamily> familyByName;
    private final String familyName;
    private final Pattern pattern;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OwOSFamily fromFamilyName(String familyName) {
        Class<OwOSFamily> clazz = OwOSFamily.class;
        synchronized (OwOSFamily.class) {
            if (familyByName == null) {
                familyByName = Collections.synchronizedMap(new HashMap());
                OwOSFamily[] allFamilies = OwOSFamily.values();
                for (int i = 0; i < allFamilies.length; ++i) {
                    familyByName.put(allFamilies[i].getFamilyName(), allFamilies[i]);
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            OwOSFamily family = familyByName.get(familyName);
            if (family == null) {
                family = UNKNOWN;
            }
            return family;
        }
    }

    public static OwOSFamily findFirst(String userAgent) {
        if (userAgent == null) {
            return UNKNOWN;
        }
        OwOSFamily family = UNKNOWN;
        int start = Integer.MAX_VALUE;
        for (OwOSFamily familyValue : OwOSFamily.values()) {
            int matchStart;
            Matcher m;
            if (familyValue == UNKNOWN || !(m = familyValue.getPattern().matcher(userAgent)).find() || (matchStart = m.start()) >= start) continue;
            family = familyValue;
            start = matchStart;
        }
        return family;
    }

    public static OwOSFamily matchPattern(String family) {
        if (family == null) {
            return UNKNOWN;
        }
        for (OwOSFamily familyValue : OwOSFamily.values()) {
            Matcher m;
            if (familyValue == UNKNOWN || !(m = familyValue.getPattern().matcher(family)).matches()) continue;
            return familyValue;
        }
        return UNKNOWN;
    }

    public static OwOSFamily from(String family) {
        if (family == null) {
            return UNKNOWN;
        }
        OwOSFamily osFamily = UNKNOWN;
        osFamily = OwOSFamily.fromFamilyName(family);
        if (osFamily == UNKNOWN) {
            osFamily = OwOSFamily.matchPattern(family);
        }
        if (osFamily == UNKNOWN) {
            osFamily = OwOSFamily.findFirst(family);
        }
        if (osFamily == UNKNOWN) {
            OwOSFamily[] allFamilies = OwOSFamily.values();
            for (int i = 0; i < allFamilies.length; ++i) {
                if (!allFamilies[i].name().equals(family)) continue;
                osFamily = allFamilies[i];
                break;
            }
        }
        return osFamily;
    }

    private OwOSFamily(String familyName, Pattern pattern) {
        this.familyName = familyName;
        this.pattern = pattern;
    }

    public String getFamilyName() {
        return this.familyName;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    static {
        familyByName = null;
    }
}

