/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.util;

import com.wewebu.ow.server.util.OwString;
import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

public class OwDateTimeUtil {
    public static final int NUMBER_OF_WEEKDAYS = 7;
    public static final int NUMBER_OF_MONTHS = 12;

    public static Date setBeginOfDayTime(Date date_p) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date_p);
        calendar.set(14, 0);
        calendar.set(13, 0);
        calendar.set(12, 0);
        calendar.set(11, 0);
        return calendar.getTime();
    }

    public static Date setBeginOfNextDayTime(Date date_p) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date_p);
        calendar.set(13, 0);
        calendar.set(12, 0);
        calendar.set(11, 0);
        ((Calendar)calendar).add(5, 1);
        return calendar.getTime();
    }

    public static Date offsetDay(Date date_p, int iDays_p) {
        return OwDateTimeUtil.offsetDay(date_p, iDays_p, false);
    }

    public static Date offsetDay(Date date_p, int iDays_p, boolean dst_p) {
        long daysMillis = (long)iDays_p * 86400000L;
        if (dst_p) {
            Calendar c = Calendar.getInstance();
            c.setTime(date_p);
            TimeZone timeZone = c.getTimeZone();
            int startOffset = timeZone.getOffset(c.getTimeInMillis());
            long time = c.getTimeInMillis() + daysMillis;
            int endOffset = timeZone.getOffset(time);
            return new Date(time += (long)(startOffset - endOffset));
        }
        long time = date_p.getTime();
        return new Date(time + daysMillis);
    }

    public static Date setEndOfDayTime(Date date_p) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date_p);
        calendar.set(13, 59);
        calendar.set(12, 59);
        calendar.set(11, 23);
        return calendar.getTime();
    }

    public static String removeTimeFormatTokens(String sDateFormat_p) {
        String[] timeTokens = new String[]{"HH:mm:ss", "HH.mm.ss", "HH-mm-ss", "HH:mm", "hh:mm", "hh.mm", "HH.mm", "HH-mm", "h.mm", "K.mm", "h:mm", "K:mm", "HH", "mm", "ss", "()", "a"};
        return OwDateTimeUtil.removeTokens(sDateFormat_p, timeTokens);
    }

    public static String removeDateFormatTokens(String sDateFormat_p) {
        String[] dateTokens = new String[]{"yyyy.MM.dd"};
        return OwDateTimeUtil.removeTokens(sDateFormat_p, dateTokens);
    }

    private static String removeTokens(String aString_p, String[] tokens_p) {
        for (int i = 0; i < tokens_p.length; ++i) {
            aString_p = OwString.replaceAll(aString_p, tokens_p[i], "");
        }
        return aString_p.trim();
    }

    public static String[] getMonthNames(Locale locale_p) {
        String[] months = new String[]{OwString.localize(locale_p, "app.OwEditablePropertyDate.January", "January"), OwString.localize(locale_p, "app.OwEditablePropertyDate.February", "February"), OwString.localize(locale_p, "app.OwEditablePropertyDate.March", "March"), OwString.localize(locale_p, "app.OwEditablePropertyDate.April", "April"), OwString.localize(locale_p, "app.OwEditablePropertyDate.May", "May"), OwString.localize(locale_p, "app.OwEditablePropertyDate.June", "June"), OwString.localize(locale_p, "app.OwEditablePropertyDate.July", "July"), OwString.localize(locale_p, "app.OwEditablePropertyDate.August", "August"), OwString.localize(locale_p, "app.OwEditablePropertyDate.September", "September"), OwString.localize(locale_p, "app.OwEditablePropertyDate.October", "OCtober"), OwString.localize(locale_p, "app.OwEditablePropertyDate.November", "November"), OwString.localize(locale_p, "app.OwEditablePropertyDate.December", "December"), ""};
        return months;
    }

    public static String[] getShortMonthNames(Locale locale_p) {
        String[] monthNames = OwDateTimeUtil.getMonthNames(locale_p);
        return OwDateTimeUtil.shortenStrings(monthNames);
    }

    private static String[] shortenStrings(String[] stringsToBeShorthened_p) {
        String[] shortenedStrings = new String[stringsToBeShorthened_p.length];
        for (int i = 0; i < stringsToBeShorthened_p.length; ++i) {
            shortenedStrings[i] = stringsToBeShorthened_p[i].length() > 3 ? stringsToBeShorthened_p[i].substring(0, 3) : stringsToBeShorthened_p[i];
        }
        return shortenedStrings;
    }

    public static String[] getWeekDays(Locale locale_p) {
        String[] weekDayNames = new String[]{"", OwString.localize(locale_p, "app.OwEditablePropertyDate.Sunday", "Sonntag"), OwString.localize(locale_p, "app.OwEditablePropertyDate.Monday", "Montag"), OwString.localize(locale_p, "app.OwEditablePropertyDate.Tuesday", "Dienstag"), OwString.localize(locale_p, "app.OwEditablePropertyDate.Wednesday", "Mittwoch"), OwString.localize(locale_p, "app.OwEditablePropertyDate.Thursday", "Donnerstag"), OwString.localize(locale_p, "app.OwEditablePropertyDate.Friday", "Freitag"), OwString.localize(locale_p, "app.OwEditablePropertyDate.Saturday", "Samstag")};
        return weekDayNames;
    }

    public static String[] getShortWeekDays(Locale locale_p) {
        return OwDateTimeUtil.shortenStrings(OwDateTimeUtil.getWeekDays(locale_p));
    }

    public static SimpleDateFormat createDateFromat(Locale locale_p, String sDateFormat_p) {
        DateFormatSymbols dateFormatSymbols = new DateFormatSymbols(locale_p);
        dateFormatSymbols.setMonths(OwDateTimeUtil.getMonthNames(locale_p));
        dateFormatSymbols.setShortMonths(OwDateTimeUtil.getShortMonthNames(locale_p));
        dateFormatSymbols.setWeekdays(OwDateTimeUtil.getWeekDays(locale_p));
        dateFormatSymbols.setShortWeekdays(OwDateTimeUtil.getShortWeekDays(locale_p));
        SimpleDateFormat sdf = new SimpleDateFormat(sDateFormat_p, dateFormatSymbols);
        sdf.setLenient(false);
        return sdf;
    }

    public static Date convert(Date date_p, TimeZone fromTimeZone_p, TimeZone toTimeZone_p) {
        Date result = null;
        if (date_p != null) {
            result = OwDateTimeUtil.convertToCalendar(date_p, fromTimeZone_p, toTimeZone_p).getTime();
        }
        return result;
    }

    public static Calendar convertToCalendar(Date date_p, TimeZone fromTimeZone_p, TimeZone toTimeZone_p) {
        if (date_p == null) {
            return null;
        }
        Calendar dateCalendar = Calendar.getInstance();
        dateCalendar.setTime(date_p);
        Calendar from = Calendar.getInstance(fromTimeZone_p);
        from.set(14, dateCalendar.get(14));
        from.set(13, dateCalendar.get(13));
        from.set(12, dateCalendar.get(12));
        from.set(11, dateCalendar.get(11));
        from.set(1, dateCalendar.get(1));
        from.set(2, dateCalendar.get(2));
        from.set(5, dateCalendar.get(5));
        Calendar to = Calendar.getInstance(toTimeZone_p);
        to.setTime(from.getTime());
        Calendar resultCalendar = Calendar.getInstance();
        resultCalendar.set(14, to.get(14));
        resultCalendar.set(13, to.get(13));
        resultCalendar.set(12, to.get(12));
        resultCalendar.set(11, to.get(11));
        resultCalendar.set(1, to.get(1));
        resultCalendar.set(2, to.get(2));
        resultCalendar.set(5, to.get(5));
        return resultCalendar;
    }

    public static XMLGregorianCalendar convertToXMLGregorianCalendar(Date date_p, TimeZone fromTimeZone_p, TimeZone toTimeZone_p) throws DatatypeConfigurationException {
        if (date_p != null) {
            Calendar c = OwDateTimeUtil.convertToCalendar(date_p, fromTimeZone_p, toTimeZone_p);
            DatatypeFactory factory = DatatypeFactory.newInstance();
            if (c.getMinimum(2) == 0) {
                return factory.newXMLGregorianCalendar(c.get(1), c.get(2) + 1, c.get(5), c.get(11), c.get(12), c.get(13), c.get(14), toTimeZone_p.getRawOffset());
            }
            return factory.newXMLGregorianCalendar(c.get(1), c.get(2), c.get(5), c.get(11), c.get(12), c.get(13), c.get(14), toTimeZone_p.getRawOffset());
        }
        return null;
    }
}

