/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

public class OwEscapedStringTokenizer {
    public static final char STANDARD_DELIMITER = ';';
    public static final char STANDARD_ESCAPE = '\\';
    private char m_escape;
    private String m_text;
    private char m_delimiter;
    private int m_pos = 0;
    private String m_token;

    public OwEscapedStringTokenizer(String text_p, char delimiter_p, char escapechar_p) {
        this.m_escape = escapechar_p;
        this.m_text = text_p;
        this.m_delimiter = delimiter_p;
    }

    public OwEscapedStringTokenizer(String text_p) {
        this.m_escape = (char)92;
        this.m_text = text_p;
        if (this.m_text == null) {
            this.m_text = "";
        }
        this.m_delimiter = (char)59;
    }

    public boolean hasNext() {
        return this.m_pos < this.m_text.length();
    }

    public String next() {
        int ipos;
        boolean fEscape = false;
        for (ipos = this.m_pos; ipos < this.m_text.length(); ++ipos) {
            char c = this.m_text.charAt(ipos);
            if (fEscape) {
                fEscape = false;
                continue;
            }
            if (c != this.m_escape) continue;
            fEscape = true;
        }
        this.m_token = this.m_text.substring(this.m_pos, ipos);
        this.m_token = this.removeEscape(this.m_token);
        this.m_pos = ipos;
        return this.m_token;
    }

    public Collection toCollection() {
        Vector<String> ret = new Vector<String>();
        while (this.hasNext()) {
            ret.add(this.next());
        }
        return ret;
    }

    private String removeEscape(String text_p) {
        StringBuffer result = new StringBuffer();
        boolean fEscape = false;
        for (int i = 0; i < text_p.length(); ++i) {
            char c = text_p.charAt(i);
            if (fEscape) {
                fEscape = false;
                result.append(c);
                continue;
            }
            if (c == this.m_escape) {
                fEscape = true;
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    public static String createDelimitedString(Collection tokens_p) {
        return OwEscapedStringTokenizer.createDelimitedString(tokens_p, ';', '\\');
    }

    public static String createDelimitedString(Collection tokens_p, char delimiter_p, char escape_p) {
        StringBuffer result = new StringBuffer();
        Iterator it = tokens_p.iterator();
        while (it.hasNext()) {
            String token = (String)it.next();
            OwEscapedStringTokenizer.appendEscapedToken(result, token, delimiter_p, escape_p);
            if (!it.hasNext()) continue;
            result.append(delimiter_p);
        }
        return result.toString();
    }

    protected static void appendEscapedToken(StringBuffer buf_p, String token_p, char delimiter_p, char escape_p) {
        if (null == token_p) {
            return;
        }
        for (int i = 0; i < token_p.length(); ++i) {
            char c = token_p.charAt(i);
            if (c == delimiter_p || c == escape_p) {
                buf_p.append(escape_p);
                buf_p.append(c);
                continue;
            }
            buf_p.append(c);
        }
    }
}

