/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.util;

import com.wewebu.ow.server.app.OwConfiguration;
import com.wewebu.ow.server.log.OwLogCore;
import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class OwMimeTypes {
    private static final Logger LOG = OwLogCore.getLogger(OwConfiguration.class);
    protected static final OwFileObjectStatics m_MimeTypes = new OwFileObjectStatics();
    public static final String EXTENSION_FIELD = "extension-field";

    public static String getExtensionFromMime(String strMimeType_p) {
        if (strMimeType_p == null) {
            return null;
        }
        int iEmbededExtension = strMimeType_p.indexOf(EXTENSION_FIELD);
        if (-1 != iEmbededExtension) {
            return strMimeType_p.substring(iEmbededExtension + EXTENSION_FIELD.length()).toLowerCase();
        }
        return (String)OwMimeTypes.m_MimeTypes.m_MimeTypesToExtension.get(strMimeType_p);
    }

    public static String getMimeTypeFromExtension(String strExtension_p) {
        if (strExtension_p != null) {
            return (String)OwMimeTypes.m_MimeTypes.m_ExtensionToMimeTypes.get(strExtension_p.toLowerCase());
        }
        return null;
    }

    public static String getMimeParameter(String strMimeParameter_p, String strParameterName_p) {
        if (strMimeParameter_p == null) {
            return null;
        }
        int iIndex = strMimeParameter_p.indexOf(strParameterName_p);
        if (iIndex == -1) {
            return null;
        }
        StringBuffer ret = new StringBuffer();
        boolean fQuota = false;
        block5: for (int i = iIndex += strParameterName_p.length(); i < strMimeParameter_p.length(); ++i) {
            char c = strMimeParameter_p.charAt(i);
            switch (c) {
                case '=': {
                    if (!fQuota) continue block5;
                    ret.append(c);
                    continue block5;
                }
                case ';': {
                    if (fQuota) {
                        ret.append(c);
                        continue block5;
                    }
                    i = strMimeParameter_p.length();
                    continue block5;
                }
                case '\"': {
                    fQuota = !fQuota;
                    continue block5;
                }
                default: {
                    ret.append(c);
                }
            }
        }
        return ret.toString();
    }

    public static void loadFromUrl(URL propsURL_p) throws Exception {
        OwMimeTypes.m_MimeTypes.loadFromUrl(propsURL_p);
    }

    protected static class OwFileObjectStatics {
        public Map m_ExtensionToMimeTypes = new HashMap();
        public Map m_MimeTypesToExtension;

        private OwFileObjectStatics() {
            this.m_ExtensionToMimeTypes.put("owc", "ow/customobject");
            this.m_ExtensionToMimeTypes.put("vst", "application/x-visio");
            this.m_ExtensionToMimeTypes.put("vsd", "application/visio");
            this.m_ExtensionToMimeTypes.put("vnd", "application/vnd.visio");
            this.m_ExtensionToMimeTypes.put("txt", "text/plain");
            this.m_ExtensionToMimeTypes.put("gif", "image/gif");
            this.m_ExtensionToMimeTypes.put("png", "image/png");
            this.m_ExtensionToMimeTypes.put("msg", "application/msoutlook");
            this.m_ExtensionToMimeTypes.put("xls", "application/msexcel");
            this.m_ExtensionToMimeTypes.put("doc", "application/msword");
            this.m_ExtensionToMimeTypes.put("ppt", "application/mspowerpoint");
            this.m_ExtensionToMimeTypes.put("mdb", "application/msaccess");
            this.m_ExtensionToMimeTypes.put("jpg", "image/jpeg");
            this.m_ExtensionToMimeTypes.put("jpeg", "image/jpeg");
            this.m_ExtensionToMimeTypes.put("jpe", "image/jpeg");
            this.m_ExtensionToMimeTypes.put("pdf", "application/pdf");
            this.m_ExtensionToMimeTypes.put("tif", "image/tif");
            this.m_ExtensionToMimeTypes.put("tiff", "image/tiff");
            this.m_ExtensionToMimeTypes.put("afp", "application/afp");
            this.m_ExtensionToMimeTypes.put("htm", "text/html");
            this.m_ExtensionToMimeTypes.put("html", "text/html");
            this.m_ExtensionToMimeTypes.put("shtml", "text/html");
            this.m_ExtensionToMimeTypes.put("rtf", "text/rtf");
            this.m_ExtensionToMimeTypes.put("zip", "application/zip");
            this.m_ExtensionToMimeTypes.put("css", "text/css");
            this.m_ExtensionToMimeTypes.put("rtx", "text/richtext");
            this.m_ExtensionToMimeTypes.put("js", "text/javascript");
            this.m_ExtensionToMimeTypes.put("pnm", "image/x-portable-anymap");
            this.m_ExtensionToMimeTypes.put("pbm", "image/x-portable-bitmap");
            this.m_ExtensionToMimeTypes.put("pgm", "image/x-portable-graymap");
            this.m_ExtensionToMimeTypes.put("ppm", "image/x-portable-pixmap");
            this.m_ExtensionToMimeTypes.put("bmp", "image/bmp");
            this.m_ExtensionToMimeTypes.put("url", "text/url");
            this.m_ExtensionToMimeTypes.put("swf", "application/x-shockwave-flash");
            this.m_ExtensionToMimeTypes.put("xml", "text/xml");
            this.m_ExtensionToMimeTypes.put("docx", "application/vnd.openxmlformats-officedocument.wordprocessingml.document");
            this.m_ExtensionToMimeTypes.put("xlsx", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            this.m_ExtensionToMimeTypes.put("pptx", "application/vnd.openxmlformats-officedocument.presentationml.presentation");
            this.createMime2TypeExtension();
        }

        private void createMime2TypeExtension() {
            this.m_MimeTypesToExtension = new HashMap();
            for (Object key : this.m_ExtensionToMimeTypes.keySet()) {
                this.m_MimeTypesToExtension.put(this.m_ExtensionToMimeTypes.get(key), key);
            }
        }

        private void loadFromUrl(URL propsURL_p) throws Exception {
            if (propsURL_p != null) {
                Properties props = new Properties();
                File propsFile = new File(propsURL_p.getFile());
                if (propsFile.exists()) {
                    props.load(propsURL_p.openStream());
                    this.m_ExtensionToMimeTypes.putAll(props);
                    this.createMime2TypeExtension();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("OwMimeTypes: MIME mapping is loaded and initialized from the " + propsFile.getAbsolutePath() + " file..."));
                    }
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("OwMimeTypes: No custom '" + propsFile.getName() + "' file found. Using of default MIME mappings from OwMimeTypes class..."));
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"OwMimeTypes: the URL used to initialized the MIME mapping is null...");
            }
        }
    }
}

