/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.util;

import com.wewebu.ow.server.log.OwLogCore;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.io.Reader;
import java.net.URL;
import java.util.Properties;
import org.apache.log4j.Logger;

public class OwResourceProperties
extends Properties {
    private static final Logger LOG = OwLogCore.getLogger(OwResourceProperties.class);
    private static final long serialVersionUID = 1L;
    public static final int BOM_SIZE = 4;
    private static final String DEFAULT_ENC = "ISO-8859-1";
    private String encoding;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(URL resource_p) throws IOException {
        InputStream is = null;
        PushbackInputStream inPush = null;
        try {
            is = resource_p.openStream();
            if (is == null) {
                throw new NullPointerException(resource_p.toString());
            }
            inPush = new PushbackInputStream(is, 4);
            this.encoding = OwResourceProperties.getResourceEncoding(inPush);
            if (this.encoding != null) {
                this.load(new InputStreamReader((InputStream)inPush, this.encoding));
            } else {
                this.encoding = DEFAULT_ENC;
                this.load(new InputStreamReader(inPush));
            }
        }
        finally {
            if (inPush != null) {
                inPush.close();
            }
        }
    }

    @Override
    public void load(Reader reader_p) throws IOException {
        int iChar = 0;
        boolean comment = false;
        while ((iChar = reader_p.read()) > 0) {
            char c;
            if (iChar == 35) {
                comment = true;
            }
            if (iChar == 10 || iChar == 13 || comment) {
                if (iChar != 10 && iChar != 13) continue;
                comment = false;
                continue;
            }
            StringBuilder bufKey = new StringBuilder();
            StringBuilder bufVal = new StringBuilder();
            boolean escaped = false;
            while (iChar > 0) {
                c = (char)iChar;
                if (!escaped && (c == '=' || c == ' ' || c == ':') || (c == '\f' || c == '\t' || c == '\n' || c == '\r') && !escaped) break;
                escaped = c == '\\';
                if (!escaped) {
                    bufKey.append(c);
                }
                iChar = reader_p.read();
            }
            escaped = false;
            iChar = reader_p.read();
            while (iChar > 0 && ((c = (char)iChar) != '\r' && c != '\n' || escaped)) {
                if (c == '\\') {
                    escaped = !escaped;
                } else {
                    boolean bl = escaped ? c == '\r' || c == '\n' : (escaped = false);
                }
                if (!escaped) {
                    bufVal.append(c);
                }
                iChar = reader_p.read();
            }
            this.put(bufKey.toString().trim(), bufVal.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getResourceEncoding(URL url_p) throws IOException {
        String retEnc = null;
        BufferedInputStream buffIn = null;
        try {
            buffIn = new BufferedInputStream(url_p.openStream());
            byte[] bom = new byte[4];
            int readedBom = buffIn.read(bom);
            retEnc = OwResourceProperties.getResourceEncoding(bom);
            if (LOG.isDebugEnabled() && retEnc == null) {
                LOG.debug((Object)("OwResourceProperties.getResourceEncoding(URL=" + url_p + "): Unkown encoding, (Readed BOM=" + readedBom + ")..."));
            }
        }
        finally {
            if (buffIn != null) {
                buffIn.close();
                buffIn = null;
            }
        }
        return retEnc;
    }

    public static String getResourceEncoding(byte[] analyse_p) {
        String fileEncoding = null;
        fileEncoding = analyse_p[0] == 0 && analyse_p[1] == 0 && analyse_p[2] == -2 && analyse_p[3] == -1 ? "UTF-32BE" : (analyse_p[0] == -1 && analyse_p[1] == -2 && analyse_p[2] == 0 && analyse_p[3] == 0 ? "UTF-32LE" : (analyse_p[0] == -17 && analyse_p[1] == -69 && analyse_p[2] == -65 ? "UTF-8" : (analyse_p[0] == -2 && analyse_p[1] == -1 ? "UTF-16BE" : (analyse_p[0] == -1 && analyse_p[1] == -2 ? "UTF-16LE" : null))));
        return fileEncoding;
    }

    public static String getResourceEncoding(PushbackInputStream pushStream) throws IOException {
        byte[] bom = new byte[4];
        int n = pushStream.read(bom, 0, bom.length);
        String encoding = OwResourceProperties.getResourceEncoding(bom);
        int unread = "UTF-32BE".equals(encoding) ? n - 4 : ("UTF-32LE".equals(encoding) ? n - 4 : ("UTF-8".equals(encoding) ? n - 3 : ("UTF-16BE".equals(encoding) ? n - 2 : ("UTF-16LE".equals(encoding) ? n - 2 : n))));
        if (unread > 0) {
            pushStream.unread(bom, n - unread, unread);
        }
        return encoding;
    }
}

