/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.util;

import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.util.OwUnicodeInputStream;
import com.wewebu.ow.server.util.OwXMLDOMUtil;
import com.wewebu.ow.server.util.OwXMLUtil;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class OwStandardXMLUtil
implements OwXMLUtil {
    private static final Logger LOG = OwLogCore.getLogger(OwStandardXMLUtil.class);
    public static final String DEPTH_FIRST_PREORDER = "depth_first_preorder";
    public static final String WIDTH_FIRST_LEVEL_ORDER = "width_first_level_order";
    private Node m_Node;
    private HashMap m_ValueNodeMap;
    private String m_FileEncoding = "UTF-8";

    public OwStandardXMLUtil() throws Exception {
        Document doc = OwXMLDOMUtil.getNewDocument();
        Element rootNode = doc.createElementNS("", "empty");
        this.setNode(rootNode);
    }

    public OwStandardXMLUtil(Node node_p) throws Exception {
        this.setNode(node_p);
    }

    public OwStandardXMLUtil(InputStream inputStream_p, String strRootNodeName_p) throws Exception {
        this(inputStream_p, strRootNodeName_p, DEPTH_FIRST_PREORDER);
    }

    /*
     * Enabled aggressive block sorting
     */
    public OwStandardXMLUtil(InputStream inputStream_p, String strRootNodeName_p, String rootSearchMode_p) throws Exception {
        OwUnicodeInputStream uin = new OwUnicodeInputStream(inputStream_p, this.m_FileEncoding);
        this.m_FileEncoding = uin.getEncoding();
        this.setFileEncoding(this.m_FileEncoding);
        InputStreamReader in = this.m_FileEncoding == null ? new InputStreamReader(uin) : new InputStreamReader((InputStream)uin, this.m_FileEncoding);
        DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document doc = db.parse(new InputSource(in));
        OwXMLDOMUtil.initialize(doc);
        if (strRootNodeName_p == null) {
            this.setNode(doc.getDocumentElement());
            return;
        }
        if (DEPTH_FIRST_PREORDER.equals(rootSearchMode_p)) {
            NodeList Nodes = doc.getElementsByTagName(strRootNodeName_p);
            this.setNode(Nodes.item(0));
            return;
        }
        if (!WIDTH_FIRST_LEVEL_ORDER.equals(rootSearchMode_p)) {
            String msg = "OwStandardXMLUtil: Invalid rootSearchMode_p mode=" + rootSearchMode_p + ". Expected one of DEPTH_FIRST_PREORDER = \"" + DEPTH_FIRST_PREORDER + "\" or WIDTH_FIRST_LEVEL_ORDER = \"" + WIDTH_FIRST_LEVEL_ORDER + "\"";
            LOG.error((Object)msg);
            throw new OwInvalidOperationException(msg);
        }
        Element rootNode = doc.getDocumentElement();
        LinkedList<Node> nodesFifo = new LinkedList<Node>();
        nodesFifo.addFirst(rootNode);
        Node foundNode = null;
        while (!nodesFifo.isEmpty() && foundNode == null) {
            Node currentNode = (Node)nodesFifo.removeLast();
            if (strRootNodeName_p.equals(currentNode.getNodeName()) || strRootNodeName_p.equals(currentNode.getLocalName())) {
                foundNode = currentNode;
                continue;
            }
            NodeList currentChildren = currentNode.getChildNodes();
            int childrenCount = currentChildren.getLength();
            for (int i = 0; i < childrenCount; ++i) {
                nodesFifo.addFirst(currentChildren.item(i));
            }
        }
        this.setNode(foundNode);
    }

    protected String getKeyName(Node node_p) {
        return node_p.getNodeName();
    }

    @Override
    public List getSafeStringList() {
        return OwXMLDOMUtil.getSafeStringList(this.getNode());
    }

    @Override
    public List getSafeCDATAList() {
        return OwXMLDOMUtil.getSafeCDATAList(this.getNode());
    }

    @Override
    public List getSafeCDATAList(String strNodeName_p) {
        try {
            return OwXMLDOMUtil.getSafeCDATAList(this.getSubNode(strNodeName_p));
        }
        catch (Exception e) {
            return new LinkedList();
        }
    }

    @Override
    public List getSafeStringList(String strNodeName_p) {
        try {
            return OwXMLDOMUtil.getSafeStringList(this.getSubNode(strNodeName_p));
        }
        catch (Exception e) {
            return new LinkedList();
        }
    }

    @Override
    public Set getSafeStringSet(String strNodeName_p) {
        try {
            return OwXMLDOMUtil.getSafeStringSet(this.getSubNode(strNodeName_p));
        }
        catch (Exception e) {
            return new HashSet();
        }
    }

    @Override
    public String getSafeStringAttributeValue(String strAttributeName_p, String strDefault_p) {
        try {
            String sRet = this.m_Node.getAttributes().getNamedItem(strAttributeName_p).getNodeValue();
            if (sRet.length() > 0) {
                return sRet;
            }
            return strDefault_p;
        }
        catch (Exception e) {
            return strDefault_p;
        }
    }

    @Override
    public int getSafeIntegerAttributeValue(String strAttributeName_p, int iDefault_p) {
        try {
            String sRet = this.m_Node.getAttributes().getNamedItem(strAttributeName_p).getNodeValue();
            if (sRet.length() > 0) {
                return Integer.parseInt(sRet);
            }
            return iDefault_p;
        }
        catch (Exception e) {
            return iDefault_p;
        }
    }

    @Override
    public boolean getSafeBooleanAttributeValue(String strAttributeName_p, boolean fDefault_p) {
        return OwXMLDOMUtil.getSafeBooleanAttributeValue(this.m_Node, strAttributeName_p, fDefault_p);
    }

    @Override
    public boolean getSafeBooleanValue(String strNodeName_p, boolean fDefault_p) {
        try {
            return this.getSubNode(strNodeName_p).getFirstChild().getNodeValue().equalsIgnoreCase("true");
        }
        catch (Exception e) {
            return fDefault_p;
        }
    }

    @Override
    public URL getURLFromNode(String nodeName_p) throws MalformedURLException {
        String nodeText = null;
        nodeText = this.getSafeTextValue(nodeName_p, null);
        return new URL(nodeText);
    }

    @Override
    public int getSafeIntegerValue(String strNodeName_p, int fDefault_p) {
        try {
            return Integer.parseInt(this.getSubNode(strNodeName_p).getFirstChild().getNodeValue());
        }
        catch (Exception e) {
            return fDefault_p;
        }
    }

    @Override
    public String getSafeTextValue(String strNodeName_p, String strDefault_p) {
        try {
            return this.getSubNode(strNodeName_p).getFirstChild().getNodeValue();
        }
        catch (Exception e) {
            return strDefault_p;
        }
    }

    @Override
    public String getSafeTextValue(String strDefault_p) {
        try {
            return this.m_Node.getFirstChild().getNodeValue();
        }
        catch (Exception e) {
            return strDefault_p;
        }
    }

    @Override
    public Node getNode() {
        return this.m_Node;
    }

    protected void setNode(Node node_p) {
        this.m_Node = node_p;
        this.m_ValueNodeMap = new HashMap();
        for (Node n = node_p.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (n.getNodeType() != 1) continue;
            this.m_ValueNodeMap.put(this.getKeyName(n), n);
        }
    }

    @Override
    public Node getSubNode(String strNodeName_p) throws Exception {
        return (Node)this.m_ValueNodeMap.get(strNodeName_p);
    }

    @Override
    public List getSafeNodeList() {
        return OwXMLDOMUtil.getSafeNodeList(this.getNode());
    }

    @Override
    public List getSafeNodeList(String strNodeName_p) {
        try {
            return OwXMLDOMUtil.getSafeNodeList(this.getSubNode(strNodeName_p));
        }
        catch (Exception e) {
            return new LinkedList();
        }
    }

    @Override
    public void writeHtmlDump(Writer w_p) throws Exception {
        OwXMLDOMUtil.writeHtmlDump(w_p, this.m_Node);
    }

    @Override
    public List getSafeUtilList(String nodeName_p, String itemName_p) {
        LinkedList<OwStandardXMLUtil> list = new LinkedList<OwStandardXMLUtil>();
        try {
            Node subnode = this.getSubNode(nodeName_p);
            for (Node n = subnode.getFirstChild(); n != null; n = n.getNextSibling()) {
                if (n.getNodeType() != 1 || null != itemName_p && !itemName_p.equals(n.getNodeName())) continue;
                list.add(new OwStandardXMLUtil(n));
            }
        }
        catch (Exception e) {
            return list;
        }
        return list;
    }

    @Override
    public List getSafeUtilList(String itemName_p) {
        LinkedList<OwStandardXMLUtil> list = new LinkedList<OwStandardXMLUtil>();
        try {
            Node subnode = this.getNode();
            for (Node n = subnode.getFirstChild(); n != null; n = n.getNextSibling()) {
                if (n.getNodeType() != 1 || null != itemName_p && !itemName_p.equals(n.getNodeName())) continue;
                list.add(new OwStandardXMLUtil(n));
            }
        }
        catch (Exception e) {
            return list;
        }
        return list;
    }

    @Override
    public OwXMLUtil getSubUtil(String strName_p) throws Exception {
        Node n = (Node)this.m_ValueNodeMap.get(strName_p);
        if (null == n) {
            return null;
        }
        return new OwStandardXMLUtil(n);
    }

    public String getFileEncoding() {
        return this.m_FileEncoding;
    }

    public void setFileEncoding(String mFileEncoding_p) {
        this.m_FileEncoding = mFileEncoding_p;
    }
}

