/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.util;

import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.util.OwDebugModeException;
import com.wewebu.ow.server.util.OwResourceProperties;
import com.wewebu.ow.server.util.OwXMLDOMUtil;
import com.wewebu.ow.server.util.OwXMLUtil;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import org.w3c.dom.Node;

public class OwStringProperties {
    private static final String[] DEFAULT_RESOURCE_NAMES = new String[]{"oecmlocalize", "zioilocalize", "oecmcustomlocalize"};
    private static final Logger LOG = OwLogCore.getLogger(OwStringProperties.class);
    private static OwStringProperties instance;
    private ConcurrentHashMap<String, Hashtable> m_locals = new ConcurrentHashMap();
    private String[] resourceNames = DEFAULT_RESOURCE_NAMES;

    private OwStringProperties() {
    }

    private String[] getResourceNames() {
        return this.resourceNames;
    }

    public Hashtable getProperties(Locale local_p) throws OwDebugModeException {
        Hashtable ret = this.m_locals.get(local_p.toString());
        if (ret == null) {
            ret = this.createProperties(local_p.toString());
        }
        return ret;
    }

    private Hashtable createProperties(String locale_p) throws OwDebugModeException {
        if (locale_p.equalsIgnoreCase("debugmode")) {
            throw new OwDebugModeException();
        }
        return this.createPropertiesSync(locale_p);
    }

    private synchronized Hashtable createPropertiesSync(String locale_p) {
        Hashtable ret = this.m_locals.get(locale_p);
        if (null != ret) {
            return ret;
        }
        ret = new Hashtable();
        String[] resourceNames = this.getResourceNames();
        for (int i = 0; i < resourceNames.length; ++i) {
            this.loadProperties(locale_p, resourceNames[i], ret);
        }
        this.m_locals.put(locale_p, ret);
        return ret;
    }

    private void loadProperties(String locale_p, String name_p, Hashtable props_p) {
        String mapname = name_p + "_" + locale_p + ".properties";
        try {
            OwResourceProperties temp = new OwResourceProperties();
            temp.load(this.getClass().getResource("/" + mapname));
            props_p.putAll(temp);
        }
        catch (Exception e) {
            LOG.debug((Object)("OwString.loadProperties: Textmap [" + mapname + "] was not found."));
        }
    }

    public static synchronized void initialize(OwXMLUtil bootConfig) {
        if (instance == null) {
            instance = new OwStringProperties();
        }
        instance.init(bootConfig);
    }

    private void init(OwXMLUtil bootstrapConfig_p) {
        String strDisplayName = "";
        LinkedList<String> resourceFileNames = new LinkedList<String>();
        resourceFileNames.addAll(Arrays.asList(DEFAULT_RESOURCE_NAMES));
        List fileList = bootstrapConfig_p.getSafeNodeList("availablelocalizeFiles");
        for (Node langNode : fileList) {
            strDisplayName = OwXMLDOMUtil.getSafeStringAttributeValue(langNode, "fileName", "");
            resourceFileNames.add(strDisplayName);
        }
        this.resourceNames = resourceFileNames.toArray(new String[resourceFileNames.size()]);
    }

    public static synchronized OwStringProperties getInstance() {
        if (instance == null) {
            instance = new OwStringProperties();
        }
        return instance;
    }

    public void putAll(Locale locale_p, Map properties_p) throws OwDebugModeException {
        this.getProperties(locale_p).putAll(properties_p);
    }

    public void putLabel(Locale local_p, String key_p, String label_p) throws OwDebugModeException {
        this.getProperties(local_p).put("owlabel." + key_p, label_p);
    }
}

