/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.util.jar;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedDataParser;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.bc.BcDigestCalculatorProvider;
import org.bouncycastle.util.Selector;
import org.bouncycastle.util.Store;

public class OwJarVerifier {
    private static final String ALFRESCO_CODESIGN_CER = "alfresco-code-sign-public.cer";
    private static X509Certificate weWebUCert;
    private URL jarURL = null;
    private JarFile jarFile = null;

    public OwJarVerifier(URL jarURL_p) {
        this.jarURL = jarURL_p;
        try {
            if (this.jarFile == null) {
                this.jarFile = this.retrieveJarFileFromURL(jarURL_p);
            }
        }
        catch (Exception ex) {
            SecurityException se = new SecurityException();
            se.initCause(ex);
            throw se;
        }
    }

    private JarFile retrieveJarFileFromURL(URL url_p) throws PrivilegedActionException, MalformedURLException {
        JarFile jf = null;
        this.jarURL = url_p.getProtocol().equalsIgnoreCase("jar") ? url_p : new URL("jar:" + url_p.toString() + "!/");
        jf = (JarFile)AccessController.doPrivileged(new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                JarURLConnection conn = (JarURLConnection)OwJarVerifier.this.jarURL.openConnection();
                conn.setUseCaches(false);
                return conn.getJarFile();
            }
        });
        return jf;
    }

    public void verify(X509Certificate targetCert_p) throws IOException {
        if (targetCert_p == null) {
            throw new SecurityException("Provider certificate is invalid");
        }
        Vector<JarEntry> entriesVec = new Vector<JarEntry>();
        Manifest man = this.jarFile.getManifest();
        if (man == null) {
            throw new SecurityException("The provider is not signed");
        }
        byte[] buffer = new byte[8192];
        Enumeration<JarEntry> entries = this.jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry je = entries.nextElement();
            if (je.isDirectory()) continue;
            entriesVec.addElement(je);
            InputStream is = this.jarFile.getInputStream(je);
            while (is.read(buffer, 0, buffer.length) != -1) {
            }
            is.close();
        }
        Enumeration e = entriesVec.elements();
        while (e.hasMoreElements()) {
            X509Certificate[] certChain;
            JarEntry je = (JarEntry)e.nextElement();
            Certificate[] certs = je.getCertificates();
            if (certs == null || certs.length == 0) {
                if (je.getName().startsWith("META-INF")) continue;
                throw new SecurityException("The file " + je.getName() + " is not signed!");
            }
            int startIndex = 0;
            boolean signedAsExpected = false;
            while ((certChain = OwJarVerifier.getAChain(certs, startIndex)) != null) {
                if (certChain[0].equals(targetCert_p)) {
                    signedAsExpected = true;
                    break;
                }
                startIndex += certChain.length;
            }
            if (signedAsExpected) continue;
            throw new SecurityException("The provider is not signed by a trusted signer");
        }
    }

    private static X509Certificate[] getAChain(Certificate[] certs_p, int startIndex_p) {
        int i;
        if (startIndex_p > certs_p.length - 1) {
            return null;
        }
        for (i = startIndex_p; i < certs_p.length - 1 && ((Object)((X509Certificate)certs_p[i + 1]).getSubjectDN()).equals(((X509Certificate)certs_p[i]).getIssuerDN()); ++i) {
        }
        int certChainSize = i - startIndex_p + 1;
        X509Certificate[] ret = new X509Certificate[certChainSize];
        for (int j = 0; j < certChainSize; ++j) {
            ret[j] = (X509Certificate)certs_p[startIndex_p + j];
        }
        return ret;
    }

    protected void finalize() throws Throwable {
        this.jarFile.close();
    }

    public boolean isSigned() {
        try {
            Manifest manifest = this.jarFile.getManifest();
            if (null == manifest) {
                return false;
            }
            JarEntry signatureBlockEntry = this.getSignatureBlockEntry();
            return null != signatureBlockEntry;
        }
        catch (IOException e) {
            SecurityException securityException = new SecurityException();
            securityException.initCause(e);
            throw securityException;
        }
    }

    private JarEntry getSignatureBlockEntry() {
        JarEntry signatureBlockEntry = null;
        Enumeration<JarEntry> entries = this.jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            String entryName = entry.getName();
            if (!entryName.startsWith("META-INF") || !entryName.endsWith("RSA") && !entryName.endsWith("DSA")) continue;
            signatureBlockEntry = entry;
            break;
        }
        return signatureBlockEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public X509CertificateHolder[] getSignatureCertificates() throws IOException, CMSException {
        JarEntry signatureBlockEntry = this.getSignatureBlockEntry();
        if (null != signatureBlockEntry) {
            InputStream inputStream = null;
            OutputStream arrayOutputStream = null;
            try {
                inputStream = this.jarFile.getInputStream(signatureBlockEntry);
                CMSSignedDataParser sp = new CMSSignedDataParser((DigestCalculatorProvider)new BcDigestCalculatorProvider(), (InputStream)new BufferedInputStream(inputStream, 1024));
                Store certStore = sp.getCertificates();
                SignerInformationStore signers = sp.getSignerInfos();
                Collection c = signers.getSigners();
                Iterator it = c.iterator();
                ArrayList<X509CertificateHolder> certificates = new ArrayList<X509CertificateHolder>();
                while (it.hasNext()) {
                    SignerInformation signer = (SignerInformation)it.next();
                    Collection certCollection = certStore.getMatches((Selector)signer.getSID());
                    Iterator certIt = certCollection.iterator();
                    X509CertificateHolder cert = (X509CertificateHolder)certIt.next();
                    certificates.add(cert);
                }
                X509CertificateHolder[] x509CertificateHolderArray = certificates.toArray(new X509CertificateHolder[certificates.size()]);
                return x509CertificateHolderArray;
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException ex) {}
                }
                inputStream = null;
                if (arrayOutputStream != null) {
                    try {
                        arrayOutputStream.flush();
                        ((ByteArrayOutputStream)arrayOutputStream).close();
                    }
                    catch (IOException ex) {}
                }
                arrayOutputStream = null;
            }
        }
        return new X509CertificateHolder[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static X509Certificate getWeWebUCertificate() throws IOException, CertificateException {
        if (null == weWebUCert) {
            InputStream inStream = null;
            try {
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                URL url = OwJarVerifier.class.getResource("/alfresco-code-sign-public.cer");
                System.err.println(String.format("Loading certificate from %s.", url));
                inStream = url.openStream();
                weWebUCert = (X509Certificate)cf.generateCertificate(inStream);
            }
            finally {
                if (inStream != null) {
                    try {
                        inStream.close();
                    }
                    catch (IOException iOException) {}
                    inStream = null;
                }
            }
        }
        return weWebUCert;
    }
}

