/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.util.ldap;

import com.wewebu.ow.server.ecm.OwObjectCollection;
import com.wewebu.ow.server.ecm.OwUserInfo;
import com.wewebu.ow.server.exceptions.OwAuthenticationException;
import com.wewebu.ow.server.exceptions.OwConfigurationException;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.util.ldap.OwADSchemaInterpreter;
import com.wewebu.ow.server.util.ldap.OwLdapConnection;
import com.wewebu.ow.server.util.ldap.OwLdapSchemaInterpreter;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import javax.naming.AuthenticationException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.directory.InitialDirContext;
import org.apache.log4j.Logger;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

public class OwLdapConnector {
    private static final Logger LOG = OwLogCore.getLogger(OwLdapConnector.class);
    public static final String USERS_DIRECTORY_PROPERTY = "UsersDirectory";
    private OwLdapSchemaInterpreter m_schemaInterpreter = null;
    private Properties m_ldapProperties;
    private Properties m_ldapAdminProperties;
    private int m_recursionLevel = 0;
    public static final String ELEMENT_SCHEMA_INTERPRETER = "SchemaInterpreter";
    public static final String USER_DN_PROPERTY = "com.wewebu.ow.user.dn";

    public OwLdapConnector(Properties props_p, int recursionLevel_p) {
        this.m_ldapProperties = props_p;
        this.m_ldapAdminProperties = props_p;
        this.m_recursionLevel = recursionLevel_p;
        this.initialize();
    }

    public OwLdapConnector(Node configNode_p) {
        this.m_ldapProperties = new Properties();
        this.m_ldapAdminProperties = new Properties();
        for (Node n = configNode_p.getFirstChild(); n != null; n = n.getNextSibling()) {
            Node textNode;
            if (n.getNodeType() != 1 || null == (textNode = n.getFirstChild())) continue;
            String sValue = n.getFirstChild().getNodeValue().trim();
            String sName = n.getNodeName();
            this.m_ldapProperties.put(sName, sValue);
            this.m_ldapAdminProperties.put(sName, sValue);
        }
        Node recursionLevelNode = configNode_p.getAttributes().getNamedItem("recursionlevel");
        if (recursionLevelNode != null) {
            try {
                String recursionLevel = recursionLevelNode.getNodeValue();
                this.m_recursionLevel = new Integer(recursionLevel);
            }
            catch (NumberFormatException e) {
                LOG.error((Object)"The recursionlevel level of the LDAP connector is not valid. The recursion level is set to, level=0.", (Throwable)e);
            }
            catch (DOMException e) {
                LOG.error((Object)"Exception reading the recursionlevel level of the LDAP connector from the bootstrap.xml.", (Throwable)e);
            }
        }
        this.initialize();
    }

    private void initialize() {
        String interpreterClassName = this.getProperties(true).getProperty(ELEMENT_SCHEMA_INTERPRETER, null);
        if (interpreterClassName != null) {
            try {
                Class<?> interpreterClass = Class.forName(interpreterClassName);
                this.m_schemaInterpreter = (OwLdapSchemaInterpreter)interpreterClass.newInstance();
            }
            catch (Exception e) {
                LOG.error((Object)("Invalid LDAP interpreter class " + interpreterClassName + " will use standard AD interpreter!"), (Throwable)e);
            }
        }
        if (this.m_schemaInterpreter == null) {
            this.m_schemaInterpreter = new OwADSchemaInterpreter();
        }
        try {
            this.m_schemaInterpreter.init(this.getProperties(false), this.getProperties(true));
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to initialize properties in " + this.m_schemaInterpreter), (Throwable)e);
        }
    }

    public OwLdapConnection createConnection(boolean adminConnection_p) {
        return new OwLdapConnection(this.getProperties(adminConnection_p), this.getRecursionLevel());
    }

    public Properties getProperties() {
        return this.getProperties(false);
    }

    protected Properties getProperties(boolean admin_p) {
        return admin_p ? this.m_ldapAdminProperties : this.m_ldapProperties;
    }

    public void authenticate(String userName_p, String password_p) throws OwAuthenticationException, OwConfigurationException {
        if (userName_p == null || userName_p.length() == 0 || password_p == null || password_p.length() == 0) {
            throw new OwAuthenticationException("OwLdapConnector.authenticate: Authentication Exception, the username or password is empty...");
        }
        InitialContext ctx = null;
        try {
            this.prepareForAuthentication(userName_p, password_p);
            ctx = new InitialDirContext(this.getProperties());
        }
        catch (AuthenticationException e) {
            String msg = "Exception creating InitialDirContext for LDAP. Could not authenticate the user, Username = " + userName_p;
            LOG.debug((Object)msg, (Throwable)e);
            throw new OwAuthenticationException(msg, (Throwable)e);
        }
        catch (NamingException e) {
            String msg = "Exception creating InitialDirContext for LDAP. Maybe something is wrong with the configuration, Username = " + userName_p;
            LOG.debug((Object)msg, (Throwable)e);
            throw new OwAuthenticationException(msg, (Throwable)e);
        }
        catch (OwAuthenticationException e) {
            throw e;
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (NamingException e) {}
                ctx = null;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("OwLdapConnector.authenticate: Authentication successfully done, Username = " + userName_p));
        }
    }

    protected void prepareForAuthentication(String userName_p, String password_p) throws OwAuthenticationException, OwConfigurationException {
        String distinguishedName = this.findDistinguishedNameAnonymously(userName_p);
        Properties userProp = this.getProperties();
        userProp.put("java.naming.security.principal", distinguishedName);
        userProp.put("java.naming.security.credentials", password_p);
        userProp.put(USER_DN_PROPERTY, distinguishedName);
        this.getProperties(true).put(USER_DN_PROPERTY, distinguishedName);
    }

    public Collection getShortGroupNames() throws OwAuthenticationException, OwInvalidOperationException {
        return this.getShortGroupNames(false);
    }

    public Collection getShortGroupNames(boolean useAdminAccount_p) throws OwAuthenticationException, OwInvalidOperationException {
        OwLdapConnection connection = this.createConnection(useAdminAccount_p);
        try {
            return this.m_schemaInterpreter.getShortGroupNames(connection);
        }
        catch (OwConfigurationException e) {
            throw new OwInvalidOperationException(e.getMessage(), (Throwable)e);
        }
    }

    public Collection getAllShortGroupNames() throws OwAuthenticationException, OwInvalidOperationException {
        return this.getAllShortGroupNames(false);
    }

    public Collection getAllShortGroupNames(boolean useAdminAccount_p) throws OwAuthenticationException, OwInvalidOperationException {
        OwLdapConnection connection = this.createConnection(useAdminAccount_p);
        try {
            return this.m_schemaInterpreter.getAllShortGroupNames(connection);
        }
        catch (OwConfigurationException e) {
            throw new OwInvalidOperationException(e.getMessage(), (Throwable)e);
        }
    }

    public String getUserLongName() throws OwAuthenticationException, OwInvalidOperationException {
        OwLdapConnection connection = this.createConnection(false);
        try {
            return this.m_schemaInterpreter.getUserLongName(connection);
        }
        catch (OwConfigurationException e) {
            throw new OwInvalidOperationException(e.getMessage(), (Throwable)e);
        }
    }

    public String getUserId() throws OwAuthenticationException, OwInvalidOperationException {
        OwLdapConnection connection = this.createConnection(false);
        try {
            return this.m_schemaInterpreter.getUserId(connection);
        }
        catch (OwConfigurationException e) {
            throw new OwInvalidOperationException(e.getMessage(), (Throwable)e);
        }
    }

    public String findDistinguishedNameAnonymously(String user_p) throws OwAuthenticationException, OwConfigurationException {
        OwLdapConnection connection = this.createConnection(false);
        return this.m_schemaInterpreter.findDistinguishedNameAnonymously(user_p, connection);
    }

    public OwObjectCollection findUserDNsMatching(String pattern) throws OwException {
        OwLdapConnection connection = this.createConnection(false);
        return this.m_schemaInterpreter.findUserMatching(connection, pattern);
    }

    public String getUserShortName() throws OwAuthenticationException, OwInvalidOperationException {
        OwLdapConnection connection = this.createConnection(false);
        try {
            return this.m_schemaInterpreter.getUserShortName(connection);
        }
        catch (OwConfigurationException e) {
            throw new OwInvalidOperationException(e.getMessage(), (Throwable)e);
        }
    }

    public String getUserDisplayName() throws OwAuthenticationException, OwInvalidOperationException {
        OwLdapConnection connection = this.createConnection(false);
        try {
            return this.m_schemaInterpreter.getUserDisplayName(connection);
        }
        catch (OwConfigurationException e) {
            throw new OwInvalidOperationException(e.getMessage(), (Throwable)e);
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("OwLdapConnector[");
        buffer.append("\n- m_recursionLevel             = ").append(this.m_recursionLevel);
        buffer.append("\n- m_ldapProperties = ");
        if (this.m_ldapProperties != null) {
            buffer.append("[");
            for (Map.Entry<Object, Object> entry : this.m_ldapProperties.entrySet()) {
                buffer.append("\n> " + entry.getKey() + " = ").append(entry.getValue());
            }
            buffer.append("\n]");
        } else {
            buffer.append("null");
        }
        buffer.append("\n]");
        return buffer.toString();
    }

    public OwUserInfo findUserByDNAnonymously(String strID_p) throws OwException {
        OwLdapConnection connection = this.createConnection(false);
        return this.m_schemaInterpreter.findUserByDNAnonymously(strID_p, connection);
    }

    public OwUserInfo findUserByIdAnonymously(String strID_p) throws OwException {
        OwLdapConnection connection = this.createConnection(false);
        return this.m_schemaInterpreter.findUserByIdAnonymously(strID_p, connection);
    }

    public String getUserDisplayName(String dname) throws OwException {
        OwLdapConnection connection = this.createConnection(false);
        try {
            return this.m_schemaInterpreter.getUserDisplayName(dname, connection);
        }
        catch (OwConfigurationException e) {
            throw new OwInvalidOperationException("Could not find user.", (Throwable)e);
        }
    }

    public String getRecordId(String dname) throws OwException {
        OwLdapConnection connection = this.createConnection(false);
        try {
            return this.m_schemaInterpreter.getRecordId(dname, connection);
        }
        catch (OwConfigurationException e) {
            throw new OwInvalidOperationException("Could not find record with DN: " + dname + ".", (Throwable)e);
        }
    }

    public int getRecursionLevel() {
        return this.m_recursionLevel;
    }

    public OwUserInfo findUserByLoginAnonymously(String strID_p) throws OwException {
        OwLdapConnection connection = this.createConnection(false);
        return this.m_schemaInterpreter.findUserByLoginAnonymously(strID_p, connection);
    }

    public OwObjectCollection findGroupsMatching(String namePattern) throws OwException {
        OwLdapConnection connection = this.createConnection(false);
        return this.m_schemaInterpreter.findGroupsMatching(connection, namePattern);
    }
}

