/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.util.upload;

import com.wewebu.ow.server.util.upload.OwFileUpStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletInputStream;

public class OwMultiPart {
    private String m_name;
    private String m_fileName;
    private String m_filePath;
    private String m_contentType;
    private OwFileUpStream m_partInput;

    public OwMultiPart(String name_p, ServletInputStream in_p, String boundary_p, String contentType_p, String fileName_p, String filePath_p) throws IOException {
        this.m_name = name_p;
        this.m_fileName = fileName_p;
        this.m_filePath = filePath_p;
        this.m_contentType = contentType_p;
        this.m_partInput = new OwFileUpStream(in_p, boundary_p);
    }

    public String getName() {
        return this.m_name;
    }

    public String getFileName() {
        return this.m_fileName;
    }

    public String getFilePath() {
        return this.m_filePath;
    }

    public String getContentType() {
        return this.m_contentType;
    }

    public InputStream getInputStream() {
        return this.m_partInput;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long writeTo(File fileOrDirectory_p, String fileName_p) throws IOException {
        long lwritten = 0L;
        OutputStream fileOut = null;
        FileOutputStream fileOutputStream = null;
        try {
            if (this.m_fileName != null) {
                File file = fileOrDirectory_p.isDirectory() ? new File(fileOrDirectory_p, fileName_p) : fileOrDirectory_p;
                fileOutputStream = new FileOutputStream(file);
                fileOut = new BufferedOutputStream(fileOutputStream);
                lwritten = this.write(fileOut);
                fileOut.flush();
                fileOutputStream.flush();
            }
        }
        finally {
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
            if (fileOut != null) {
                fileOut.close();
            }
        }
        return lwritten;
    }

    public long writeTo(OutputStream out_p) throws IOException {
        long lsize = 0L;
        lsize = this.write(out_p);
        return lsize;
    }

    private long write(OutputStream out_p) throws IOException {
        int iread;
        long lsize = 0L;
        byte[] bybuf = new byte[8192];
        while ((iread = this.m_partInput.read(bybuf)) != -1) {
            out_p.write(bybuf, 0, iread);
            lsize += (long)iread;
        }
        return lsize;
    }

    public boolean isFile() {
        return this.m_fileName != null;
    }
}

