/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.util.upload;

import com.wewebu.ow.server.util.upload.OwBufferedServletInputStream;
import com.wewebu.ow.server.util.upload.OwMultiPart;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;

public class OwUpStreamParser {
    private ServletInputStream m_in;
    private String m_boundary;
    private OwMultiPart m_lastFilePart;
    private byte[] m_buf = new byte[8192];

    public OwUpStreamParser(HttpServletRequest req_p) throws IOException {
        String type = null;
        String type1 = req_p.getHeader("Content-Type");
        String type2 = req_p.getContentType();
        if (type1 == null && type2 != null) {
            type = type2;
        } else if (type2 == null && type1 != null) {
            type = type1;
        } else if (type1 != null && type2 != null) {
            String string = type = type1.length() > type2.length() ? type1 : type2;
        }
        if (type == null || !type.toLowerCase().startsWith("multipart/form-data")) {
            throw new IOException("Posted content type is not multipart/form-data");
        }
        String boundary = this.extractBoundary(type);
        if (boundary == null) {
            throw new IOException("Separation boundary was not specified");
        }
        ServletInputStream in = req_p.getInputStream();
        this.m_in = in = new OwBufferedServletInputStream(in);
        this.m_boundary = boundary;
        String line = this.readLine();
        if (line == null) {
            throw new IOException("Corrupt form data: premature ending");
        }
        if (!line.startsWith(boundary)) {
            throw new IOException("Corrupt form data: no leading boundary: " + line + " != " + boundary);
        }
    }

    public OwMultiPart readNextPart() throws IOException {
        if (this.m_lastFilePart != null) {
            this.m_lastFilePart.getInputStream().close();
            this.m_lastFilePart = null;
        }
        Vector<String> headers = new Vector<String>();
        String line = this.readLine();
        if (line == null) {
            return null;
        }
        if (line.length() == 0) {
            return null;
        }
        headers.addElement(line);
        while ((line = this.readLine()) != null && line.length() > 0) {
            headers.addElement(line);
        }
        if (line == null) {
            return null;
        }
        String name = null;
        String filename = null;
        String origname = null;
        String contentType = "text/plain";
        Enumeration enu = headers.elements();
        while (enu.hasMoreElements()) {
            String type;
            String headerline = (String)enu.nextElement();
            if (headerline.toLowerCase().startsWith("content-disposition:")) {
                String[] dispInfo = this.extractDispositionInfo(headerline);
                name = dispInfo[1];
                filename = dispInfo[2] != null ? dispInfo[2] : null;
                origname = dispInfo[3];
                continue;
            }
            if (!headerline.toLowerCase().startsWith("content-type:") || (type = this.extractContentType(headerline)) == null) continue;
            contentType = type;
        }
        if (filename != null && filename.equals("")) {
            filename = null;
        }
        this.m_lastFilePart = new OwMultiPart(name, this.m_in, this.m_boundary, contentType, filename, origname);
        return this.m_lastFilePart;
    }

    private String extractBoundary(String line_p) {
        int index = line_p.lastIndexOf("boundary=");
        if (index == -1) {
            return null;
        }
        String boundary = line_p.substring(index + 9);
        if (boundary.charAt(0) == '\"') {
            index = boundary.lastIndexOf(34);
            boundary = boundary.substring(1, index);
        }
        boundary = "--" + boundary;
        return boundary;
    }

    private String[] extractDispositionInfo(String line_p) throws IOException {
        String[] retval = new String[4];
        String origline = line_p;
        line_p = origline.toLowerCase();
        int start = line_p.indexOf("content-disposition: ");
        int end = line_p.indexOf(";");
        if (start == -1 || end == -1) {
            throw new IOException("Content disposition corrupt: " + origline);
        }
        String disposition = line_p.substring(start + 21, end);
        if (!disposition.equals("form-data")) {
            throw new IOException("Invalid content disposition: " + disposition);
        }
        start = line_p.indexOf("name=\"", end);
        end = line_p.indexOf("\"", start + 7);
        if (start == -1 || end == -1) {
            throw new IOException("Content disposition corrupt: " + origline);
        }
        String name = origline.substring(start + 6, end);
        String filename = null;
        String origname = null;
        start = line_p.indexOf("filename=\"", end + 2);
        end = line_p.indexOf("\"", start + 10);
        if (start != -1 && end != -1) {
            origname = filename = origline.substring(start + 10, end);
            int slash = Math.max(filename.lastIndexOf(47), filename.lastIndexOf(92));
            if (slash > -1) {
                filename = filename.substring(slash + 1);
            }
        }
        retval[0] = disposition;
        retval[1] = name;
        retval[2] = filename;
        retval[3] = origname;
        return retval;
    }

    private String extractContentType(String line_p) throws IOException {
        String contentType = null;
        String origline = line_p;
        if ((line_p = origline.toLowerCase()).startsWith("content-type")) {
            int start = line_p.indexOf(" ");
            if (start == -1) {
                throw new IOException("Content type corrupt: " + origline);
            }
            contentType = line_p.substring(start + 1);
        } else if (line_p.length() != 0) {
            throw new IOException("Malformed line after disposition: " + origline);
        }
        return contentType;
    }

    private String readLine() throws IOException {
        int result;
        StringBuffer sbuf = new StringBuffer();
        do {
            if ((result = this.m_in.readLine(this.m_buf, 0, this.m_buf.length)) == -1) continue;
            sbuf.append(new String(this.m_buf, 0, result, "ISO-8859-1"));
        } while (result == this.m_buf.length);
        if (sbuf.length() == 0) {
            return null;
        }
        int len = sbuf.length();
        if (sbuf.charAt(len - 2) == '\r') {
            sbuf.setLength(len - 2);
        } else {
            sbuf.setLength(len - 1);
        }
        return sbuf.toString();
    }

    public void tidyUp() throws IOException {
        this.m_in.close();
    }
}

