/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.plug.owrecord.filter;

import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwSearchObjectStore;
import com.wewebu.ow.server.ecm.OwStandardSearchSpecialNodeOperator;
import com.wewebu.ow.server.field.OwEnumCollection;
import com.wewebu.ow.server.field.OwFieldColumnInfo;
import com.wewebu.ow.server.field.OwFieldDefinition;
import com.wewebu.ow.server.field.OwFieldDefinitionProvider;
import com.wewebu.ow.server.field.OwFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class OwRecordFilterOperatorHelper {
    public static final Collection<Integer> NUMBER_OPERATORS = new LinkedList<Integer>();
    public static final Collection<Integer> DEFAULT_OPERATORS;
    public static final Collection<Integer> MULTIVAL_OPERATORS;
    public static final Collection<Integer> BOOLEAN_OPERATORS;

    public Collection<OwFieldDefinition> collectFilterProperties(OwObject obj_p, OwFieldDefinitionProvider fieldDefProvider_p, Collection columnInfoList_p) throws Exception {
        LinkedList<OwFieldDefinition> filterDef = obj_p.getFilterProperties(columnInfoList_p);
        if (filterDef == null && columnInfoList_p != null && (obj_p.getType() == 8193 || obj_p.getType() == 8207)) {
            String id;
            Iterator it = columnInfoList_p.iterator();
            filterDef = new LinkedList<OwFieldDefinition>();
            Iterator<String> idIt = this.getResourceIdsFromObject(obj_p).iterator();
            String string = id = idIt.hasNext() ? idIt.next() : null;
            while (it.hasNext()) {
                OwFieldColumnInfo fci = (OwFieldColumnInfo)it.next();
                OwFieldDefinition fd = null;
                do {
                    try {
                        fd = this.getFieldDefinition(fieldDefProvider_p, fci.getPropertyName(), id);
                        if (fd.isArray() || fd.isComplex()) continue;
                        filterDef.add(fd);
                    }
                    catch (Exception ex) {
                        if (idIt.hasNext()) {
                            id = idIt.next();
                            continue;
                        }
                        throw ex;
                    }
                } while (fd == null && idIt.hasNext());
            }
        }
        return filterDef;
    }

    public OwFieldDefinition getFieldDefinition(OwFieldDefinitionProvider fieldDefinitonProvider_p, String propName_p, String resourceId_p) throws Exception {
        OwFieldDefinition def = fieldDefinitonProvider_p.getFieldDefinition(propName_p, resourceId_p);
        if (def != null && def.getOperators() == null) {
            def = new OwFieldDefWrapper(def);
        }
        return def;
    }

    public List<String> getResourceIdsFromObject(OwObject obj_p) throws Exception {
        LinkedList<String> lst = new LinkedList<String>();
        if (obj_p.getType() == 8207) {
            OwStandardSearchSpecialNodeOperator scanner = new OwStandardSearchSpecialNodeOperator();
            scanner.scan(obj_p.getSearchTemplate().getSearch(false));
            List objectStores = scanner.getObjectStores();
            for (OwSearchObjectStore searchStore : objectStores) {
                String osIdentifier = searchStore.getId();
                if (osIdentifier == null) {
                    osIdentifier = searchStore.getName();
                }
                lst.add(osIdentifier);
            }
        } else {
            lst.add(obj_p.getResourceID());
        }
        return lst;
    }

    static {
        NUMBER_OPERATORS.add(4);
        NUMBER_OPERATORS.add(5);
        NUMBER_OPERATORS.add(10);
        NUMBER_OPERATORS.add(8);
        NUMBER_OPERATORS.add(14);
        NUMBER_OPERATORS.add(12);
        NUMBER_OPERATORS.add(530);
        DEFAULT_OPERATORS = new LinkedList<Integer>();
        DEFAULT_OPERATORS.add(6);
        DEFAULT_OPERATORS.add(7);
        DEFAULT_OPERATORS.add(4);
        DEFAULT_OPERATORS.add(5);
        MULTIVAL_OPERATORS = new LinkedList<Integer>();
        MULTIVAL_OPERATORS.add(275);
        MULTIVAL_OPERATORS.add(274);
        BOOLEAN_OPERATORS = new LinkedList<Integer>();
        BOOLEAN_OPERATORS.add(4);
        BOOLEAN_OPERATORS.add(5);
    }

    protected static class OwFieldDefWrapper
    implements OwFieldDefinition {
        OwFieldDefinition nativeDef;

        public OwFieldDefWrapper(OwFieldDefinition nativeDef_p) {
            this.nativeDef = nativeDef_p;
        }

        public String getClassName() {
            return this.nativeDef.getClassName();
        }

        public String getDisplayName(Locale locale_p) {
            return this.nativeDef.getDisplayName(locale_p);
        }

        public String getDescription(Locale locale_p) {
            return this.nativeDef.getDescription(locale_p);
        }

        public String getJavaClassName() {
            return this.nativeDef.getJavaClassName();
        }

        public Object getNativeType() throws Exception {
            return this.nativeDef.getNativeType();
        }

        public boolean isEnum() throws Exception {
            return this.nativeDef.isEnum();
        }

        public OwEnumCollection getEnums() throws Exception {
            return this.nativeDef.getEnums();
        }

        public boolean isRequired() throws Exception {
            return this.nativeDef.isRequired();
        }

        public Object getMaxValue() throws Exception {
            return this.nativeDef.getMaxValue();
        }

        public Object getMinValue() throws Exception {
            return this.nativeDef.getMinValue();
        }

        public Object getDefaultValue() throws Exception {
            return this.nativeDef.getDefaultValue();
        }

        public boolean isArray() throws Exception {
            return this.nativeDef.isArray();
        }

        public Object getValueFromNode(Node node_p) throws Exception {
            return this.nativeDef.getValueFromNode(node_p);
        }

        public Object getValueFromString(String text_p) throws Exception {
            return this.nativeDef.getValueFromString(text_p);
        }

        public Node getNodeFromValue(Object value_p, Document doc_p) throws Exception {
            return this.nativeDef.getNodeFromValue(value_p, doc_p);
        }

        public OwFormat getFormat() {
            return this.nativeDef.getFormat();
        }

        public Collection getOperators() throws Exception {
            if (this.isArray()) {
                return MULTIVAL_OPERATORS;
            }
            Class<?> critClass = Class.forName(this.getJavaClassName());
            if (Number.class.isAssignableFrom(critClass) || Date.class.isAssignableFrom(critClass)) {
                return NUMBER_OPERATORS;
            }
            if (Boolean.class.equals(critClass)) {
                return BOOLEAN_OPERATORS;
            }
            return DEFAULT_OPERATORS;
        }

        public List getComplexChildClasses() throws Exception {
            return this.nativeDef.getComplexChildClasses();
        }

        public boolean isComplex() {
            return this.nativeDef.isComplex();
        }
    }
}

