/*
 * Decompiled with CFR 0.152.
 */
package org.jsslutils.keystores;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateException;
import java.util.Arrays;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

public final class KeyStoreLoader {
    private volatile String keyStorePath;
    private volatile InputStream keyStoreInputStream;
    private volatile String keyStoreType;
    private volatile String keyStoreProvider;
    private volatile String keyStoreProviderClass;
    private volatile String keyStoreProviderArgFile;
    private volatile String keyStoreProviderArgText;
    private volatile char[] keyStorePassword;
    private volatile CallbackHandler keyStorePasswordCallbackHandler;

    public void setKeyStorePath(String keyStorePath) {
        this.keyStorePath = keyStorePath;
    }

    public void setKeyStoreInputStream(InputStream keyStoreInputStream) {
        this.keyStoreInputStream = keyStoreInputStream;
    }

    public void setKeyStoreType(String keyStoreType) {
        this.keyStoreType = keyStoreType;
    }

    public void setKeyStoreProvider(String keyStoreProvider) {
        this.keyStoreProvider = keyStoreProvider;
    }

    public void setKeyStoreProviderClass(String keyStoreProviderClass) {
        this.keyStoreProviderClass = keyStoreProviderClass;
    }

    public void setKeyStoreProviderArgFile(String keyStoreProviderArgFile) {
        this.keyStoreProviderArgFile = keyStoreProviderArgFile;
    }

    public void setKeyStoreProviderArgText(String keyStoreProviderArgText) {
        this.keyStoreProviderArgText = keyStoreProviderArgText;
    }

    public void setKeyStorePassword(String keyStorePassword) {
        this.setKeyStorePassword(keyStorePassword != null ? keyStorePassword.toCharArray() : null);
    }

    public void setKeyStorePassword(char[] keyStorePassword) {
        if (keyStorePassword != null) {
            this.keyStorePassword = new char[keyStorePassword.length];
            System.arraycopy(keyStorePassword, 0, this.keyStorePassword, 0, keyStorePassword.length);
        } else if (this.keyStorePassword != null) {
            Arrays.fill(this.keyStorePassword, ' ');
        }
    }

    public void setKeyStorePasswordCallbackHandler(CallbackHandler keyStorePasswordCallbackHandler) {
        this.keyStorePasswordCallbackHandler = keyStorePasswordCallbackHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyStore loadKeyStore(char[] password) throws KeyStoreException, NoSuchProviderException, IOException, NoSuchAlgorithmException, CertificateException, UnsupportedCallbackException, SecurityException {
        KeyStore keyStore = null;
        if (this.keyStorePath != null) {
            if (this.keyStoreProviderClass != null) {
                Provider provider;
                block53: {
                    try {
                        Constructor<?> constructor;
                        Class<?> providerClass = Class.forName(this.keyStoreProviderClass);
                        if (this.keyStoreProviderArgText != null) {
                            ByteArrayInputStream configInputStream = new ByteArrayInputStream(this.keyStoreProviderArgText.getBytes("UTF-8"));
                            try {
                                Constructor<?> constructor2 = providerClass.getConstructor(InputStream.class);
                                try {
                                    provider = (Provider)constructor2.newInstance(configInputStream);
                                    break block53;
                                }
                                catch (IllegalArgumentException e) {
                                    throw new NoSuchProviderException("Unable to build the provider with a text argument: " + this.keyStoreProviderClass);
                                }
                                catch (InstantiationException e) {
                                    throw new NoSuchProviderException("Unable to instantiate the provider with a text argument: " + this.keyStoreProviderClass);
                                }
                                catch (IllegalAccessException e) {
                                    throw new NoSuchProviderException("Unable to access the provider with a text argument: " + this.keyStoreProviderClass);
                                }
                                catch (InvocationTargetException e) {
                                    throw new NoSuchProviderException("Unable to invoke the provider with a text argument: " + this.keyStoreProviderClass);
                                }
                            }
                            catch (NoSuchMethodException e) {
                                try {
                                    Constructor<?> constructor3 = providerClass.getConstructor(new Class[0]);
                                    try {
                                        provider = (Provider)constructor3.newInstance(new Object[0]);
                                        provider.load(configInputStream);
                                        break block53;
                                    }
                                    catch (IllegalArgumentException e1) {
                                        throw new NoSuchProviderException("Unable to build the provider with a text argument: " + this.keyStoreProviderClass);
                                    }
                                    catch (InstantiationException e1) {
                                        throw new NoSuchProviderException("Unable to instantiate the provider with a text argument: " + this.keyStoreProviderClass);
                                    }
                                    catch (IllegalAccessException e1) {
                                        throw new NoSuchProviderException("Unable to access the provider with a text argument: " + this.keyStoreProviderClass);
                                    }
                                    catch (InvocationTargetException e1) {
                                        throw new NoSuchProviderException("Unable to invoke the provider with a text argument: " + this.keyStoreProviderClass);
                                    }
                                }
                                catch (NoSuchMethodException e1) {
                                    throw new NoSuchProviderException("Provider class doesn't seem to have a suitable constructor: " + this.keyStoreProviderClass);
                                }
                            }
                        }
                        if (this.keyStoreProviderArgFile != null) {
                            try {
                                constructor = providerClass.getConstructor(String.class);
                                try {
                                    provider = (Provider)constructor.newInstance(this.keyStoreProviderArgFile);
                                    break block53;
                                }
                                catch (IllegalArgumentException e) {
                                    throw new NoSuchProviderException("Unable to build the provider with a text argument: " + this.keyStoreProviderClass);
                                }
                                catch (InstantiationException e) {
                                    throw new NoSuchProviderException("Unable to instantiate the provider with a text argument: " + this.keyStoreProviderClass);
                                }
                                catch (IllegalAccessException e) {
                                    throw new NoSuchProviderException("Unable to access the provider with a text argument: " + this.keyStoreProviderClass);
                                }
                                catch (InvocationTargetException e) {
                                    throw new NoSuchProviderException("Unable to invoke the provider with a text argument: " + this.keyStoreProviderClass);
                                }
                            }
                            catch (NoSuchMethodException e) {
                                try {
                                    Constructor<?> constructor4 = providerClass.getConstructor(new Class[0]);
                                    try {
                                        provider = (Provider)constructor4.newInstance(new Object[0]);
                                        FileInputStream configInputStream = null;
                                        try {
                                            configInputStream = new FileInputStream(this.keyStoreProviderArgFile);
                                            provider.load(configInputStream);
                                            break block53;
                                        }
                                        finally {
                                            if (configInputStream != null) {
                                                ((InputStream)configInputStream).close();
                                            }
                                        }
                                    }
                                    catch (IllegalArgumentException e1) {
                                        throw new NoSuchProviderException("Unable to build the provider with a text argument: " + this.keyStoreProviderClass);
                                    }
                                    catch (InstantiationException e1) {
                                        throw new NoSuchProviderException("Unable to instantiate the provider with a text argument: " + this.keyStoreProviderClass);
                                    }
                                    catch (IllegalAccessException e1) {
                                        throw new NoSuchProviderException("Unable to access the provider with a text argument: " + this.keyStoreProviderClass);
                                    }
                                    catch (InvocationTargetException e1) {
                                        throw new NoSuchProviderException("Unable to invoke the provider with a text argument: " + this.keyStoreProviderClass);
                                    }
                                }
                                catch (NoSuchMethodException e1) {
                                    throw new NoSuchProviderException("Provider class doesn't seem to have a suitable constructor: " + this.keyStoreProviderClass);
                                }
                            }
                        }
                        try {
                            constructor = providerClass.getConstructor(new Class[0]);
                            try {
                                provider = (Provider)constructor.newInstance(new Object[0]);
                            }
                            catch (IllegalArgumentException e1) {
                                throw new NoSuchProviderException("Unable to build the provider with a text argument: " + this.keyStoreProviderClass);
                            }
                            catch (InstantiationException e1) {
                                throw new NoSuchProviderException("Unable to instantiate the provider with a text argument: " + this.keyStoreProviderClass);
                            }
                            catch (IllegalAccessException e1) {
                                throw new NoSuchProviderException("Unable to access the provider with a text argument: " + this.keyStoreProviderClass);
                            }
                            catch (InvocationTargetException e1) {
                                throw new NoSuchProviderException("Unable to invoke the provider with a text argument: " + this.keyStoreProviderClass);
                            }
                        }
                        catch (NoSuchMethodException e1) {
                            throw new NoSuchProviderException("Provider class doesn't seem to have a suitable constructor: " + this.keyStoreProviderClass);
                        }
                    }
                    catch (ClassNotFoundException e) {
                        throw new NoSuchProviderException("KeyStoreLoader unable to load class: " + this.keyStoreProviderClass);
                    }
                    catch (ClassCastException e) {
                        throw new NoSuchProviderException("KeyStoreLoader unable to load provider class: " + this.keyStoreProviderClass);
                    }
                }
                Security.addProvider(provider);
                keyStore = KeyStore.getInstance(this.keyStoreType != null ? this.keyStoreType : KeyStore.getDefaultType(), provider);
            } else {
                keyStore = this.keyStoreProvider != null ? KeyStore.getInstance(this.keyStoreType != null ? this.keyStoreType : KeyStore.getDefaultType(), this.keyStoreProvider) : KeyStore.getInstance(this.keyStoreType != null ? this.keyStoreType : KeyStore.getDefaultType());
            }
            InputStream keyStoreInputStream = this.keyStoreInputStream;
            try {
                InputStream inputStream = keyStoreInputStream = !"NONE".equals(this.keyStorePath) ? new FileInputStream(this.keyStorePath) : null;
                if (password == null) {
                    password = this.keyStorePassword;
                }
                CallbackHandler pwCallbackHandler = this.keyStorePasswordCallbackHandler;
                if (password == null && pwCallbackHandler != null) {
                    PasswordCallback passwordCallback = new PasswordCallback("KeyStore password? ", false);
                    pwCallbackHandler.handle(new Callback[]{passwordCallback});
                    password = passwordCallback.getPassword();
                }
                keyStore.load(keyStoreInputStream, password);
            }
            finally {
                if (keyStoreInputStream != null) {
                    keyStoreInputStream.close();
                }
            }
        }
        return keyStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyStore loadKeyStore() throws KeyStoreException, NoSuchProviderException, IOException, NoSuchAlgorithmException, CertificateException, UnsupportedCallbackException {
        try {
            KeyStore keyStore = this.loadKeyStore(this.keyStorePassword);
            return keyStore;
        }
        finally {
            if (this.keyStorePassword != null) {
                Arrays.fill(this.keyStorePassword, ' ');
            }
        }
    }

    public static KeyStoreLoader getKeyStoreDefaultLoader() {
        KeyStoreLoader ksLoader = new KeyStoreLoader();
        ksLoader.setKeyStorePath(System.getProperty("javax.net.ssl.keyStore"));
        ksLoader.setKeyStoreType(System.getProperty("javax.net.ssl.keyStoreType"));
        ksLoader.setKeyStoreProvider(System.getProperty("javax.net.ssl.keyStoreProvider"));
        ksLoader.setKeyStorePassword(System.getProperty("javax.net.ssl.keyStorePassword"));
        return ksLoader;
    }

    public static KeyStoreLoader getTrustStoreDefaultLoader() {
        KeyStoreLoader ksLoader = new KeyStoreLoader();
        ksLoader.setKeyStorePath(System.getProperty("javax.net.ssl.trustStore"));
        ksLoader.setKeyStoreType(System.getProperty("javax.net.ssl.trustStoreType"));
        ksLoader.setKeyStoreProvider(System.getProperty("javax.net.ssl.trustStoreProvider"));
        ksLoader.setKeyStorePassword(System.getProperty("javax.net.ssl.trustStorePassword"));
        return ksLoader;
    }

    protected final KeyStoreLoader clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }
}

