/*
 * Decompiled with CFR 0.152.
 */
package org.jsslutils.sslcontext;

import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Properties;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.jsslutils.sslcontext.SSLContextFactory;

public class DefaultSSLContextFactory
implements SSLContextFactory {
    public static final String CONTEXT_PROVIDER_NAME_PROP = "org.jsslutils.prop.contextProvider";
    public static final String CONTEXT_PROTOCOL_NAME_PROP = "org.jsslutils.prop.contextProtocol";
    public static final String SECURERANDOM_PROVIDER_NAME_PROP = "org.jsslutils.prop.secureRandomProvider";
    public static final String SECURERANDOM_ALGORITHM_PROP = "org.jsslutils.prop.secureRandomAlgorithm";
    private String contextProtocol = "TLS";
    private Provider contextProvider = null;
    private Provider secureRandomProvider = null;
    private String defaultSecureRandomAlgorithm = null;
    private SecureRandom secureRandom = null;

    public void configure(Properties properties) throws SSLContextFactory.SSLContextFactoryException {
        String contextProviderName = properties.getProperty(CONTEXT_PROVIDER_NAME_PROP);
        String secureRandomProviderName = properties.getProperty(SECURERANDOM_PROVIDER_NAME_PROP);
        String secureRandomAlgorithm = properties.getProperty(SECURERANDOM_ALGORITHM_PROP);
        String contextProtocol = properties.getProperty(CONTEXT_PROTOCOL_NAME_PROP);
        if (contextProviderName != null) {
            this.contextProvider = Security.getProvider(contextProviderName);
            if (this.contextProvider == null) {
                throw new SSLContextFactory.SSLContextFactoryException(new NoSuchProviderException(contextProviderName));
            }
        }
        if (secureRandomProviderName != null) {
            this.secureRandomProvider = Security.getProvider(secureRandomProviderName);
            if (this.secureRandomProvider == null) {
                throw new SSLContextFactory.SSLContextFactoryException(new NoSuchProviderException(secureRandomProviderName));
            }
        }
        this.defaultSecureRandomAlgorithm = secureRandomAlgorithm;
        this.contextProtocol = contextProtocol != null ? contextProtocol : "TLS";
    }

    public Provider getContextProvider() {
        return this.contextProvider;
    }

    public String getContextProtocol() {
        return this.contextProtocol;
    }

    public Provider getSecureRandomProvider() {
        return this.secureRandomProvider;
    }

    public String getDefaultSecureRandomAlgorithm() {
        return this.defaultSecureRandomAlgorithm;
    }

    public final SSLContext buildSSLContext() throws SSLContextFactory.SSLContextFactoryException {
        return this.buildSSLContext(this.getContextProtocol());
    }

    public SSLContext buildSSLContext(String contextProtocol) throws SSLContextFactory.SSLContextFactoryException {
        try {
            Provider contextProvider = this.getContextProvider();
            SSLContext sslContext = contextProvider != null ? SSLContext.getInstance(contextProtocol, contextProvider) : SSLContext.getInstance(contextProtocol);
            sslContext.init(this.getKeyManagers(), this.getTrustManagers(), this.getSecureRandom());
            return sslContext;
        }
        catch (KeyManagementException e) {
            throw new SSLContextFactory.SSLContextFactoryException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SSLContextFactory.SSLContextFactoryException(e);
        }
    }

    public KeyManager[] getKeyManagers() throws SSLContextFactory.SSLContextFactoryException {
        return null;
    }

    public TrustManager[] getTrustManagers() throws SSLContextFactory.SSLContextFactoryException {
        return null;
    }

    public void setSecureRandom(SecureRandom secureRandom) {
        this.secureRandom = secureRandom;
    }

    public SecureRandom getSecureRandom() throws SSLContextFactory.SSLContextFactoryException {
        if (this.secureRandom == null && this.defaultSecureRandomAlgorithm != null) {
            try {
                this.secureRandom = this.secureRandomProvider != null ? SecureRandom.getInstance(this.defaultSecureRandomAlgorithm, this.secureRandomProvider) : SecureRandom.getInstance(this.defaultSecureRandomAlgorithm);
            }
            catch (NoSuchAlgorithmException e) {
                throw new SSLContextFactory.SSLContextFactoryException("Error initialising SecureRandom.", e);
            }
        }
        return this.secureRandom;
    }

    protected final DefaultSSLContextFactory clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }
}

