/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.runtime;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.ObjectFactory;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.api.ObjectType;
import org.apache.chemistry.opencmis.client.api.OperationContext;
import org.apache.chemistry.opencmis.client.api.Policy;
import org.apache.chemistry.opencmis.client.api.Property;
import org.apache.chemistry.opencmis.client.api.Relationship;
import org.apache.chemistry.opencmis.client.api.Rendition;
import org.apache.chemistry.opencmis.client.api.TransientCmisObject;
import org.apache.chemistry.opencmis.client.runtime.OperationContextImpl;
import org.apache.chemistry.opencmis.client.runtime.SessionImpl;
import org.apache.chemistry.opencmis.commons.data.Ace;
import org.apache.chemistry.opencmis.commons.data.Acl;
import org.apache.chemistry.opencmis.commons.data.AllowableActions;
import org.apache.chemistry.opencmis.commons.data.CmisExtensionElement;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.RenditionData;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.enums.AclPropagation;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.ExtensionLevel;
import org.apache.chemistry.opencmis.commons.enums.Updatability;
import org.apache.chemistry.opencmis.commons.spi.CmisBinding;
import org.apache.chemistry.opencmis.commons.spi.Holder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCmisObject
implements CmisObject,
Serializable {
    private static final long serialVersionUID = 1L;
    private SessionImpl session;
    private ObjectType objectType;
    private Map<String, Property<?>> properties;
    private AllowableActions allowableActions;
    private List<Rendition> renditions;
    private Acl acl;
    private List<Policy> policies;
    private List<Relationship> relationships;
    private Map<ExtensionLevel, List<CmisExtensionElement>> extensions;
    private OperationContext creationContext;
    private long refreshTimestamp;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    protected void initialize(SessionImpl session, ObjectType objectType, ObjectData objectData, OperationContext context) {
        if (session == null) {
            throw new IllegalArgumentException("Session must be set!");
        }
        if (objectType == null) {
            throw new IllegalArgumentException("Object type must be set!");
        }
        if (objectType.getPropertyDefinitions() == null || objectType.getPropertyDefinitions().size() < 9) {
            throw new IllegalArgumentException("Object type must have property definitions!");
        }
        this.session = session;
        this.objectType = objectType;
        this.extensions = new HashMap<ExtensionLevel, List<CmisExtensionElement>>();
        this.creationContext = new OperationContextImpl(context);
        this.refreshTimestamp = System.currentTimeMillis();
        ObjectFactory of = this.getObjectFactory();
        if (objectData != null) {
            if (objectData.getProperties() != null) {
                this.properties = of.convertProperties(objectType, objectData.getProperties());
                this.extensions.put(ExtensionLevel.PROPERTIES, objectData.getProperties().getExtensions());
            }
            if (objectData.getAllowableActions() != null) {
                this.allowableActions = objectData.getAllowableActions();
                this.extensions.put(ExtensionLevel.ALLOWABLE_ACTIONS, objectData.getAllowableActions().getExtensions());
            }
            if (objectData.getRenditions() != null) {
                this.renditions = new ArrayList<Rendition>();
                for (RenditionData rd : objectData.getRenditions()) {
                    this.renditions.add(of.convertRendition(this.getId(), rd));
                }
            }
            if (objectData.getAcl() != null) {
                this.acl = objectData.getAcl();
                this.extensions.put(ExtensionLevel.ACL, objectData.getAcl().getExtensions());
            }
            if (objectData.getPolicyIds() != null && objectData.getPolicyIds().getPolicyIds() != null) {
                this.policies = new ArrayList<Policy>();
                for (String pid : objectData.getPolicyIds().getPolicyIds()) {
                    CmisObject policy = session.getObject(this.getSession().createObjectId(pid));
                    if (!(policy instanceof Policy)) continue;
                    this.policies.add((Policy)policy);
                }
                this.extensions.put(ExtensionLevel.POLICIES, objectData.getPolicyIds().getExtensions());
            }
            if (objectData.getRelationships() != null) {
                this.relationships = new ArrayList<Relationship>();
                for (ObjectData rod : objectData.getRelationships()) {
                    CmisObject relationship = of.convertObject(rod, this.creationContext);
                    if (!(relationship instanceof Relationship)) continue;
                    this.relationships.add((Relationship)relationship);
                }
            }
            this.extensions.put(ExtensionLevel.OBJECT, objectData.getExtensions());
        }
    }

    protected void writeLock() {
        this.lock.writeLock().lock();
    }

    protected void writeUnlock() {
        this.lock.writeLock().unlock();
    }

    protected void readLock() {
        this.lock.readLock().lock();
    }

    protected void readUnlock() {
        this.lock.readLock().unlock();
    }

    protected SessionImpl getSession() {
        return this.session;
    }

    protected String getRepositoryId() {
        return this.getSession().getRepositoryId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ObjectType getObjectType() {
        this.readLock();
        try {
            ObjectType objectType = this.objectType;
            return objectType;
        }
        finally {
            this.readUnlock();
        }
    }

    protected CmisBinding getBinding() {
        return this.getSession().getBinding();
    }

    protected ObjectFactory getObjectFactory() {
        return this.getSession().getObjectFactory();
    }

    protected String getObjectId() {
        String objectId = this.getId();
        if (objectId == null) {
            throw new IllegalStateException("Object Id is unknown!");
        }
        return objectId;
    }

    protected OperationContext getCreationContext() {
        return this.creationContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getPropertyQueryName(String propertyId) {
        this.readLock();
        try {
            PropertyDefinition propDef = (PropertyDefinition)this.objectType.getPropertyDefinitions().get(propertyId);
            if (propDef == null) {
                String string = null;
                return string;
            }
            String string = propDef.getQueryName();
            return string;
        }
        finally {
            this.readUnlock();
        }
    }

    public void delete() {
        this.delete(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(boolean allVersions) {
        this.readLock();
        try {
            this.getSession().delete((ObjectId)this, allVersions);
        }
        finally {
            this.readUnlock();
        }
    }

    public CmisObject updateProperties(Map<String, ?> properties) {
        ObjectId objectId = this.updateProperties(properties, true);
        if (objectId == null) {
            return null;
        }
        if (!this.getObjectId().equals(objectId.getId())) {
            return this.getSession().getObject(objectId, this.getCreationContext());
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectId updateProperties(Map<String, ?> properties, boolean refresh) {
        if (properties == null || properties.isEmpty()) {
            throw new IllegalArgumentException("Properties must not be empty!");
        }
        this.readLock();
        String newObjectId = null;
        try {
            String objectId = this.getObjectId();
            Holder objectIdHolder = new Holder((Object)objectId);
            String changeToken = this.getChangeToken();
            Holder changeTokenHolder = new Holder((Object)changeToken);
            HashSet<Updatability> updatebility = new HashSet<Updatability>();
            updatebility.add(Updatability.READWRITE);
            Boolean isCheckedOut = (Boolean)this.getPropertyValue("cmis:isVersionSeriesCheckedOut");
            if (isCheckedOut != null && isCheckedOut.booleanValue()) {
                updatebility.add(Updatability.WHENCHECKEDOUT);
            }
            this.getBinding().getObjectService().updateProperties(this.getRepositoryId(), objectIdHolder, changeTokenHolder, this.getObjectFactory().convertProperties(properties, this.objectType, updatebility), null);
            newObjectId = (String)objectIdHolder.getValue();
            this.getSession().removeObjectFromCache(objectId);
        }
        finally {
            this.readUnlock();
        }
        if (refresh) {
            this.refresh();
        }
        if (newObjectId == null) {
            return null;
        }
        return this.getSession().createObjectId(newObjectId);
    }

    public ObjectType getBaseType() {
        BaseTypeId baseTypeId = this.getBaseTypeId();
        if (baseTypeId == null) {
            return null;
        }
        return this.getSession().getTypeDefinition(baseTypeId.value());
    }

    public BaseTypeId getBaseTypeId() {
        String baseType = (String)this.getPropertyValue("cmis:baseTypeId");
        if (baseType == null) {
            return null;
        }
        return BaseTypeId.fromValue((String)baseType);
    }

    public String getChangeToken() {
        return (String)this.getPropertyValue("cmis:changeToken");
    }

    public String getCreatedBy() {
        return (String)this.getPropertyValue("cmis:createdBy");
    }

    public GregorianCalendar getCreationDate() {
        return (GregorianCalendar)this.getPropertyValue("cmis:creationDate");
    }

    public String getId() {
        return (String)this.getPropertyValue("cmis:objectId");
    }

    public GregorianCalendar getLastModificationDate() {
        return (GregorianCalendar)this.getPropertyValue("cmis:lastModificationDate");
    }

    public String getLastModifiedBy() {
        return (String)this.getPropertyValue("cmis:lastModifiedBy");
    }

    public String getName() {
        return (String)this.getPropertyValue("cmis:name");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Property<?>> getProperties() {
        this.readLock();
        try {
            List<Property<?>> list = Collections.unmodifiableList(new ArrayList(this.properties.values()));
            return list;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Property<T> getProperty(String id) {
        this.readLock();
        try {
            Property<?> property = this.properties.get(id);
            return property;
        }
        finally {
            this.readUnlock();
        }
    }

    public <T> T getPropertyValue(String id) {
        Property<T> property = this.getProperty(id);
        if (property == null) {
            return null;
        }
        return (T)property.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectType getType() {
        this.readLock();
        try {
            ObjectType objectType = this.objectType;
            return objectType;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AllowableActions getAllowableActions() {
        this.readLock();
        try {
            AllowableActions allowableActions = this.allowableActions;
            return allowableActions;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Rendition> getRenditions() {
        this.readLock();
        try {
            List<Rendition> list = this.renditions;
            return list;
        }
        finally {
            this.readUnlock();
        }
    }

    public Acl getAcl(boolean onlyBasicPermissions) {
        String objectId = this.getObjectId();
        return this.getBinding().getAclService().getAcl(this.getRepositoryId(), objectId, Boolean.valueOf(onlyBasicPermissions), null);
    }

    public Acl applyAcl(List<Ace> addAces, List<Ace> removeAces, AclPropagation aclPropagation) {
        Acl result = this.getSession().applyAcl((ObjectId)this, addAces, removeAces, aclPropagation);
        this.refresh();
        return result;
    }

    public Acl addAcl(List<Ace> addAces, AclPropagation aclPropagation) {
        return this.applyAcl(addAces, null, aclPropagation);
    }

    public Acl removeAcl(List<Ace> removeAces, AclPropagation aclPropagation) {
        return this.applyAcl(null, removeAces, aclPropagation);
    }

    public Acl setAcl(List<Ace> aces) {
        Acl result = this.getSession().setAcl((ObjectId)this, aces);
        this.refresh();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Acl getAcl() {
        this.readLock();
        try {
            Acl acl = this.acl;
            return acl;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyPolicy(ObjectId ... policyIds) {
        this.readLock();
        try {
            this.getSession().applyPolicy((ObjectId)this, policyIds);
        }
        finally {
            this.readUnlock();
        }
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePolicy(ObjectId ... policyIds) {
        this.readLock();
        try {
            this.getSession().removePolicy((ObjectId)this, policyIds);
        }
        finally {
            this.readUnlock();
        }
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Policy> getPolicies() {
        this.readLock();
        try {
            List<Policy> list = this.policies;
            return list;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Relationship> getRelationships() {
        this.readLock();
        try {
            List<Relationship> list = this.relationships;
            return list;
        }
        finally {
            this.readUnlock();
        }
    }

    public List<CmisExtensionElement> getExtensions(ExtensionLevel level) {
        List<CmisExtensionElement> ext = this.extensions.get(level);
        if (ext == null) {
            return null;
        }
        return Collections.unmodifiableList(ext);
    }

    public <T> T getAdapter(Class<T> adapterInterface) {
        if (adapterInterface == null) {
            return null;
        }
        if (adapterInterface.equals(TransientCmisObject.class)) {
            return (T)this.createTransientCmisObject();
        }
        return null;
    }

    public TransientCmisObject getTransientObject() {
        return this.getAdapter(TransientCmisObject.class);
    }

    protected TransientCmisObject createTransientCmisObject() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getRefreshTimestamp() {
        this.readLock();
        try {
            long l = this.refreshTimestamp;
            return l;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        this.writeLock();
        try {
            String objectId = this.getObjectId();
            OperationContext oc = this.getCreationContext();
            ObjectData objectData = this.getSession().getBinding().getObjectService().getObject(this.getRepositoryId(), objectId, oc.getFilterString(), Boolean.valueOf(oc.isIncludeAllowableActions()), oc.getIncludeRelationships(), oc.getRenditionFilterString(), Boolean.valueOf(oc.isIncludePolicies()), Boolean.valueOf(oc.isIncludeAcls()), null);
            this.initialize(this.getSession(), this.getObjectType(), objectData, this.creationContext);
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshIfOld(long durationInMillis) {
        this.writeLock();
        try {
            if (this.refreshTimestamp < System.currentTimeMillis() - durationInMillis) {
                this.refresh();
            }
        }
        finally {
            this.writeUnlock();
        }
    }
}

