/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.runtime;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.FileableCmisObject;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.ItemIterable;
import org.apache.chemistry.opencmis.client.api.ObjectFactory;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.api.ObjectType;
import org.apache.chemistry.opencmis.client.api.OperationContext;
import org.apache.chemistry.opencmis.client.api.Policy;
import org.apache.chemistry.opencmis.client.api.TransientCmisObject;
import org.apache.chemistry.opencmis.client.api.TransientFolder;
import org.apache.chemistry.opencmis.client.api.Tree;
import org.apache.chemistry.opencmis.client.runtime.AbstractFilableCmisObject;
import org.apache.chemistry.opencmis.client.runtime.OperationContextImpl;
import org.apache.chemistry.opencmis.client.runtime.SessionImpl;
import org.apache.chemistry.opencmis.client.runtime.TransientFolderImpl;
import org.apache.chemistry.opencmis.client.runtime.util.AbstractPageFetcher;
import org.apache.chemistry.opencmis.client.runtime.util.CollectionIterable;
import org.apache.chemistry.opencmis.client.runtime.util.TreeImpl;
import org.apache.chemistry.opencmis.commons.data.Ace;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.FailedToDeleteData;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.ObjectInFolderContainer;
import org.apache.chemistry.opencmis.commons.data.ObjectInFolderData;
import org.apache.chemistry.opencmis.commons.data.ObjectInFolderList;
import org.apache.chemistry.opencmis.commons.data.ObjectList;
import org.apache.chemistry.opencmis.commons.data.PropertyData;
import org.apache.chemistry.opencmis.commons.data.PropertyId;
import org.apache.chemistry.opencmis.commons.data.PropertyString;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.enums.UnfileObject;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.spi.NavigationService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FolderImpl
extends AbstractFilableCmisObject
implements Folder {
    private static final long serialVersionUID = 1L;

    public FolderImpl(SessionImpl session, ObjectType objectType, ObjectData objectData, OperationContext context) {
        this.initialize(session, objectType, objectData, context);
    }

    @Override
    protected TransientCmisObject createTransientCmisObject() {
        TransientFolderImpl tf = new TransientFolderImpl();
        tf.initialize(this.getSession(), this);
        return tf;
    }

    public TransientFolder getTransientFolder() {
        return (TransientFolder)this.getTransientObject();
    }

    public Document createDocument(Map<String, ?> properties, ContentStream contentStream, VersioningState versioningState, List<Policy> policies, List<Ace> addAces, List<Ace> removeAces, OperationContext context) {
        ObjectId newId = this.getSession().createDocument(properties, (ObjectId)this, contentStream, versioningState, policies, addAces, removeAces);
        if (context == null || newId == null) {
            return null;
        }
        CmisObject object = this.getSession().getObject(newId, context);
        if (!(object instanceof Document)) {
            throw new CmisRuntimeException("Newly created object is not a document! New id: " + newId);
        }
        return (Document)object;
    }

    public Document createDocumentFromSource(ObjectId source, Map<String, ?> properties, VersioningState versioningState, List<Policy> policies, List<Ace> addAces, List<Ace> removeAces, OperationContext context) {
        ObjectId newId = this.getSession().createDocumentFromSource(source, properties, (ObjectId)this, versioningState, policies, addAces, removeAces);
        if (context == null || newId == null) {
            return null;
        }
        CmisObject object = this.getSession().getObject(newId, context);
        if (!(object instanceof Document)) {
            throw new CmisRuntimeException("Newly created object is not a document! New id: " + newId);
        }
        return (Document)object;
    }

    public Folder createFolder(Map<String, ?> properties, List<Policy> policies, List<Ace> addAces, List<Ace> removeAces, OperationContext context) {
        ObjectId newId = this.getSession().createFolder(properties, (ObjectId)this, policies, addAces, removeAces);
        if (context == null || newId == null) {
            return null;
        }
        CmisObject object = this.getSession().getObject(newId, context);
        if (!(object instanceof Folder)) {
            throw new CmisRuntimeException("Newly created object is not a folder! New id: " + newId);
        }
        return (Folder)object;
    }

    public Policy createPolicy(Map<String, ?> properties, List<Policy> policies, List<Ace> addAces, List<Ace> removeAces, OperationContext context) {
        ObjectId newId = this.getSession().createPolicy(properties, (ObjectId)this, policies, addAces, removeAces);
        if (context == null || newId == null) {
            return null;
        }
        CmisObject object = this.getSession().getObject(newId, context);
        if (!(object instanceof Policy)) {
            throw new CmisRuntimeException("Newly created object is not a policy! New id: " + newId);
        }
        return (Policy)object;
    }

    public List<String> deleteTree(boolean allVersions, UnfileObject unfile, boolean continueOnFailure) {
        String repositoryId = this.getRepositoryId();
        String objectId = this.getObjectId();
        FailedToDeleteData failed = this.getBinding().getObjectService().deleteTree(repositoryId, objectId, Boolean.valueOf(allVersions), unfile, Boolean.valueOf(continueOnFailure), null);
        if (failed == null || failed.getIds() == null || failed.getIds().isEmpty()) {
            this.getSession().removeObjectFromCache((ObjectId)this);
        }
        return failed != null ? failed.getIds() : null;
    }

    public String getParentId() {
        return (String)this.getPropertyValue("cmis:parentId");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ObjectType> getAllowedChildObjectTypes() {
        ArrayList<ObjectType> result = new ArrayList<ObjectType>();
        this.readLock();
        try {
            List otids = (List)this.getPropertyValue("cmis:allowedChildObjectTypeIds");
            if (otids == null) {
                ArrayList<ObjectType> arrayList = result;
                return arrayList;
            }
            for (String otid : otids) {
                result.add(this.getSession().getTypeDefinition(otid));
            }
        }
        finally {
            this.readUnlock();
        }
        return result;
    }

    public ItemIterable<Document> getCheckedOutDocs() {
        return this.getCheckedOutDocs(this.getSession().getDefaultContext());
    }

    public ItemIterable<Document> getCheckedOutDocs(OperationContext context) {
        final String objectId = this.getObjectId();
        final NavigationService navigationService = this.getBinding().getNavigationService();
        final ObjectFactory objectFactory = this.getSession().getObjectFactory();
        final OperationContextImpl ctxt = new OperationContextImpl(context);
        return new CollectionIterable<Document>(new AbstractPageFetcher<Document>((long)ctxt.getMaxItemsPerPage()){

            @Override
            protected AbstractPageFetcher.Page<Document> fetchPage(long skipCount) {
                ObjectList checkedOutDocs = navigationService.getCheckedOutDocs(FolderImpl.this.getRepositoryId(), objectId, ctxt.getFilterString(), ctxt.getOrderBy(), Boolean.valueOf(ctxt.isIncludeAllowableActions()), ctxt.getIncludeRelationships(), ctxt.getRenditionFilterString(), BigInteger.valueOf(this.maxNumItems), BigInteger.valueOf(skipCount), null);
                ArrayList<Document> page = new ArrayList<Document>();
                if (checkedOutDocs.getObjects() != null) {
                    for (ObjectData objectData : checkedOutDocs.getObjects()) {
                        CmisObject doc = objectFactory.convertObject(objectData, ctxt);
                        if (!(doc instanceof Document)) continue;
                        page.add((Document)doc);
                    }
                }
                return new AbstractPageFetcher.Page<Document>(page, checkedOutDocs.getNumItems(), checkedOutDocs.hasMoreItems());
            }
        });
    }

    public ItemIterable<CmisObject> getChildren() {
        return this.getChildren(this.getSession().getDefaultContext());
    }

    public ItemIterable<CmisObject> getChildren(OperationContext context) {
        final String objectId = this.getObjectId();
        final NavigationService navigationService = this.getBinding().getNavigationService();
        final ObjectFactory objectFactory = this.getSession().getObjectFactory();
        final OperationContextImpl ctxt = new OperationContextImpl(context);
        return new CollectionIterable<CmisObject>(new AbstractPageFetcher<CmisObject>((long)ctxt.getMaxItemsPerPage()){

            @Override
            protected AbstractPageFetcher.Page<CmisObject> fetchPage(long skipCount) {
                ObjectInFolderList children = navigationService.getChildren(FolderImpl.this.getRepositoryId(), objectId, ctxt.getFilterString(), ctxt.getOrderBy(), Boolean.valueOf(ctxt.isIncludeAllowableActions()), ctxt.getIncludeRelationships(), ctxt.getRenditionFilterString(), Boolean.valueOf(ctxt.isIncludePathSegments()), BigInteger.valueOf(this.maxNumItems), BigInteger.valueOf(skipCount), null);
                ArrayList<CmisObject> page = new ArrayList<CmisObject>();
                List childObjects = children.getObjects();
                if (childObjects != null) {
                    for (ObjectInFolderData objectData : childObjects) {
                        if (objectData.getObject() == null) continue;
                        page.add(objectFactory.convertObject(objectData.getObject(), ctxt));
                    }
                }
                return new AbstractPageFetcher.Page<CmisObject>(page, children.getNumItems(), children.hasMoreItems());
            }
        });
    }

    public List<Tree<FileableCmisObject>> getDescendants(int depth) {
        return this.getDescendants(depth, this.getSession().getDefaultContext());
    }

    public List<Tree<FileableCmisObject>> getDescendants(int depth, OperationContext context) {
        String objectId = this.getObjectId();
        List providerContainerList = this.getBinding().getNavigationService().getDescendants(this.getRepositoryId(), objectId, BigInteger.valueOf(depth), context.getFilterString(), Boolean.valueOf(context.isIncludeAllowableActions()), context.getIncludeRelationships(), context.getRenditionFilterString(), Boolean.valueOf(context.isIncludePathSegments()), null);
        return this.convertBindingContainer(providerContainerList, context);
    }

    public List<Tree<FileableCmisObject>> getFolderTree(int depth) {
        return this.getFolderTree(depth, this.getSession().getDefaultContext());
    }

    public List<Tree<FileableCmisObject>> getFolderTree(int depth, OperationContext context) {
        String objectId = this.getObjectId();
        List providerContainerList = this.getBinding().getNavigationService().getFolderTree(this.getRepositoryId(), objectId, BigInteger.valueOf(depth), context.getFilterString(), Boolean.valueOf(context.isIncludeAllowableActions()), context.getIncludeRelationships(), context.getRenditionFilterString(), Boolean.valueOf(context.isIncludePathSegments()), null);
        return this.convertBindingContainer(providerContainerList, context);
    }

    private List<Tree<FileableCmisObject>> convertBindingContainer(List<ObjectInFolderContainer> bindingContainerList, OperationContext context) {
        if (bindingContainerList == null) {
            return null;
        }
        ObjectFactory of = this.getSession().getObjectFactory();
        ArrayList<Tree<FileableCmisObject>> result = new ArrayList<Tree<FileableCmisObject>>();
        for (ObjectInFolderContainer oifc : bindingContainerList) {
            CmisObject object;
            if (oifc.getObject() == null || oifc.getObject().getObject() == null || !((object = of.convertObject(oifc.getObject().getObject(), context)) instanceof FileableCmisObject)) continue;
            List children = this.convertBindingContainer(oifc.getChildren(), context);
            result.add(new TreeImpl<FileableCmisObject>((FileableCmisObject)object, children));
        }
        return result;
    }

    public boolean isRootFolder() {
        String objectId = this.getObjectId();
        String rootFolderId = this.getSession().getRepositoryInfo().getRootFolderId();
        return objectId.equals(rootFolderId);
    }

    public Folder getFolderParent() {
        if (this.isRootFolder()) {
            return null;
        }
        List<Folder> parents = this.getParents();
        if (parents == null || parents.isEmpty()) {
            return null;
        }
        return parents.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPath() {
        String path;
        this.readLock();
        try {
            path = (String)this.getPropertyValue("cmis:path");
            if (path == null) {
                PropertyData pathProperty;
                String objectId = this.getObjectId();
                ObjectData objectData = this.getBinding().getObjectService().getObject(this.getRepositoryId(), objectId, this.getPropertyQueryName("cmis:path"), Boolean.valueOf(false), IncludeRelationships.NONE, "cmis:none", Boolean.valueOf(false), Boolean.valueOf(false), null);
                if (objectData.getProperties() != null && objectData.getProperties().getProperties() != null && (pathProperty = (PropertyData)objectData.getProperties().getProperties().get("cmis:path")) instanceof PropertyString) {
                    path = (String)((PropertyString)pathProperty).getFirstValue();
                }
            }
        }
        finally {
            this.readUnlock();
        }
        if (path == null) {
            throw new CmisRuntimeException("Repository didn't return cmis:path!");
        }
        return path;
    }

    @Override
    public List<Folder> getParents(OperationContext context) {
        if (this.isRootFolder()) {
            return Collections.emptyList();
        }
        String objectId = this.getObjectId();
        ObjectData bindingParent = this.getBinding().getNavigationService().getFolderParent(this.getRepositoryId(), objectId, this.getPropertyQueryName("cmis:objectId"), null);
        if (bindingParent.getProperties() == null) {
            throw new CmisRuntimeException("Repository sent invalid data!");
        }
        PropertyData idProperty = (PropertyData)bindingParent.getProperties().getProperties().get("cmis:objectId");
        if (!(idProperty instanceof PropertyId) && !(idProperty instanceof PropertyString)) {
            throw new CmisRuntimeException("Repository sent invalid data! No object id!");
        }
        CmisObject parentFolder = this.getSession().getObject((String)idProperty.getFirstValue(), context);
        if (!(parentFolder instanceof Folder)) {
            throw new CmisRuntimeException("Repository sent invalid data! Object is not a folder!");
        }
        return Collections.singletonList((Folder)parentFolder);
    }

    @Override
    public List<String> getPaths() {
        return Collections.singletonList(this.getPath());
    }

    public Document createDocument(Map<String, ?> properties, ContentStream contentStream, VersioningState versioningState) {
        return this.createDocument(properties, contentStream, versioningState, null, null, null, this.getSession().getDefaultContext());
    }

    public Document createDocumentFromSource(ObjectId source, Map<String, ?> properties, VersioningState versioningState) {
        return this.createDocumentFromSource(source, properties, versioningState, null, null, null, this.getSession().getDefaultContext());
    }

    public Folder createFolder(Map<String, ?> properties) {
        return this.createFolder(properties, null, null, null, this.getSession().getDefaultContext());
    }

    public Policy createPolicy(Map<String, ?> properties) {
        return this.createPolicy(properties, null, null, null, this.getSession().getDefaultContext());
    }
}

