package com.wewebu.ow.server.plug.owdocprops;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import org.apache.log4j.Logger;
import org.w3c.dom.Node;

import com.wewebu.ow.server.app.OwClientRefreshContext;
import com.wewebu.ow.server.app.OwDocumentFunction;
import com.wewebu.ow.server.app.OwJspFormConfigurator;
import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.app.OwUpdateCodes;
import com.wewebu.ow.server.dmsdialogs.OwGroupPropertiesConfiguration;
import com.wewebu.ow.server.dmsdialogs.views.OwObjectPropertyFormularView;
import com.wewebu.ow.server.dmsdialogs.views.OwObjectPropertyView;
import com.wewebu.ow.server.ecm.OwNetwork;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwObjectCollection;
import com.wewebu.ow.server.ecm.OwObjectLinkRelation;
import com.wewebu.ow.server.ecm.OwStatusContextDefinitions;
import com.wewebu.ow.server.event.OwEventManager;
import com.wewebu.ow.server.exceptions.OwConfigurationException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.field.OwSearchTemplate;
import com.wewebu.ow.server.plug.owutil.OwConfigUtils;
import com.wewebu.ow.server.plug.owutil.OwObjectUtils;
import com.wewebu.ow.server.plug.std.log.OwLog;
import com.wewebu.ow.server.ui.OwDialog;
import com.wewebu.ow.server.ui.OwDialog.OwDialogListener;
import com.wewebu.ow.server.ui.OwEventTarget;
import com.wewebu.ow.server.util.OwString;
import com.wewebu.ow.server.util.OwXMLDOMUtil;
import com.wewebu.ow.server.util.OwXMLUtil;

/**
 *<p>
 * Implementation of the Document edit properties plugin.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 *@since 3.1.0.0
 */
public class OwEditDocumentPropertiesFunction extends OwDocumentFunction implements OwDialogListener
{
    // === members
    /** package logger for the class */
    private static final Logger LOG = OwLog.getLogger(OwEditDocumentPropertiesFunction.class);

    /**Handler for multiple JSP forms configuration*/
    private OwJspFormConfigurator m_owJspFormConfigurator;

    public void init(OwXMLUtil node_p, OwMainAppContext context_p) throws Exception
    {
        super.init(node_p, context_p);
        m_owJspFormConfigurator = new OwJspFormConfigurator(node_p);
    }

    /** get the URL to the info icon
     * @return String URL
     */
    public String getIcon() throws Exception
    {
        return getContext().getDesignURL() + getConfigNode().getSafeTextValue("icon", "/images/plug/owdocprops/edit_properties.png");
    }

    /** get the URL to the info icon
     * @return String URL
     */
    public String getBigIcon() throws Exception
    {
        return getContext().getDesignURL() + getConfigNode().getSafeTextValue("iconbig", "/images/plug/owdocprops/edit_properties_24.png");
    }

    /** event called when user clicked the label / icon 
     *
     *  @param oObject_p OwObject where event was triggered
     *  @param oParent_p Parent which listed the Object
     *  @param refreshCtx_p OwFunctionRefreshContext callback interface for the function plugins to signal refresh events to clients, can be null if no refresh is needed
     */
    public void onClickEvent(OwObject oObject_p, OwObject oParent_p, OwClientRefreshContext refreshCtx_p) throws Exception
    {

        if (!isEnabled(oObject_p, oParent_p, OwStatusContextDefinitions.STATUS_CONTEXT_CORRECT_STATUS))
        {
            LOG.debug("OwEditDocumentProperties.onClickEvent(): the edit function is not enabled for the given object !");
            throw new OwInvalidOperationException(new OwString("owdocprops.edit.properties.function.invalid.invalid.object", "Item can not be edited!"));
        }

        List objects = new LinkedList();

        objects.add(oObject_p);

        onMultiselectClickEvent(objects, oParent_p, refreshCtx_p);
    }

    /** event called when user clicked the plugin for multiple selected items
    *
    *  @param objects_p Collection of OwObject 
    *  @param oParent_p Parent which listed the Objects
    *  @param refreshCtx_p OwClientRefreshContext callback interface for the function plugins to signal refresh events to clients, can be null if no refresh is needed
    *
    */
    public void onMultiselectClickEvent(Collection objects_p, OwObject oParent_p, OwClientRefreshContext refreshCtx_p) throws Exception
    {
        Collection enabledObjects = new LinkedList();

        for (Iterator i = objects_p.iterator(); i.hasNext();)
        {
            OwObject objectToEdit = (OwObject) i.next();
            if (isEnabled(objectToEdit, oParent_p, OwStatusContextDefinitions.STATUS_CONTEXT_CORRECT_STATUS))
            {
                enabledObjects.add(objectToEdit);
            }
        }
        if (enabledObjects.isEmpty())
        {
            LOG.error("OwEditDocumentProperties.onMultiselectClickEvent(): Invalid object collection!The enabled objects collection is empty!");
            throw new OwInvalidOperationException(new OwString("owdocprops.edit.properties.function.invalid.object.collection", "Invalid object collection!"));
        }

        //for batch import
        Collection batchIndexProperties = getConfigNode().getSafeStringList("EditBatchPropertyList");

        // === which views should be displayed
        int iViewMask = 0;
        iViewMask |= OwConfigUtils.computeViewMaskFromConfig(getConfigNode(), "PropertiesView", OwEditPropertiesDialog.VIEW_MASK_PROPERTIES);
        iViewMask |= OwConfigUtils.computeViewMaskFromConfig(getConfigNode(), "SystemPropertiesView", OwEditPropertiesDialog.VIEW_MASK_SYSTEM_PROPERTIES);
        iViewMask |= OwConfigUtils.computeViewMaskFromConfig(getConfigNode(), "VersionsView", OwEditPropertiesDialog.VIEW_MASK_VERSIONS);
        iViewMask |= OwConfigUtils.computeViewMaskFromConfig(getConfigNode(), "HistoryView", OwEditPropertiesDialog.VIEW_MASK_HISTORY);
        iViewMask |= OwConfigUtils.computeViewMaskFromConfig(getConfigNode(), "LinksView", "show", OwEditPropertiesDialog.VIEW_MASK_LINKS, false);
        iViewMask |= OwConfigUtils.computeViewMaskFromConfig(getConfigNode(), "FiledInView", OwEditPropertiesDialog.VIEW_MASK_FILED_IN);
        iViewMask |= OwConfigUtils.computeViewMaskFromConfig(getConfigNode(), "AccessRightsView", OwEditPropertiesDialog.VIEW_MASK_ACCESS_RIGHTS);
        iViewMask |= OwConfigUtils.computeViewMaskFromConfig(getConfigNode(), "DocumentFunctionsView", OwEditPropertiesDialog.VIEW_MASK_DOCUMENT_FUNCTIONS);
        iViewMask |= OwConfigUtils.computeViewMaskFromConfig(getConfigNode(), "EnablePasteMetadata", OwEditPropertiesDialog.VIEW_MASK_ENABLE_PASTE_METADATA);
        iViewMask |= OwConfigUtils.computeViewMaskFromConfig(getConfigNode(), "EnableSaveAll", OwEditPropertiesDialog.VIEW_MASK_ENABLE_SAVE_ALL);

        // === which views should be displayed read-only 
        int iReadOnlyViewMask = 0;
        iReadOnlyViewMask |= OwConfigUtils.computeReadOnlyViewMaskFromConfig(getConfigNode(), "PropertiesView", OwEditPropertiesDialog.VIEW_MASK_PROPERTIES);
        iReadOnlyViewMask |= OwConfigUtils.computeReadOnlyViewMaskFromConfig(getConfigNode(), "SystemPropertiesView", OwEditPropertiesDialog.VIEW_MASK_SYSTEM_PROPERTIES);
        iReadOnlyViewMask |= OwConfigUtils.computeReadOnlyViewMaskFromConfig(getConfigNode(), "VersionsView", OwEditPropertiesDialog.VIEW_MASK_VERSIONS);
        iReadOnlyViewMask |= OwConfigUtils.computeReadOnlyViewMaskFromConfig(getConfigNode(), "HistoryView", OwEditPropertiesDialog.VIEW_MASK_HISTORY);
        iReadOnlyViewMask |= OwConfigUtils.computeReadOnlyViewMaskFromConfig(getConfigNode(), "FiledInView", OwEditPropertiesDialog.VIEW_MASK_FILED_IN);
        iReadOnlyViewMask |= OwConfigUtils.computeReadOnlyViewMaskFromConfig(getConfigNode(), "AccessRightsView", OwEditPropertiesDialog.VIEW_MASK_ACCESS_RIGHTS);

        // === get scope flags for history view
        Node historyNode = getConfigNode().getSubNode("HistoryView");

        iViewMask |= (OwXMLDOMUtil.getSafeBooleanAttributeValue(historyNode, "objecthistory", true) ? OwEditPropertiesDialog.VIEW_MASK_HISTORY_SCOPE_OBJECT : 0);
        iViewMask |= (OwXMLDOMUtil.getSafeBooleanAttributeValue(historyNode, "casehistory", true) ? OwEditPropertiesDialog.VIEW_MASK_HISTORY_SCOPE_CASE : 0);

        // === get a search template for the history view
        OwSearchTemplate historySearchTemplate = null;
        List historyViewColumnInfo = null;

        if ((iViewMask & OwEditPropertiesDialog.VIEW_MASK_HISTORY) == OwEditPropertiesDialog.VIEW_MASK_HISTORY)
        {
            String strHistoryViewSearchTemplate = getConfigNode().getSafeTextValue("HistoryViewSearchTemplate", null);

            if (null != strHistoryViewSearchTemplate)
            {
                historySearchTemplate = (OwSearchTemplate) getContext().getNetwork().getApplicationObject(OwNetwork.APPLICATION_OBJECT_TYPE_SEARCHTEMPLATE, strHistoryViewSearchTemplate, false, false);
                historySearchTemplate.init(getContext().getHistoryManager());
            }
            else
            {
                // === alternatively get a list with column info for the history
                // view
                historyViewColumnInfo = (List) getSafeSetting("HistoryViewColumnInfo", null);

                if (historyViewColumnInfo == null)
                {
                    String msg = "OwEditDocumentProperties.onMultiselectClickEvent: Please specify either &lt;HistoryViewSearchTemplate&gt; ... or &lt;settingsset&gt; &lt;HistoryViewColumnInfo&gt; in the plugin descriptor, PluginId = "
                            + getPluginID();
                    LOG.fatal(msg);
                    throw new OwConfigurationException(msg);
                }
            }
        }

        // === create new edit properties dialog
        Collection objects = enabledObjects;

        // select version to edit
        if (getConfigNode().getSafeBooleanValue("AlwaysUseLatestVersion", false))
        {
            objects = OwObjectUtils.getLatesVersionObjects(enabledObjects);
        }

        OwXMLUtil linksViewConfig = getConfigNode().getSubUtil("LinksView");
        OwObjectLinkRelation split = OwObjectLinkRelation.BOTH;
        Collection<String> linkClassNames = Collections.EMPTY_LIST;
        boolean displayTypedList = true;

        if (linksViewConfig != null)
        {
            displayTypedList = linksViewConfig.getSafeBooleanAttributeValue("typeList", true);
            String direction = linksViewConfig.getSafeStringAttributeValue("direction", "BOTH");
            try
            {
                split = OwObjectLinkRelation.valueOf(direction);
            }
            catch (IllegalArgumentException e)
            {
                LOG.error("Invalid direction attribute value in confiuration of document function with ID=" + getPluginID(), e);
            }
            linkClassNames = linksViewConfig.getSafeStringList("linkclasses");
        }

        OwEditPropertiesDialog dlg = createPropertiesDialog(objects, oParent_p, refreshCtx_p, getConfigNode().getSafeIntegerValue("MaxChildSize", 50), (List) getSafeSetting("VersionViewColumnInfo", null), historySearchTemplate,
                historyViewColumnInfo, batchIndexProperties, split, displayTypedList, linkClassNames);

        iViewMask |= (getConfigNode().getSafeBooleanValue("AutoOpen", false) ? OwEditPropertiesDialog.VIEW_MASK_AUTOOPEN : 0);
        iViewMask |= OwXMLDOMUtil.getSafeBooleanAttributeValue(getConfigNode().getSubNode("AutoOpen"), "previewmode", false) ? OwEditPropertiesDialog.VIEW_MASK_PREVIEW_AUTOOPEN : 0;

        // Mask the views to be used
        dlg.setViewMask(iViewMask);
        dlg.setReadOnlyViewMask(iReadOnlyViewMask);

        // set help path if defined in plugin descriptor
        dlg.setHelp(getHelpPath());
        dlg.setTitle(getContext().localize("owdocprops.OwEditDocumentProperties.helptitle", "Dokument Eigenschaften bearbeiten"));

        // set info icon
        dlg.setInfoIcon(getBigIcon());

        // open dialog
        getContext().openDialog(dlg, this);

        // historize
        addHistoryEvent(objects, oParent_p, OwEventManager.HISTORY_EVENT_TYPE_PLUGIN_INVOKE_VIEW, OwEventManager.HISTORY_STATUS_OK);
    }

    /** overridable factory method to create the dialog
     * 
     * @param objects_p
     * @param oParent_p
     * @param refreshCtx_p
     * @param iMaxElementSize_p
     * @param versionColumnInfo_p
     * @param historyViewSearchTemplate_p
     * @param historyViewColumnInfo_p
     * @param batchIndexProperties_p Collection of batch index properties each property will be copied to the next pane
     * 
     * @return the newly created {@link OwEditPropertiesDialog}
     * @throws Exception
     */
    protected OwEditPropertiesDialog createPropertiesDialog(Collection objects_p, OwObject oParent_p, OwClientRefreshContext refreshCtx_p, int iMaxElementSize_p, Collection versionColumnInfo_p, OwSearchTemplate historyViewSearchTemplate_p,
            Collection historyViewColumnInfo_p, Collection batchIndexProperties_p, OwObjectLinkRelation relationSplit_p, boolean displayTypedList_p, Collection<String> linkClassNames_p) throws Exception
    {
        OwEditPropertiesDialog owEditDocumentProps = new OwEditPropertiesDialogBuilder().items(objects_p).index(0).parentObject(oParent_p).maxElementSize(iMaxElementSize_p).versionColumnInfo(versionColumnInfo_p)
                .historyViewSearchTemplate(historyViewSearchTemplate_p).historyViewColumnInfo(historyViewColumnInfo_p).batchIndexProperties(batchIndexProperties_p).relationSplit(relationSplit_p).displayLinksByType(displayTypedList_p)
                .linkClassNames(linkClassNames_p).build();
        //        new OwEditPropertiesDialog(objects_p, 0, oParent_p, iMaxElementSize_p, versionColumnInfo_p, historyViewSearchTemplate_p, historyViewColumnInfo_p, batchIndexProperties_p, relationSplit_p,
        //                displayTypedList_p, linkClassNames_p);
        owEditDocumentProps.setJspConfigurator(m_owJspFormConfigurator);
        owEditDocumentProps.setGroupPropertiesConfiguration(new OwGroupPropertiesConfiguration(getConfigNode(), m_MainContext));
        return owEditDocumentProps;
    }

    /*
     * (non-Javadoc)
     * @see com.wewebu.ow.server.ui.OwDialog.OwDialogListener#onDialogClose(com.wewebu.ow.server.ui.OwDialog)
     */
    public void onDialogClose(OwDialog dialogView_p) throws Exception
    {
        // TODO Auto-generated method stub

    }

    /*
     * (non-Javadoc)
     * @see com.wewebu.ow.server.ui.OwUpdateTarget#onUpdate(com.wewebu.ow.server.ui.OwEventTarget, int, java.lang.Object)
     */
    public void onUpdate(OwEventTarget caller_p, int code_p, Object param_p) throws Exception
    {
        // here receive update events from the views
        switch (code_p)
        {
            case OwUpdateCodes.MODIFIED_OBJECT_PROPERTY:
            {
                // on apply was pressed in the property view
                if (caller_p instanceof OwObjectPropertyView)
                {
                    OwObjectPropertyView realCaller = (OwObjectPropertyView) caller_p;
                    OwObject objectRef = realCaller.getObjectRef();
                    historizeModifiedPropsEvent(objectRef);
                }
                else if (caller_p instanceof OwObjectPropertyFormularView)
                {
                    OwObjectPropertyFormularView realCaller = (OwObjectPropertyFormularView) caller_p;
                    OwObject objectRef = realCaller.getObjectRef();
                    historizeModifiedPropsEvent(objectRef);
                }
            }
                break;
        }

    }

    /**
     * Historize the event for modified properties.
     * @param objectRef_p
     * @throws Exception
     */
    private void historizeModifiedPropsEvent(OwObject objectRef_p) throws Exception
    {
        Collection objectColection = new LinkedList();
        if (objectRef_p != null)
        {
            objectColection.add(objectRef_p);
            OwObjectCollection parents = objectRef_p.getParents();
            OwObject parent = parents != null && parents.size() > 0 ? (OwObject) parents.get(0) : null;
            this.addHistoryEvent(objectRef_p, parent, OwEventManager.HISTORY_EVENT_TYPE_PLUGIN_INVOKE_EDIT, OwEventManager.HISTORY_STATUS_OK);
        }
    }
}