package com.wewebu.ow.server.plug.owdocprops;

import java.util.Iterator;
import java.util.Vector;

import org.apache.log4j.Logger;
import org.w3c.dom.Node;

import com.wewebu.ow.server.app.OwClientRefreshContext;
import com.wewebu.ow.server.app.OwDocumentFunction;
import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwProperty;
import com.wewebu.ow.server.event.OwEventManager;
import com.wewebu.ow.server.exceptions.OwConfigurationException;
import com.wewebu.ow.server.exceptions.OwObjectNotFoundException;
import com.wewebu.ow.server.plug.std.log.OwLog;
import com.wewebu.ow.server.util.OwXMLDOMUtil;
import com.wewebu.ow.server.util.OwXMLUtil;

/**
 *<p>
 * A document function that displays a status icon dependent on document property states.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 */
public class OwStatusIconDocumentFunction extends OwDocumentFunction
{
    /** package logger for the class */
    private static final Logger LOG = OwLog.getLogger(OwStatusIconDocumentFunction.class);

    /**
     *<p>
     * A single icon rule.
     *</p>
     *
     *<p><font size="-2">
     * Alfresco Workdesk<br/>
     * Copyright (c) Alfresco Software, Inc.<br/>
     * All rights reserved.<br/>
     * <br/>
     * For licensing information read the license.txt file or<br/>
     * go to: http://wiki.alfresco.com<br/>
     *</font></p>
     */
    private static class OwStatusIconDocumentFunctionIconRule
    {
        /** icon URL */
        String m_icon;
        /** property name to get status from */
        String m_property;
        /** the value string to match */
        String m_value;

        public OwStatusIconDocumentFunctionIconRule(Node n_p, OwMainAppContext context_p) throws Exception
        {
            String icon = OwXMLDOMUtil.getSafeStringAttributeValue(n_p, "icon", null);
            if (icon == null)
            {
                String msg = "OwStatusIconDocumentFunction$OwStatusIconDocumentFunctionIconRule: Please specify a icon in IconRule.";
                LOG.fatal(msg);
                throw new OwConfigurationException(msg);
            }

            // get optional tooltip from configuration
            String tooltip = OwXMLDOMUtil.getSafeStringAttributeValue(n_p, "tooltip", null);

            String rule = n_p.getFirstChild().getNodeValue();
            if (rule == null)
            {
                String msg = "OwStatusIconDocumentFunction$OwStatusIconDocumentFunctionIconRule: Please specify a rule.";
                LOG.fatal(msg);
                throw new OwConfigurationException(msg);
            }

            int iEqual = rule.indexOf("=");
            if (-1 == iEqual)
            {
                String msg = "OwStatusIconDocumentFunction$OwStatusIconDocumentFunctionIconRule: Please specify a '=' in the rule.";
                LOG.fatal(msg);
                throw new OwConfigurationException(msg);
            }

            // get property name
            m_property = rule.substring(0, iEqual);
            m_property = m_property.trim();

            // get value string to match
            m_value = rule.substring(iEqual + 1);
            m_value = m_value.trim();

            if (m_value.equals("OW_NULL"))
            {
                m_value = null;
            }

            // compute icon HTML 
            StringBuilder iconbuf = new StringBuilder();

            if (tooltip == null)
            {
                tooltip = m_property;
            }
            else
            {
                // localize tooltip
                tooltip = context_p.localizeLabel(tooltip);
            }

            iconbuf.append("<img class=\"OwFunctionIcon\" alt=\"");
            iconbuf.append(tooltip);
            iconbuf.append("\" title=\"");
            iconbuf.append(tooltip);
            iconbuf.append("\" src=\"");
            iconbuf.append(context_p.getDesignURL());
            iconbuf.append(icon);
            iconbuf.append("\"/>");

            m_icon = iconbuf.toString();
        }

        /** apply rule
         * 
         * @param oObject_p
         * @param oParent_p
         * 
         * @return String icon if rule matches, null if rule does not match
         * @throws Exception 
         */
        public String applyAndGetIcon(OwObject oObject_p, OwObject oParent_p) throws Exception
        {
            try
            {
                OwProperty prop = oObject_p.getProperty(m_property);

                Object value = prop.getValue();
                if (value == null)
                {
                    return (m_value == null) ? m_icon : null;
                }
                else if (m_value != null)
                {
                    return (value.toString().equals(m_value)) ? m_icon : null;
                }
                else
                {
                    return null;
                }
            }
            catch (OwObjectNotFoundException e)
            {
                return null;
            }
        }
    }

    /** the applicable icon rules */
    private Vector m_rules = new Vector();

    // === members
    public void init(OwXMLUtil node_p, OwMainAppContext context_p) throws Exception
    {
        super.init(node_p, context_p);

        // load rules
        Iterator it = node_p.getSafeNodeList("IconRules").iterator();

        while (it.hasNext())
        {
            Node n = (Node) it.next();

            m_rules.add(new OwStatusIconDocumentFunctionIconRule(n, context_p));
        }
    }

    /** get the small (16x16 pixels) icon URL for this plugin to be displayed
    *
    *  @return String icon URL 
    */
    public String getIcon() throws Exception
    {
        return getContext().getDesignURL() + getConfigNode().getSafeTextValue("icon", "/images/plug/owstatus/hasminorversions.png");
    }

    /** get the big (24x24 pixels) icon URL for this plugin to be displayed
    *
    *  @return String icon URL 
    */
    public String getBigIcon() throws Exception
    {
        return getContext().getDesignURL() + getConfigNode().getSafeTextValue("iconbig", "/images/plug/owstatus/hasminorversions_24.png");
    }

    /** get property from the XML plugin config node */
    public boolean getObjectInstance()
    {
        // always true
        return true;
    }

    /** get property from the XML plugin config node */
    public boolean getContextMenu()
    {
        // always false
        return false;
    }

    /** get property from the XML plugin config node */
    public boolean getMultiselect()
    {
        // always false
        return false;
    }

    /** check if the plugin handles events with function calls, 
     *  or if it is just used to display an icon.
     *  The default is false, i.e. plugin handles events.
     *
     *  @return boolean true = handles events, false = does not handle events
     */
    public boolean getNoEvent()
    {
        // always true, just show state, do not handle click
        return true;
    }

    /** get the HTML code for the small (16x16 pixels) icon for this plugin to be displayed in the object list.
     *  An anchor tag is wrapped around this HTML code to trigger events for the plugin.
     *
     *  NOTE: you can return arbitrary HTML here, if you do not want to display an icon.
     *
     *  @param oObject_p OwObject where event was triggered
     *  @param oParent_p Parent which listed the Object
     *
     *  @return HTML code to be inserted for the document function plugin. 
     */
    public String getIconHTML(OwObject oObject_p, OwObject oParent_p) throws Exception
    {
        this.addHistoryEvent(oObject_p, oParent_p, OwEventManager.HISTORY_EVENT_TYPE_PLUGIN_INVOKE_UI, OwEventManager.HISTORY_STATUS_OK);
        // apply rules first match count's
        Iterator it = this.m_rules.iterator();
        while (it.hasNext())
        {
            OwStatusIconDocumentFunctionIconRule rule = (OwStatusIconDocumentFunctionIconRule) it.next();
            String icon = rule.applyAndGetIcon(oObject_p, oParent_p);

            if (null == icon)
            {
                continue;
            }

            return icon;
        }

        // don't show anything, no rule matched
        return "";
    }

    public void onClickEvent(OwObject object_p, OwObject parent_p, OwClientRefreshContext refreshCtx_p) throws Exception
    {
        // ignore
    }

}