package com.wewebu.ow.server.ao;

import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.field.OwSearchTemplate;

/**
 *<p>
 * A search template factory interface.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 *@since 3.2.0.0
 */
public interface OwSearchTemplateFactory
{
    /**
     * Create search template from given OwObject,
     * where the content of given OwObject is the search definition. 
     * @param obj_p OwObject search template
     * @return OwSearchTemplate
     * @throws OwException
     */
    OwSearchTemplate createSearchTemplate(OwObject obj_p) throws OwException;
}
