package com.wewebu.ow.server.auth;

import java.io.Serializable;
import java.security.Principal;
import java.util.Map;

import com.wewebu.ow.server.ecm.OwCredentials;

/**
 *<p>
 * Interface of an Authentication object, which
 * will be provided during an authentication.
 * Implementations represent tokens for authenticated principals. 
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 *@since 4.0.0.0
 */
public interface OwAuthentication extends Principal, Serializable
{

    String getUserName();

    String getPassword();

    /**
     * @deprecated This will be removed in the near future. Use {@link #getName()} and {@link #getPassword()} instead.
     */
    Map<String, String> getLoginMap();

    OwCredentials getOWDCredentials();

    boolean isAuthenticated();

    //TODO  does setAuthenticated make sense 
}
