package com.wewebu.ow.server.dmsdialogs.views;

import java.io.Writer;

import org.w3c.dom.Node;

import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.util.OwXMLDOMUtil;

/**
 *<p>
 * Page navigation component, that render each page URL as a group of first and the last item number displayed on that page.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 *@since 2.5.2.0
 */
public class OwNumberBlockPageSelectorComponent extends OwPageSelectorComponent
{
    /**
     * flag indicating if images are used for rendering next and previous page.
     */
    private boolean m_useImages = true;

    /**
     * Constructor
     * @param view_p - the {@link OwPageableView}
     */
    public OwNumberBlockPageSelectorComponent(OwPageableView view_p)
    {
        super(view_p);
    }

    /**
     * @see com.wewebu.ow.server.dmsdialogs.views.OwPageSelectorComponent#render(java.io.Writer)
     */
    public void render(Writer w_p) throws Exception
    {
        if (hasPaging() && shouldRenderComponent())
        {

            int iPageSize = ((OwMainAppContext) m_view.getContext()).getPageSizeForLists();

            w_p.write("<div class=\"OwNumberBlockPageSelector\">\n");

            renderAccessibilityMark(w_p);

            if (m_view.canPagePrev())
            {
                String text = m_view.getContext().localize("dmsdialogs.views.OwObjectListViewEXTJSGrid.PagingPrevBlockText", "Previous Pages");
                w_p.write("<div class=\"OwNumberBlockPageSelector_page\"><a title=\"" + text + "\" href=\"" + getPagePrevURL() + "\">\n");
                if (m_useImages)
                {
                    w_p.write(" <img title=\"" + text + "\" alt=\"" + text + "\" src=\"" + m_view.getContext().getDesignURL() + "/images/navigate_left_blue.gif\"/>");
                }
                else
                {
                    w_p.write("&lt;");
                }
                w_p.write("</a></div>\n");
            }
            int iPageCount = m_view.getPageCount();
            int iCurrentPage = m_view.getCurrentPage();

            if (iPageCount > 1)
            {

                for (int iPage = 0; iPage < iPageCount; iPage++)
                {

                    // === compute page set (start and end index for this page)
                    int iStartIndex = iPage * iPageSize + 1;
                    int iEndIndex = (iPage + 1) * iPageSize;
                    if (iEndIndex >= m_view.getCount())
                    {
                        iEndIndex = m_view.getCount();
                    }

                    StringBuffer strPageSet = new StringBuffer();
                    strPageSet.append(iStartIndex);
                    strPageSet.append("..");
                    strPageSet.append(iEndIndex);
                    if (iCurrentPage == iPage)
                    {
                        w_p.write("<div  class=\"OwNumberBlockPageSelector_page_selected\">" + strPageSet.toString() + "</div>\n");
                    }
                    else
                    {
                        w_p.write("<div class=\"OwNumberBlockPageSelector_page\"><a href=\"" + getPageAbsolutURL(iPage) + "\">\n");
                        w_p.write("" + strPageSet);
                        w_p.write("</a></div>\n");
                    }
                }
            }

            if (m_view.canPageNext())
            {
                String text = m_view.getContext().localize("dmsdialogs.views.OwObjectListViewEXTJSGrid.PagingNextBlockText", "Next Pages");
                w_p.write("<div class=\"OwNumberBlockPageSelector_page\"><a title=\"" + text + "\" href=\"" + getPageNextURL() + "\">\n");
                if (m_useImages)
                {
                    w_p.write("<img title=\"" + text + "\" alt=\"" + text + "\" src=\"" + m_view.getContext().getDesignURL() + "/images/navigate_right_blue.gif\" />");
                }
                else
                {
                    w_p.write("&gt;");
                }
                w_p.write("</a></div>\n");
            }
            w_p.write(" </div>");
        }

    }

    /**
     * Initialize from configuration.
     */
    public void init() throws Exception
    {
        if (m_configNode != null)
        {
            Node node = OwXMLDOMUtil.getChildNode(m_configNode, "UseImages");
            if (node != null)
            {
                String useImages = node.getFirstChild().getNodeValue().trim();
                if (LOG.isDebugEnabled())
                {
                    LOG.debug("OwNumberBlockPageSelectorComponent.init: Read from the configuration, UseImages = " + useImages);
                }
                m_useImages = Boolean.valueOf(useImages).booleanValue();
            }
            else
            {
                if (LOG.isDebugEnabled())
                {
                    LOG.debug("OwNumberBlockPageSelectorComponent.init: No <UseImages> element found in the configuration, using default value = " + m_useImages);
                }
            }
        }
        else
        {
            LOG.debug("OwNumberBlockPageSelectorComponent.init: No config node set! Using the default paging component...");
        }
    }
}