package com.wewebu.ow.server.dmsdialogs.views;

import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.w3c.dom.Node;

import com.wewebu.ow.server.app.OwClientRefreshContext;
import com.wewebu.ow.server.app.OwFieldManager;
import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwObjectCollection;
import com.wewebu.ow.server.field.OwSort;

/**
 *<p>
 * List View: OwObject List View Combined.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 */
public class OwObjectListViewCombined extends OwObjectListView
{
    protected class OwObjectListViewRowCombined extends OwObjectListViewRow
    {
        public OwObjectListViewRowCombined(int iViewMask_p)
        {
            super(iViewMask_p);
        }
    }

    protected ArrayList m_SubViews = new ArrayList();

    /** a list of objects to be displayed */
    OwObjectCollection m_ObjectList = null;

    /** a list of column info, which describe the columns of the object list */
    protected Collection m_ColumnInfoList = null;

    /** construct a object list view
     * 
     * @param iViewMask_p int combination of VIEW_MASK_... defined flags
     */
    public OwObjectListViewCombined(int iViewMask_p)
    {
        // call super constructor
        super(iViewMask_p);
        // create subviews
        // TODO: Do from config node

        // this is a quick and dirty implementation with two hard-coded views until we have everything generic configurable
        m_SubViews.add(new OwObjectListViewRow(iViewMask_p));
        m_SubViews.add(new OwObjectListViewThumbnails(iViewMask_p));
        // suppress paging buttons in all subviews
        for (int i = 0; i < m_SubViews.size(); i++)
        {
            OwObjectListView subview = (OwObjectListView) m_SubViews.get(i);
            subview.setStickyFooterInUse(false);
            subview.addViewMask(VIEW_MASK_NO_PAGE_BUTTONS);
        }
    }

    /** construct a object list view
     */
    public OwObjectListViewCombined()
    {
        // call super constructor
        super();
        // create subviews
        // TODO: Do from config node

        // this is a quick and dirty implementation with two hard-coded views until we have everything generic configurable
        m_SubViews.add(new OwObjectListViewRow());
        m_SubViews.add(new OwObjectListViewThumbnails());
        // suppress paging buttons in all subviews
        for (int i = 0; i < m_SubViews.size(); i++)
        {
            OwObjectListView subview = (OwObjectListView) m_SubViews.get(i);
            subview.addViewMask(VIEW_MASK_NO_PAGE_BUTTONS);
        }
    }

    /** optional use the default constructor and set a config node to configure the view with XML 
     * This may override the settings in the ViewMaks, see setViewMask
     * 
     * @param node_p XML node with configuration information
     * @throws Exception 
     */
    public void setConfigNode(Node node_p) throws Exception
    {
        // TODO: Do generic from config node
        super.setConfigNode(node_p);
        // this is a quick and dirty implementation with two hard-coded views until we have everything generic configurable
        int iViewIndex = 0;
        for (Node n = node_p.getFirstChild(); n != null; n = n.getNextSibling())
        {
            if (n.getNodeName().equals("subview"))
            {
                OwObjectListView subview = (OwObjectListView) m_SubViews.get(iViewIndex++);
                subview.setConfigNode(n);
                subview.addViewMask(VIEW_MASK_NO_PAGE_BUTTONS);
            }
        }
    }

    /** 
     * Initialize the view after the context is set.
     */
    protected void init() throws Exception
    {
        super.init();
        for (int i = 0; i < m_SubViews.size(); i++)
        {
            OwObjectListView subview = (OwObjectListView) m_SubViews.get(i);
            addView(subview, null);
            subview.setStickyFooterInUse(false);
        }
        m_pageSelectorComponent = createPageSelector();
        setStickyFooterInUse(false);
    }

    /**
     * Set a <code>java.util.List</code> of <code>OwDocumentFunction</code> to be used by this
     * list. This list overrides the default set of document functions that are retrieved from
     * the context during init.
     *
     * @param pluginList_p the <code>java.util.List</code> of <code>OwDocumentFunction</code> to be used by this list. Must not be <code>null</code>.
     */
    public void setDocumentFunctionPluginList(List pluginList_p)
    {
        for (int i = 0; i < m_SubViews.size(); i++)
        {
            OwObjectListView subview = (OwObjectListView) m_SubViews.get(i);
            subview.setDocumentFunctionPluginList(pluginList_p);
        }
    }

    /** called when the view should create its HTML content to be displayed
     * @param w_p Writer object to write HTML to
     */
    protected void onRender(Writer w_p) throws Exception
    {
        boolean useHtml5DragAndDrop = ((OwMainAppContext) this.getContext()).isUseHtml5DragAndDrop();
        if (useHtml5DragAndDrop)
        {
            StringBuffer sb = new StringBuffer();
            sb.append("<script type=\"text/javascript\">\n");
            sb.append("var dropArea = document.getElementById('OwSublayout_ContentContainer');\n");
            sb.append("if(typeof addHtml5DropArea == 'function') {\n");
            sb.append("addHtml5DropArea(dropArea, false);\n");
            sb.append("}\n");
            sb.append("</script>\n");
            w_p.write(sb.toString());
        }

        // test if this list is valid to avoid multiple "This list has no entries" messages from each subview
        if (getIsList())
        {
            // render all subviews
            w_p.write("<div id=\"wrap\">");
            super.onRender(w_p);
            w_p.write("</div>");

            // render paging buttons
            if (getIsPaging())
            {
                w_p.write("<div id=\"footer\">");
                renderCombinedPageButtons(w_p);
                w_p.write("</div>");
            }
        }
        else
        {
            // list is empty. render own "list is empty" message
            w_p.write("<span id=\"emptyList\"  class=\"OwEmptyTextMessage\">" + getContext().localize("app.OwObjectListView.emptylist", "No items to display") + "</span>\n");
        }
    }

    /** checks if the view is shown maximized 
     * @return true, if view is maximized, false otherwise
     */
    public boolean isShowMaximized()
    {
        return getParent().isShowMaximized();
    }

    /** query string key for the page index. */
    protected static final String QUERY_KEY_PAGE_COMBINED = "combinedpage";

    /** check if paging is enabled
     * @return true = enabled, display page buttons, false = disabled
     */
    protected boolean isPagingEnabled()
    {
        return (!getParent().isShowMaximized());
    }

    /** same as getIsListValid() && ( ! getIsListEmpty() )
     * 
     * @return boolean true = valid list with at least one item to display
     */
    public boolean getIsList()
    {
        return getIsListValid() && (!getIsListEmpty());
    }

    /** check if list is configured well and can be displayed
     * 
     * @return boolean true = list is valid, false = no valid list, don't render anything yet
     */
    public boolean getIsListValid()
    {
        return ((m_ObjectList != null) && (m_ColumnInfoList != null));
    }

    /** check if list contains any items
     * 
     * @return boolean true = list contains at least one item
     */
    public boolean getIsListEmpty()
    {
        return (m_ObjectList.size() == 0);
    }

    /** check if page buttons should be rendered
     * 
     * @return true = render page buttons, false = no page buttons to render
     */
    public boolean getIsPaging()
    {
        return (isPagingEnabled() && (!hasViewMask(VIEW_MASK_NO_PAGE_BUTTONS)));
    }

    /** render the paging buttons for the combined view
     * @param w_p Writer object to write HTML to
     */
    protected void renderCombinedPageButtons(java.io.Writer w_p) throws Exception
    {
        m_pageSelectorComponent.render(w_p);
    }

    /** display next page of objects */
    public void onPageNext(HttpServletRequest request_p) throws Exception
    {
        pageAbsolut(getCurrentPage() + 1);
    }

    /** display previous page of objects */
    public void onPagePrev(HttpServletRequest request_p) throws Exception
    {
        pageAbsolut(getCurrentPage() - 1);
    }

    public int getPageCount() throws Exception
    {
        if (m_SubViews.size() > 0)
        {
            return ((OwObjectListView) m_SubViews.get(0)).getPageCount();
        }
        else
        {
            return (0);
        }
    }

    public int getCurrentPage()
    {
        if (m_SubViews.size() > 0)
        {
            return ((OwObjectListView) m_SubViews.get(0)).getCurrentPage();
        }
        else
        {
            return (0);
        }
    }

    /** check if there is a previous page
     * @return boolean true = there is a previous page, pagePrev is possible
     */
    public boolean canPagePrev()
    {
        if (m_SubViews.size() > 0)
        {
            return ((OwObjectListView) m_SubViews.get(0)).canPagePrev();
        }
        else
        {
            return (false);
        }
    }

    /** check if there is a next page
     * @return boolean true = there is a next page, pageNext is possible
     */
    public boolean canPageNext() throws Exception
    {
        if (m_SubViews.size() > 0)
        {
            return ((OwObjectListView) m_SubViews.get(0)).canPageNext();
        }
        else
        {
            return (false);
        }
    }

    public Collection getColumnInfo()
    {
        return m_ColumnInfoList;
    }

    public int getCount()
    {
        if (m_SubViews.size() > 0)
        {
            return ((OwObjectListView) m_SubViews.get(0)).getCount();
        }
        else
        {
            return 0;
        }
    }

    public OwFieldManager getFieldManager()
    {
        if (m_SubViews.size() > 0)
        {
            return ((OwObjectListView) m_SubViews.get(0)).getFieldManager();
        }
        else
        {
            return null;
        }
    }

    /** set the internal fieldmanager
     *  in case you want a specific fieldmanager
     */
    public void setFieldManager(OwFieldManager fielmanager_p)
    {
        Iterator it = m_SubViews.iterator();
        while (it.hasNext())
        {
            OwObjectListView subview = (OwObjectListView) it.next();
            subview.setFieldManager(fielmanager_p);
        }
    }

    public OwObjectCollection getObjectList()
    {
        return m_ObjectList;
    }

    public OwObject getParentObject()
    {
        if (m_SubViews.size() > 0)
        {
            return ((OwObjectListView) m_SubViews.get(0)).getParentObject();
        }
        else
        {
            return null;
        }
    }

    public Collection getRetrievalPropertyNames() throws Exception
    {
        if (m_SubViews.size() > 0)
        {
            return ((OwObjectListView) m_SubViews.get(0)).getRetrievalPropertyNames();
        }
        else
        {
            return null;
        }
    }

    public OwSort getSort()
    {
        if (m_SubViews.size() > 0)
        {
            return ((OwObjectListView) m_SubViews.get(0)).getSort();
        }
        else
        {
            return null;
        }
    }

    protected OwClientRefreshContext getRefreshContext()
    {
        if (m_SubViews.size() > 0)
        {
            return ((OwObjectListView) m_SubViews.get(0)).getRefreshContext();
        }
        else
        {
            return null;
        }
    }

    protected void pageAbsolut(int iPage_p) throws Exception
    {
        for (int i = 0; i < m_SubViews.size(); i++)
        {
            OwObjectListView subview = (OwObjectListView) m_SubViews.get(i);
            subview.pageAbsolut(iPage_p);
        }
    }

    public void setColumnInfo(Collection columnInfo_p)
    {
        m_ColumnInfoList = columnInfo_p;
        for (int i = 0; i < m_SubViews.size(); i++)
        {
            OwObjectListView subview = (OwObjectListView) m_SubViews.get(i);
            subview.setColumnInfo(columnInfo_p);
        }
    }

    public void setObjectList(OwObjectCollection objectList_p, OwObject parentObject_p) throws Exception
    {
        m_ObjectList = objectList_p;
        for (int i = 0; i < m_SubViews.size(); i++)
        {
            OwObjectListView subview = (OwObjectListView) m_SubViews.get(i);
            subview.setObjectList(objectList_p, parentObject_p);
        }
    }

    public void setRefreshContext(OwClientRefreshContext eventlistner_p)
    {
        for (int i = 0; i < m_SubViews.size(); i++)
        {
            OwObjectListView subview = (OwObjectListView) m_SubViews.get(i);
            subview.setRefreshContext(eventlistner_p);
        }
    }

    public void setSort(OwSort sort_p)
    {
        for (int i = 0; i < m_SubViews.size(); i++)
        {
            OwObjectListView subview = (OwObjectListView) m_SubViews.get(i);
            subview.setSort(sort_p);
        }
    }

    /** overridable title of the view
     * @return String localized display name for the view
     * */
    public String getTitle()
    {
        StringBuffer sTitle = new StringBuffer();

        sTitle.append(getContext().localize("dmsdialogs.views.OwObjectListViewCombined.title", "Combined:"));

        //sTitle.append(" (");
        sTitle.append(" ");

        Iterator it = m_SubViews.iterator();
        while (it.hasNext())
        {
            OwObjectListView subview = (OwObjectListView) it.next();
            sTitle.append(subview.getTitle());

            if (it.hasNext())
            {
                sTitle.append(", ");
            }
        }

        //sTitle.append(")");

        return sTitle.toString();
    }

    /** get the icon URL for this view to be displayed
    *
    *  @return String icon url, or null if not defined
    */
    public String getIcon() throws Exception
    {
        return "/images/OwObjectListView/OwObjectListViewCombined.png";
    }

    /** 
     * Register an eventlistener with this view to receive notifications.
     * Also propagates the event listener to subviews.
     * @param eventlister_p OwObjectListCollectionEventListner interface
     **/
    public void setEventListner(OwObjectListViewEventListner eventlister_p)
    {
        super.setEventListner(eventlister_p);
        for (Iterator i = m_SubViews.iterator(); i.hasNext();)
        {
            OwObjectListView listView = (OwObjectListView) i.next();
            listView.setEventListner(eventlister_p);
        }
    }

    /**
     * @see com.wewebu.ow.server.dmsdialogs.views.OwObjectListView#onPageAbsolut(javax.servlet.http.HttpServletRequest)
     * @since 2.5.2.0
     */
    public void onPageAbsolut(HttpServletRequest request_p) throws Exception
    {
        pageAbsolut(Integer.parseInt(request_p.getParameter(QUERY_KEY_PAGE)));
    }
}
