package com.wewebu.ow.server.ecmimpl;

import com.wewebu.ow.server.ao.OwAOType;
import com.wewebu.ow.server.ao.OwAOTypeImpl;
import com.wewebu.ow.server.ao.OwRoleManagedAOImpl;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwVirtualFolderObject;
import com.wewebu.ow.server.field.OwSearchTemplate;
import com.wewebu.ow.server.role.OwRoleManager;
import com.wewebu.ow.server.util.OwAttributeBag;
import com.wewebu.ow.server.util.OwAttributeBagIterator;
import com.wewebu.ow.server.util.OwAttributeBagWriteable;

/**
 *<p>
 * Class of constants for Application Object type specification.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 *@since 4.0.0.0
 */
public class OwAOConstants
{
    /** object type for the virtual folders  (Type: OwVirtualFolderObjectFactory)*/
    public static final int AO_TYPE_VIRTUAL_FOLDER = 1;
    /** object type for the preferences, which can be user or application defined, like user settings, recent file list... (Type: OwObject) */
    public static final int AO_TYPE_PREFERENCES = 2;
    /** object type for the search templates (Type: OwSearchTemplate) */
    public static final int AO_TYPE_SEARCHTEMPLATE = 3;
    /** object type for the XML streams (Type: org.w3c.dom.Node) */
    public static final int AO_TYPE_XML_DOCUMENT = 4;
    /** object type for the attribute bags (Type: OwAttributeBag)*/
    public static final int AO_TYPE_ATTRIBUTE_BAG = 5;
    /** object type for the attribute bags (Type: OwAttributeBagIterator)*/
    public static final int AO_TYPE_ATTRIBUTE_BAG_ITERATOR = 6;
    /** object type for the writable attribute bags like databases (Type: OwAttributeBagWritable)*/
    public static final int AO_TYPE_ATTRIBUTE_BAG_WRITEABLE = 7;
    /** object type for the enumeration collections for choicelists (Type: OwEnumCollection) */
    public static final int AO_TYPE_ENUM_COLLECTION = 8;
    /** object type for the read only attribute bags like databases (Type: OwAttributeBagWritable), i.e.: the attributenames of the bag represent the users */
    public static final int AO_TYPE_INVERTED_ATTRIBUTE_BAG = 9;
    /** object type representing an entry template*/
    public static final int AO_TYPE_ENTRY_TEMPLATE = 10;

    /** Reserved for BPM specific handling, range = [20-30[*/
    public static final int AO_TYPE_BPM_RESERVED = 20;
    /** object type for the search templates (Type: OwSearchTemplate) */
    public static final int AO_TYPE_BPM_VIRTUAL_QUEUES = 23;
    /** object type for the enumeration collections (Type: OwEnumCollection) */
    public static final int AO_TYPE_BPM_ENUM_COLLECTION = 28;

    /** user defined object types start here */
    public static final int AO_TYPE_USER_START = 0x1000;

    public static final OwAOType<OwVirtualFolderObject> AO_VIRTUAL_FOLDER = new OwRoleManagedAOImpl<OwVirtualFolderObject>(AO_TYPE_VIRTUAL_FOLDER, OwVirtualFolderObject.class, OwRoleManager.ROLE_CATEGORY_VIRTUAL_FOLDER) {

        @Override
        protected String resourceFromObject(OwVirtualFolderObject object)
        {
            return object.getVirtualFolderName();
        }

    };

    public static final OwAOType<OwObject> AO_PREFERENCES = new OwAOTypeImpl<OwObject>(AO_TYPE_PREFERENCES, OwObject.class);

    public static final OwAOType<OwSearchTemplate> AO_SEARCHTEMPLATE = new OwRoleManagedAOImpl<OwSearchTemplate>(AO_TYPE_SEARCHTEMPLATE, OwSearchTemplate.class, OwRoleManager.ROLE_CATEGORY_SEARCH_TEMPLATE) {

        @Override
        protected String resourceFromObject(OwSearchTemplate object)
        {
            return object.getName();
        }
    };

    public static final OwAOType<org.w3c.dom.Node> AO_XML_DOCUMENT = new OwAOTypeImpl<org.w3c.dom.Node>(AO_TYPE_XML_DOCUMENT, org.w3c.dom.Node.class);

    public static final OwAOType<OwAttributeBag> AO_ATTRIBUTE_BAG = new OwAOTypeImpl<OwAttributeBag>(AO_TYPE_ATTRIBUTE_BAG, OwAttributeBag.class);

    public static final OwAOType<OwAttributeBagIterator> AO_ATTRIBUTE_BAG_ITERATOR = new OwAOTypeImpl<OwAttributeBagIterator>(AO_TYPE_ATTRIBUTE_BAG_ITERATOR, OwAttributeBagIterator.class);

    public static final OwAOType<OwAttributeBagWriteable> AO_ATTRIBUTE_BAG_WRITABLE = new OwAOTypeImpl<OwAttributeBagWriteable>(AO_TYPE_ATTRIBUTE_BAG_WRITEABLE, OwAttributeBagWriteable.class);

    public static final OwAOType<OwAttributeBagWriteable> AO_INVERTED_ATTRIBUTE_BAG = new OwAOTypeImpl<OwAttributeBagWriteable>(AO_TYPE_INVERTED_ATTRIBUTE_BAG, OwAttributeBagWriteable.class);

    public static final OwAOType<OwSearchTemplate> AO_BPM_VIRTUAL_QUEUES = new OwAOTypeImpl<OwSearchTemplate>(AO_TYPE_BPM_VIRTUAL_QUEUES, OwSearchTemplate.class);
}
