package com.wewebu.ow.server.util.upload;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;

import com.wewebu.ow.server.util.OwMimeTypes;

/**
 *<p>
 * Helper class for upload.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 */
public class UploadHelper
{
    /* PROPERTIES of the MIME Types */
    static Hashtable m_table = new Hashtable();

    static
    {
        m_table.put("TIF", "image/tiff");
        m_table.put("TIFF", "image/tiff");
        m_table.put("JPG", "image/jpeg");
        m_table.put("JPEG", "image/jpeg");
        m_table.put("JPE", "image/jpeg");
        m_table.put("BMP", "image/bmp");
        m_table.put("GIF", "image/gif");
        m_table.put("TXT", "text/plain");
        m_table.put("HTM", "text/html");
        m_table.put("HTML", "text/html");
    }

    /**
     *  
     */
    public UploadHelper()
    {

    }

    /**
     * determines the document format and returns it as a property object value
     * 
     * @param fileList_p
     * @return Object the document format
     * @throws Exception
     */
    static public Object getDocumentFormatProperty(List fileList_p) throws Exception
    {
        Object propertyValueObject = null;

        StringBuffer fileName = null;
        String tempType = null;
        boolean mimeTypeFlag = false;
        String mimeType = null;

        String mimeTypeList[] = new String[fileList_p.size()];
        Iterator it = fileList_p.iterator();
        int i = 0;
        while (it.hasNext())
        {
            String tempFileName = (String) it.next();
            int j = tempFileName.lastIndexOf(".");
            mimeTypeList[i] = tempFileName.substring(j + 1);

            if (mimeTypeList[i].equalsIgnoreCase("jpg") || mimeTypeList[i].equalsIgnoreCase("jpeg"))
            {
                mimeTypeList[i] = "jpeg";
            }
            if (mimeTypeList[i].equalsIgnoreCase("tif") || mimeTypeList[i].equalsIgnoreCase("tiff"))
            {
                mimeTypeList[i] = "tiff";
            }
            if (fileName != null)
            {
                fileName.append(",");
            }
            else
            {
                fileName = new StringBuffer();
            }
            fileName.append(tempFileName);
            i++;
        }// end of arrayFileNames for loop

        // check if all files have the same MIME types.
        if (mimeTypeList != null && mimeTypeList.length > 0)
        {
            tempType = mimeTypeList[0];
            for (int k = 0; k < mimeTypeList.length; k++)
            {
                if (mimeTypeList[k].equalsIgnoreCase(tempType))
                {
                    mimeTypeFlag = true;
                }
                else
                {
                    mimeTypeFlag = false;
                    break;
                }
            }
        }

        String propMimeType = null;
        if (mimeTypeFlag)
        {
            mimeType = tempType;
            /* 
              Set keySet = m_table.keySet();
              Iterator iter = keySet.iterator();
              while (iter.hasNext())
              {
                  String tempMimeType = (String) iter.next();
                  if (tempMimeType.equalsIgnoreCase(mimeType))
                  {
                      propMimeType = (String) m_table.get(tempMimeType);
                  }
              }
              */
            propMimeType = OwMimeTypes.getMimeTypeFromExtension(mimeType);
        }

        if (propMimeType != null)
        {
            mimeType = propMimeType;
        }
        else
        {
            mimeType = "application/octet-stream";
        }

        if (mimeType != null)
        {
            if (fileName == null)
            {
                propertyValueObject = mimeType;
            }
            else
            {
                propertyValueObject = mimeType + ";name=" + fileName.toString();
            }
        }
        else
        {
            if (fileName != null)
            {
                propertyValueObject = ";name=" + fileName.toString();
            }
        }
        return propertyValueObject;
    }
}