package com.wewebu.ow.server.ecmimpl.opencmis.alfresco;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import org.alfresco.cmis.client.AlfrescoAspects;
import org.alfresco.cmis.client.impl.AlfrescoUtils;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.ObjectFactory;
import org.apache.chemistry.opencmis.client.api.ObjectType;
import org.apache.chemistry.opencmis.client.api.OperationContext;
import org.apache.chemistry.opencmis.client.api.Property;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.client.api.TransientCmisObject;
import org.apache.chemistry.opencmis.commons.PropertyIds;
import org.apache.chemistry.opencmis.commons.data.CmisExtensionElement;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.enums.ExtensionLevel;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.CmisExtensionElementImpl;

import com.wewebu.ow.server.ecmimpl.opencmis.object.OwCMISBatchTransientObject;
import com.wewebu.ow.server.exceptions.OwException;

/**
 *<p>
 * Implements batch Alfresco-aspect property extension data tweaking during caching operations. 
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 */
public class OwCMISAlfrescoBatchTransientObject<N extends TransientCmisObject> extends OwCMISBatchTransientObject<N> implements OwCMISAlfrescoTransientObject<N>
{
    private static final String ASPECTS_EXTENSION_NAME = "aspects";

    public OwCMISAlfrescoBatchTransientObject(N transientCmisObject, OperationContext creationContext, Session session)
    {
        super(transientCmisObject, creationContext, session);
    }

    @Override
    public synchronized N secureAspects() throws OwException
    {
        if (mustSecureAspects())
        {
            this.contextBoundObject = this.retrieveProperties(Collections.EMPTY_SET);
        }

        return getTransientCmisObject();
    }

    @Override
    public synchronized boolean mustSecureAspects()
    {
        List<CmisExtensionElement> propertiesExtensions = getTransientCmisObject().getInputExtensions(ExtensionLevel.PROPERTIES);
        return OwCMISSecureAspectsExtensionUtil.containsMustSecureAspects(propertiesExtensions);
    }

    private List<CmisExtensionElement> convertAlfrescoExtension(List<CmisExtensionElement> extensions, String[] fromName, String[] toName, int index)
    {
        if (extensions != null)
        {

            List<CmisExtensionElement> replacementList = new LinkedList<CmisExtensionElement>();

            for (CmisExtensionElement extension : extensions)
            {
                CmisExtensionElement replacement = convertAlfrescoExtension(extension, fromName, toName, index);
                replacementList.add(replacement);
            }

            return replacementList;
        }
        else
        {
            return extensions;
        }
    }

    private CmisExtensionElement convertAlfrescoExtension(CmisExtensionElement extension, String[] fromName, String[] toName, int index)
    {
        if (index < fromName.length && index < toName.length)
        {
            if (fromName[index].equals(extension.getName()))
            {
                if (extension.getValue() == null)
                {
                    List<CmisExtensionElement> childrenReplacement = convertAlfrescoExtension(extension.getChildren(), fromName, toName, index + 1);
                    return new CmisExtensionElementImpl(extension.getNamespace(), toName[index], extension.getAttributes(), childrenReplacement);
                }
                else
                {
                    return new CmisExtensionElementImpl(extension.getNamespace(), toName[index], extension.getAttributes(), extension.getValue());
                }
            }
            else
            {
                return extension;
            }
        }
        else
        {
            return extension;
        }
    }

    private CmisExtensionElement find(List<CmisExtensionElement> extension, String elementName)
    {
        CmisExtensionElement searchedElement = null;

        for (CmisExtensionElement element : extension)
        {
            if (elementName.equals(element.getName()))
            {
                searchedElement = element;
                break;
            }
        }

        return searchedElement;
    }

    private StringBuilder toAspectsType(List<CmisExtensionElement> extension, List<String> ommitAspects)
    {
        StringBuilder aspectsBuilder = new StringBuilder();
        CmisExtensionElement aspects = find(extension, ASPECTS_EXTENSION_NAME);
        for (CmisExtensionElement aspectExtension : aspects.getChildren())
        {
            if (AlfrescoUtils.APPLIED_ASPECTS.equals(aspectExtension.getName()))
            {
                String aspectName = aspectExtension.getValue();
                if (!ommitAspects.contains(aspectName))
                {
                    aspectsBuilder.append(",");
                    aspectsBuilder.append(aspectName);
                }
            }
        }

        return aspectsBuilder;
    }

    @Override
    protected ObjectData mergeProperties(CmisObject cmisObject, Map<String, Property<?>> add, Collection<String> remove, List<CmisExtensionElement> extensions)
    {
        if (cmisObject instanceof AlfrescoAspects)
        {
            AlfrescoAspects aspectsObject = (AlfrescoAspects) cmisObject;

            Collection<ObjectType> aspects = aspectsObject.getAspects();
            StringBuilder typeId = new StringBuilder();
            typeId.append(cmisObject.getType().getId());
            List<String> alreadyApplied = new LinkedList<String>();
            if (aspects != null)
            {
                for (ObjectType objectType : aspects)
                {
                    typeId.append(",");
                    typeId.append(objectType.getId());
                    alreadyApplied.add(objectType.getId());
                }
            }

            if (extensions != null)
            {
                typeId.append(toAspectsType(extensions, alreadyApplied));
            }

            ObjectType objectType = cmisObject.getType();
            Map<String, PropertyDefinition<?>> propertyDefinitions = objectType.getPropertyDefinitions();
            PropertyDefinition<String> objectTypeIdDefinition = (PropertyDefinition<String>) propertyDefinitions.get(PropertyIds.OBJECT_TYPE_ID);
            Session mySession = getSession();
            ObjectFactory objectFactory = mySession.getObjectFactory();
            List<String> values = new LinkedList<String>();
            values.add(typeId.toString());

            Map<String, Property<?>> addWithAlfrescoType = new HashMap<String, Property<?>>();
            if (add != null)
            {
                addWithAlfrescoType.putAll(add);
            }
            Property<String> idProperty = objectFactory.createProperty(objectTypeIdDefinition, values);
            addWithAlfrescoType.put(PropertyIds.OBJECT_TYPE_ID, idProperty);

            add = addWithAlfrescoType;
        }
        ObjectData objectData = super.mergeProperties(cmisObject, add, remove, extensions);
        Properties objectDataProperties = objectData.getProperties();
        List<CmisExtensionElement> objecctDataExtensions = convertAlfrescoExtension(objectDataProperties.getExtensions(), new String[] { AlfrescoUtils.SET_ASPECTS, AlfrescoUtils.ASPECTS_TO_ADD }, new String[] { ASPECTS_EXTENSION_NAME,
                AlfrescoUtils.APPLIED_ASPECTS }, 0);
        //        addAspects(objecctDataExtensions, extensions);

        objectDataProperties.setExtensions(objecctDataExtensions);
        return objectData;
    }

}
