package com.wewebu.ow.server.ecmimpl.opencmis.alfresco;

import com.wewebu.ow.csqlc.OwSQLEntitiesResolver;
import com.wewebu.ow.server.ecmimpl.opencmis.search.OwCMISCSQLCProcessor;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.field.OwFieldDefinition;
import com.wewebu.ow.server.field.OwSearchCriteria;
import com.wewebu.ow.server.util.OwString;

/**
 *<p>
 * Special processor including workarounds for the Alfresco-CMIS search.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 */
public class OwCMISAlfrescoCSQLCProcessor extends OwCMISCSQLCProcessor
{
    private static final String ALL = "ALL:";
    private static final char TILDE = '\u007e';
    private static final char COLON = '\u003a';

    public OwCMISAlfrescoCSQLCProcessor(OwSQLEntitiesResolver entitiesResolver_p)
    {
        super(entitiesResolver_p);
    }

    private String textSearchValue(Object value_p)
    {
        String value = "'" + (value_p == null ? "" : value_p.toString()) + "'";
        return escape(value);
    }

    private String escape(String string_p)
    {
        StringBuilder builder = new StringBuilder(string_p);

        OwString.replaceAll(builder, "\\", "\\\\");
        OwString.replaceAll(builder, "'", "\\'");

        return builder.toString();
    }

    protected String createCBRAllExpression(OwSearchCriteria criteria_p, OwProcessContext context_p) throws OwException
    {
        Object criteriaValue = criteria_p.getValue();
        if (criteriaValue == null || criteriaValue.toString().length() == 0)
        {
            return null;
        }
        return ALL + textSearchValue(criteriaValue);
    }

    protected String createCBRInExpression(OwSearchCriteria criteria_p, OwProcessContext context_p) throws OwException
    {
        Object criteriaValue = criteria_p.getValue();
        if (criteriaValue == null || criteriaValue.toString().length() == 0)
        {
            return null;
        }

        OwFieldDefinition fieldDefinition = retrieveDefinition(criteria_p);

        String fieldName = createQueryFieldName(fieldDefinition, context_p);

        String value = textSearchValue(criteriaValue);

        return TILDE + fieldName + COLON + value;
    }

}
