package com.wewebu.ow.server.ecmimpl.opencmis.auth;

import org.apache.log4j.Logger;

import com.wewebu.ow.server.ecm.OwUserInfo;
import com.wewebu.ow.server.ecm.ui.OwUIUserSelectModul;
import com.wewebu.ow.server.ecmimpl.opencmis.OwCMISNetwork;
import com.wewebu.ow.server.ecmimpl.opencmis.ui.OwCMISUserSelectionModule;
import com.wewebu.ow.server.ecmimpl.opencmis.users.OwUsersRepository;
import com.wewebu.ow.server.ecmimpl.opencmis.users.OwUsersRepositoryAlfresco;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwServerException;
import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.util.OwAuthenticationConfiguration;

/**
 *<p>
 * Alfresco based authentication provider for the Open CMIS adapter.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 *@since 4.1.1.0
 */
public class OwCMISAlfrescoAuthenticationProvider extends OwCMISDefaultAuthenticationProvider
{
    private static final Logger LOG = OwLogCore.getLogger(OwCMISAlfrescoAuthenticationProvider.class);

    private OwUsersRepository userRepository;

    /**
     * @param network
     */
    public OwCMISAlfrescoAuthenticationProvider(OwCMISNetwork network)
    {
        super(network);
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecmimpl.opencmis.auth.OwCMISDefaultAuthenticationProvider#canUserSelect()
     */
    @Override
    public boolean canUserSelect() throws OwException
    {
        return true;
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecmimpl.opencmis.auth.OwCMISDefaultAuthenticationProvider#loginDefault(java.lang.String, java.lang.String)
     */
    @Override
    public void loginDefault(String strUser_p, String strPassword_p) throws OwException
    {
        OwAuthenticationConfiguration authenticationConfiguration = this.network.getNetworkConfiguration().getAuthenticationConfiguration();
        String baseURL = null;
        try
        {
            baseURL = authenticationConfiguration.getConfiguration().getSubNode("BaseURL").getTextContent();
        }
        catch (Exception e)
        {
            throw new OwServerException("Could not get BaseUrl from configuration!", e);
        }
        this.userRepository = createUserRepositoryInstance(strUser_p, strPassword_p, baseURL);
        super.loginDefault(strUser_p, strPassword_p);
    }

    protected OwUsersRepositoryAlfresco createUserRepositoryInstance(String strUser_p, String strPassword_p, String baseURL)
    {
        return new OwUsersRepositoryAlfresco(baseURL, strUser_p, strPassword_p);
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecmimpl.opencmis.auth.OwCMISDefaultAuthenticationProvider#getUserFromID(java.lang.String)
     */
    @Override
    public OwUserInfo getUserFromID(String strID_p) throws OwException
    {
        return this.userRepository.findUserByID(strID_p);
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecmimpl.opencmis.auth.OwCMISDefaultAuthenticationProvider#getUserSelectSubModul(java.lang.String, int[])
     */
    @Override
    public OwUIUserSelectModul getUserSelectSubModul(String strID_p, int[] types_p) throws OwException
    {
        OwCMISUserSelectionModule module = new OwCMISUserSelectionModule(this.userRepository);
        module.setFilter(types_p);
        module.setCurrentUserID(strID_p);
        try
        {
            module.init(this.network);
        }
        catch (OwException e)
        {
            throw e;
        }
        catch (Exception e)
        {
            String msg = "Cannot initialize the User selection module";
            LOG.error(msg, e);
            throw new OwServerException(this.network.getContext().localize("opencmis.OwCMISNetwork.err.initUserSelectEx", "Cannot initialize the User Selection dialog."), e);
        }
        return module;
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecmimpl.opencmis.auth.OwCMISDefaultAuthenticationProvider#createAuthenticator()
     */
    @Override
    protected OwCMISCredentialsAuthenticator createAuthenticator() throws OwException
    {
        return new OwCMISAlfrescoCredentialsAuthenticator(network, (OwUsersRepositoryAlfresco) this.userRepository);
    }
}
