package com.wewebu.ow.server.ecmimpl.opencmis.auth;

import com.wewebu.ow.server.auth.OwAuthentication;
import com.wewebu.ow.server.auth.OwAuthenticationContext;
import com.wewebu.ow.server.auth.OwCredentialsAuthentication;
import com.wewebu.ow.server.ecm.OwAuthenticationProvider;
import com.wewebu.ow.server.ecm.OwCredentials;
import com.wewebu.ow.server.ecm.OwUserInfo;
import com.wewebu.ow.server.ecm.ui.OwUILoginModul;
import com.wewebu.ow.server.ecm.ui.OwUIUserSelectModul;
import com.wewebu.ow.server.ecmimpl.opencmis.OwCMISNetwork;
import com.wewebu.ow.server.ecmimpl.opencmis.ui.OwCMISUILoginModule;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.exceptions.OwServerException;
import com.wewebu.ow.server.mandator.OwMandator;
import com.wewebu.ow.server.util.OwString;

/**
 *<p>
 * Default authentication provider for the Open CMIS adaptor.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 */
public class OwCMISDefaultAuthenticationProvider implements OwAuthenticationProvider
{
    private OwCMISCredentials credentials;
    private OwMandator mandator;
    protected OwCMISNetwork network;

    public OwCMISDefaultAuthenticationProvider(OwCMISNetwork network)
    {
        this.network = network;
        this.mandator = this.network.getContext().getMandator();
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.OwAuthenticationProvider#getLoginSubModul()
     */
    @SuppressWarnings("rawtypes")
    @Override
    public OwUILoginModul getLoginSubModul() throws OwException
    {
        OwCMISUILoginModule module = new OwCMISUILoginModule();
        try
        {
            module.init(this.network);
        }
        catch (OwException e)
        {
            throw e;
        }
        return module;
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.OwAuthenticationProvider#getUserSelectSubModul(java.lang.String, int[])
     */
    @Override
    public OwUIUserSelectModul getUserSelectSubModul(String strID_p, int[] types_p) throws OwException
    {
        OwString errMessage = new OwString("opencmis.auth.OwCMISDefaultAuthenticationProvider.err.userSelection.notImplemented", "User selection is not supported in this implementation!");
        throw new OwInvalidOperationException(errMessage);
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.OwAuthenticationProvider#canUserSelect()
     */
    @Override
    public boolean canUserSelect() throws OwException
    {
        return false;
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.OwAuthenticationProvider#getCredentials()
     */
    @Override
    public OwCredentials getCredentials() throws OwException
    {
        return this.credentials;
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.OwAuthenticationProvider#getUserFromID(java.lang.String)
     */
    @Override
    public OwUserInfo getUserFromID(String strID_p) throws OwException
    {
        throw new OwServerException("This method is not implemented for the default Authentication provider.");
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.OwAuthenticationProvider#getRoleDisplayName(java.lang.String)
     */
    @Override
    public String getRoleDisplayName(String strRoleName_p) throws OwException
    {
        // TODO retrieve display name if possible
        return strRoleName_p;
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.OwAuthenticationProvider#logout()
     */
    @Override
    public void logout() throws OwException
    {
        if (this.credentials != null)
        {
            this.credentials.invalidate();
            this.credentials = null;
        }
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.OwAuthenticationProvider#loginDefault(java.lang.String, java.lang.String)
     */
    @Override
    public void loginDefault(String strUser_p, String strPassword_p) throws OwException
    {
        OwAuthenticationContext authenticationContext = this.network.getAuthenticationContext();
        if (authenticationContext.getAuthentication() == null)
        {
            OwCMISCredentialsAuthenticator authenticator = createAuthenticator();
            OwAuthentication authentication = new OwCredentialsAuthentication(null, strUser_p, strPassword_p);
            authentication = authenticator.authenticate(authentication);

            if (authentication.isAuthenticated())
            {
                OwCMISCredentials credentials = (OwCMISCredentials) authentication.getOWDCredentials();

                credentials.setMandator(this.mandator);
                this.credentials = credentials;

                authenticationContext.setAuthentication(authentication);
            }
        }
        else
        {
            this.credentials = (OwCMISCredentials) authenticationContext.getAuthentication().getOWDCredentials();
        }
    }

    protected OwCMISCredentialsAuthenticator createAuthenticator() throws OwException
    {
        return new OwCMISCredentialsAuthenticator(this.network);
    }
}