package com.wewebu.ow.server.ecmimpl.opencmis.users.alfresco;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Uniform;
import org.restlet.data.ChallengeScheme;
import org.restlet.resource.ClientResource;

/**
 *<p>
 * Factory to create RESTful resources.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 *@since  4.1.1.0
 */
public class AlfrescoRESTFulFactory
{
    private String baseURL;
    private String userName;
    private String password;

    //    private ArrayList<Preference<Language>> acceptedLanguages;

    /**
     * @param baseURL baseURL to use for accessing Alfresco RESTful services.
     * @param password 
     * @param userName 
     */
    public AlfrescoRESTFulFactory(String baseURL, String userName, String password)
    {
        this.baseURL = baseURL;
        this.userName = userName;
        this.password = password;

        //        OwNetworkContext ctx = this.network.getContext();
        //        Locale currentLocale = ctx.getLocale();
        //        Language language = Language.valueOf(currentLocale.getLanguage());

        //        Preference<Language> currentLanguage = new Preference<Language>(language);
        //        this.acceptedLanguages = new ArrayList<Preference<Language>>();
        //        acceptedLanguages.add(currentLanguage);
    }

    public void setPassword(String password)
    {
        this.password = password;
    }

    public void setUserName(String userName)
    {
        this.userName = userName;
    }

    public ListGroupsResource listGroupsResource(String shortNameFilter) throws OwRestException
    {
        String resourceURI = String.format("%s/service/api/groups?shortNameFilter=%s", this.baseURL, encodeValue(shortNameFilter));
        return createResourceFor(resourceURI, ListGroupsResource.class);
    }

    public ListPeopleResource getPeopleResource(String filterQuery) throws OwRestException
    {
        String resourceURI = String.format("%s/service/api/people?filter=%s", this.baseURL, encodeValue(filterQuery));
        return createResourceFor(resourceURI, ListPeopleResource.class);
    }

    public GetPersonResource getPersonResource(String userName) throws OwRestException
    {
        String resourceURI = String.format("%s/service/api/people/%s?groups=true", this.baseURL, encodeValue(userName));
        return createResourceFor(resourceURI, GetPersonResource.class);
    }

    private String encodeValue(String aStringValue) throws OwRestException
    {
        String encodeValue = null;
        try
        {
            encodeValue = URLEncoder.encode(aStringValue, "UTF-8");
        }
        catch (UnsupportedEncodingException encEx)
        {
            throw new OwRestException("Could not encode the filter!", encEx);
        }
        return encodeValue;
    }

    private <T> T createResourceFor(String resourceURI, Class<T> wrappedClass) throws OwRestException
    {
        ClientResource cr = new ClientResource(resourceURI);
        cr.setChallengeResponse(ChallengeScheme.HTTP_BASIC, this.userName, this.password);
        cr.getConverterService().setEnabled(true);

        T resource = cr.wrap(wrappedClass);

        final Uniform originalNext = cr.getNext();
        cr.setNext(new Uniform() {

            public void handle(Request request, Response response)
            {
                //                request.getClientInfo().setAcceptedLanguages(acceptedLanguages);
                if (null != originalNext)
                {
                    originalNext.handle(request, response);
                }
            }
        });

        //        cr.getClientInfo().setAcceptedLanguages(acceptedLanguages);
        return resource;
    }
}