package com.wewebu.ow.server.ecmimpl.cmis;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import org.apache.log4j.Logger;

import com.wewebu.ow.server.ecm.OwContentCollection;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwObjectCollection;
import com.wewebu.ow.server.ecm.OwObjectReference;
import com.wewebu.ow.server.ecm.OwPermissionCollection;
import com.wewebu.ow.server.ecm.OwProperty;
import com.wewebu.ow.server.ecm.OwPropertyCollection;
import com.wewebu.ow.server.ecm.OwStandardPropertyClass;
import com.wewebu.ow.server.ecm.OwStandardPropertyCollection;
import com.wewebu.ow.server.ecm.OwVersion;
import com.wewebu.ow.server.ecm.OwVersionSeries;
import com.wewebu.ow.server.ecmimpl.cmis.log.OwLog;
import com.wewebu.ow.server.ecmimpl.cmis.object.OwCMISRepositoryObject;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.exceptions.OwNotSupportedException;
import com.wewebu.ow.server.exceptions.OwObjectNotFoundException;
import com.wewebu.ow.server.exceptions.OwServerException;
import com.wewebu.ow.server.field.OwField;
import com.wewebu.ow.server.util.OwString;
import com.wewebu.ow.server.util.OwString1;

/**
 *<p>
 * Domain folder implementation base class.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 *@since 3.1.0.0
 */
public abstract class OwCMISAbstractDomainFolder implements OwObject
{
    /** package logger for the class */
    private static final Logger LOG = OwLog.getLogger(OwCMISAbstractDomainFolder.class);

    private OwPropertyCollection m_properties;

    /** String representing DMSID, which is create on request
     * @see #getDMSID() getDMSID() */
    private String m_dmsid;

    /** OwCMISNetwork reference */
    protected OwCMISNetwork m_network;

    private Object m_uniqueObject = new Object();

    public OwCMISAbstractDomainFolder(OwCMISNetwork network_p)
    {
        m_network = network_p;
        m_properties = new OwStandardPropertyCollection();
    }

    /**
     * Creates a DMSID for this domain folder.<br />
     * The ID of this object is used {@link #getID()} and attached as hash code
     * to the DMSID representation.<br />
     * Like: <code>"DMS_PREFIX,ResourceID,"+Integer.toString(getID().hashCode())</code>
     * @return String representing an DMSID.
     */
    public String getDMSID()
    {
        if (m_dmsid == null)
        {
            m_dmsid = OwCMISStandardDMSIDDecoder.DMS_PREFIX + "," + getName() + "," + Integer.toString(getID().hashCode());
        }
        return m_dmsid;
    }

    public final String getID()
    {
        return getName() + m_uniqueObject.hashCode();
    }

    public OwPropertyCollection getProperties(Collection propertyNames_p) throws OwException
    {
        return m_properties;
    }

    public OwProperty getProperty(String strPropertyName_p) throws OwException
    {
        OwProperty ret = (OwProperty) m_properties.get(strPropertyName_p);

        if (ret == null)
        {
            if (LOG.isDebugEnabled())
            {
                LOG.debug("OwCMISAbstractDomainFolder.getProperty: no such property " + strPropertyName_p + " found !");
            }
            throw new OwObjectNotFoundException(new OwString1("ecmimpl.cmis.OwCMISAbstractDomainFolder.property.value.found.error", "No value found for the %1 property!", strPropertyName_p));
        }

        return ret;
    }

    public OwField getField(String strFieldClassName_p) throws OwException
    {
        return getProperty(strFieldClassName_p);
    }

    public Collection getFields() throws OwException
    {
        return getProperties(null).values();
    }

    public void setProperties(OwPropertyCollection properties_p, Object mode_p) throws OwException
    {
        setProperties(properties_p);
    }

    public void setProperties(OwPropertyCollection properties_p) throws OwException
    {

    }

    public void add(OwObject oObject_p) throws OwException
    {
        LOG.error("OwCMISAbstractDomainFolder.add: adding of objects to CMIS domain folder objects is not supported!");
        throw new OwNotSupportedException(OwString.localize(m_network.getLocale(), "ecmimpl.cmis.unsupported.object.operation", "Unsupported CMIS adapter object operation!"));
    }

    public boolean canAdd(OwObject oObject_p, int iContext_p) throws OwException
    {
        return false;
    }

    public void move(OwObject oObject_p, OwObject oldParent_p) throws OwException
    {
        // not supported
    }

    public boolean canMove(OwObject oObject_p, OwObject oldParent_p, int iContext_p) throws OwException
    {
        return false;
    }

    public boolean canDelete(int iContext_p) throws OwException
    {
        return false;
    }

    public boolean canGetProperties(int iContext_p) throws OwException
    {
        return false;
    }

    public boolean canLock() throws OwException
    {
        return false;
    }

    public boolean canRemoveReference(OwObject oObject_p, int iContext_p) throws OwException
    {
        return false;
    }

    public boolean canGetContent(int iContentType_p, int iContext_p) throws OwException
    {
        return false;
    }

    public boolean canSetContent(int iContentType_p, int iContext_p) throws OwException
    {
        return false;
    }

    public boolean canSetProperties(int iContext_p) throws OwException
    {
        return false;
    }

    public void delete() throws OwException
    {
    }

    public boolean canFilterChilds() throws OwException
    {
        return false;
    }

    public java.util.Collection getFilterProperties(java.util.Collection propertynames_p) throws OwException
    {
        return null;
    }

    public OwPropertyCollection getClonedProperties(java.util.Collection strPropertyNames_p) throws OwException
    {
        try
        {
            return OwStandardPropertyClass.getClonedProperties(this, strPropertyNames_p);
        }
        catch (OwException owdException)
        {
            throw owdException;
        }
        catch (Exception e)
        {
            String msg = "OwCMISAbstractDomainFolder.getClonedProperties: Error during cloning of properties collection.";
            LOG.warn(msg, e);
            throw new OwServerException(msg, e);
        }
    }

    public java.util.Collection getColumnInfoList() throws OwException
    {
        return null;
    }

    public boolean getLock(int iContext_p) throws OwException
    {
        return false;
    }

    public boolean getMyLock(int iContext_p) throws OwException
    {
        return false;
    }

    public String getLockUserID(int iContext_p) throws OwException
    {
        return null;
    }

    public OwPermissionCollection getPermissions() throws OwException
    {
        return null;
    }

    public OwPermissionCollection getClonedPermissions() throws OwException
    {
        LOG.warn("OwCMISAbstractDomainFolder.getClonedPermissions: permissions of CMIS domain folder objects are not supported!");
        throw new OwNotSupportedException(OwString.localize(m_network.getLocale(), "ecmimpl.cmis.unsupported.object.operation", "Unsupported CMIS adapter object operation!"));
    }

    public boolean canGetPermissions() throws OwException
    {
        return false;
    }

    public boolean canSetPermissions() throws OwException
    {
        return false;
    }

    public void setPermissions(OwPermissionCollection permissions_p) throws OwException
    {
        LOG.error("OwCMISAbstractDomainFolder.setPermissions: permissions of CMIS domain folder objects are not supported!");
        throw new OwNotSupportedException(OwString.localize(m_network.getLocale(), "ecmimpl.cmis.unsupported.object.operation", "Unsupported CMIS adapter object operation!"));
    }

    public void refreshProperties() throws OwException
    {
    }

    public void refreshProperties(java.util.Collection props_p) throws OwException
    {
        refreshProperties();
    }

    public void setContentCollection(OwContentCollection content_p) throws OwException
    {

    }

    public OwContentCollection getContentCollection() throws OwException
    {
        LOG.error("OwCMISAbstractDomainFolder.getContentCollection: content of CMIS domain folder objects is not supported!");
        throw new OwNotSupportedException(OwString.localize(m_network.getLocale(), "ecmimpl.cmis.unsupported.object.operation", "Unsupported CMIS adapter object operation!"));
    }

    public Object getNativeObject() throws OwException
    {
        LOG.error("OwCMISAbstractDomainFolder.getNativeObject: native objects of CMIS domain folder objects are not supported!");
        throw new OwNotSupportedException(OwString.localize(m_network.getLocale(), "ecmimpl.cmis.unsupported.object.operation", "Unsupported CMIS adapter object operation!"));
    }

    public OwObjectCollection getParents() throws OwException
    {
        return null;
    }

    public Object getSafeFieldValue(String sName_p, Object defaultvalue_p)
    {
        try
        {
            return getProperty(sName_p).getValue();
        }
        catch (Exception e)
        {
            LOG.debug("OwCMISAbstractDomainFolder.getSafeFieldValue: could not retrieve property named = " + sName_p, e);
            return defaultvalue_p;
        }
    }

    /**
     * Get the current network.
     * @return OwCMISNetwork
     */
    protected OwCMISNetwork getNetwork()
    {
        return this.m_network;
    }

    public OwObject getInstance() throws OwException
    {
        return this;
    }

    public com.wewebu.ow.server.field.OwSearchTemplate getSearchTemplate() throws OwException
    {
        return null;
    }

    public OwVersionSeries getVersionSeries() throws OwException
    {
        return null;
    }

    public boolean hasVersionSeries() throws OwException
    {
        return false;
    }

    public OwVersion getVersion() throws OwException
    {
        return null;
    }

    public boolean hasContent(int iContext_p) throws OwException
    {
        return false;
    }

    public String getFieldProviderName()
    {
        return getName();
    }

    public void setField(String sName_p, Object value_p) throws OwException
    {
        throw new OwInvalidOperationException("cmis.OwCMISAbstractDomainFolder.setField: Invalid operation on virtual root.");
    }

    public void changeClass(String strNewClassName_p, OwPropertyCollection properties_p, OwPermissionCollection permissions_p) throws OwException
    {
        LOG.error("OwCMISAbstractDomainFolder.changeClass: class changing of CMIS domain folder objects is not supported!");
        throw new OwNotSupportedException(OwString.localize(getNetwork().getLocale(), "ecmimpl.cmis.unsupported.object.operation", "Unsupported CMIS adapter object operation!"));
    }

    public boolean canChangeClass() throws OwException
    {
        return false;
    }

    public boolean setLock(boolean fLock_p) throws OwException
    {
        return false;
    }

    public Object getFieldProviderSource()
    {
        return this;
    }

    public int getFieldProviderType()
    {
        return TYPE_META_OBJECT;
    }

    public void removeReference(OwObject oObject_p) throws OwException
    {

    }

    public int getType()
    {
        return OwObjectReference.OBJECT_TYPE_UNDEFINED;
    }

    public String getPath() throws Exception
    {
        LOG.error("OwCMISAbstractDomainFolder.getPath: path information of CMIS domain folder objects is not supported!");
        throw new OwNotSupportedException(OwString.localize(getNetwork().getLocale(), "ecmimpl.cmis.unsupported.object.operation", "Unsupported CMIS adapter object operation!"));
    }

    protected List<OwCMISRepositoryObject> createRepositoryFolders() throws OwException
    {
        List<OwCMISRepositoryObject> folders = new LinkedList<OwCMISRepositoryObject>();

        Iterator<String> it = getNetwork().getResourceIDs();

        while (it.hasNext())
        {
            OwCMISResource resource = getNetwork().getResource(it.next());

            folders.add(new OwCMISRepositoryObject(getNetwork(), resource));
        }

        return folders;

    }
}
