package com.wewebu.ow.server.ecmimpl.cmis;

import org.oasis_open.docs.ns.cmis.ws._200908.ACLServicePort;
import org.oasis_open.docs.ns.cmis.ws._200908.DiscoveryServicePort;
import org.oasis_open.docs.ns.cmis.ws._200908.MultiFilingServicePort;
import org.oasis_open.docs.ns.cmis.ws._200908.NavigationServicePort;
import org.oasis_open.docs.ns.cmis.ws._200908.ObjectServicePort;
import org.oasis_open.docs.ns.cmis.ws._200908.PolicyServicePort;
import org.oasis_open.docs.ns.cmis.ws._200908.RelationshipServicePort;
import org.oasis_open.docs.ns.cmis.ws._200908.RepositoryServicePort;
import org.oasis_open.docs.ns.cmis.ws._200908.VersioningServicePort;

import com.wewebu.ow.server.exceptions.OwException;

/**
 *<p>
 * OwCMISConnection.
 * Interface to retrieve the native service ports, based on the
 * generated sun-metro service interfaces.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 */
public interface OwCMISConnection
{
    RepositoryServicePort getRepositoryServicePort() throws OwException;

    NavigationServicePort getNavigationServicePort() throws OwException;

    ObjectServicePort getObjectServicePort() throws OwException;

    DiscoveryServicePort getDiscoveryServicePort() throws OwException;

    MultiFilingServicePort getMultiFilingServicePort() throws OwException;

    PolicyServicePort getPolicyServicePort() throws OwException;

    VersioningServicePort getVersionServicePort() throws OwException;

    RelationshipServicePort getRelationshipServicePort() throws OwException;

    /**
     * 
     * @return the current {@link ACLServicePort}
     * @throws OwException
     * @since 4.0.0.0
     */
    ACLServicePort getACLServicePort() throws OwException;

}
