package com.wewebu.ow.server.ecmimpl.cmis;

import java.util.Collection;

import org.apache.log4j.Logger;

import com.wewebu.ow.server.ecm.OwNetwork;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwObjectClass;
import com.wewebu.ow.server.ecm.OwObjectCollection;
import com.wewebu.ow.server.ecm.OwObjectReference;
import com.wewebu.ow.server.ecm.OwResource;
import com.wewebu.ow.server.ecm.OwStandardObjectClass;
import com.wewebu.ow.server.ecm.OwStandardObjectCollection;
import com.wewebu.ow.server.ecm.OwStatusContextException;
import com.wewebu.ow.server.ecmimpl.cmis.cross.OwCMISCrossInvocationHandler;
import com.wewebu.ow.server.ecmimpl.cmis.log.OwLog;
import com.wewebu.ow.server.field.OwSearchNode;
import com.wewebu.ow.server.field.OwSort;
import com.wewebu.ow.server.util.OwString;

/**
 *<p>
 * Root folder of standard CMIS repositories in a cross adapter scenario.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 *@since 3.1.0.0
 */
public class OwCMISCrossDomainFolder extends OwCMISAbstractDomainFolder
{
    /** package logger for the class */
    private static final Logger LOG = OwLog.getLogger(OwCMISCrossDomainFolder.class);

    private OwCMISCrossNetwork crossNetwork;

    public OwCMISCrossDomainFolder(OwCMISCrossNetwork crossNetwork_p)
    {
        super(crossNetwork_p.getInternalNetwork());
        this.crossNetwork = crossNetwork_p;
    }

    public int getChildCount(int[] objectTypes_p, int context_p) throws Exception
    {
        return 2;
    }

    public OwObjectCollection getChilds(int[] objectTypes_p, Collection propertyNames_p, OwSort sort_p, int maxSize_p, int versionSelection_p, OwSearchNode filterCriteria_p) throws Exception
    {
        for (int iType = 0; iType < objectTypes_p.length; iType++)
        {
            switch (objectTypes_p[iType])
            {
                case OwObjectReference.OBJECT_TYPE_ALL_CONTAINER_OBJECTS:
                case OwObjectReference.OBJECT_TYPE_FOLDER:
                {
                    OwStandardObjectCollection ret = new OwStandardObjectCollection();
                    ret.addAll(createRepositoryFolders());

                    OwNetwork externalNetwork = crossNetwork.getExternalNetwork();
                    OwObject externalDomainFolder = externalNetwork.getObjectFromPath("/", true);
                    String defaultExternalResourceID = externalNetwork.getResource(null).getID();
                    ret.add(OwCMISCrossInvocationHandler.createCrossNetworkObject(crossNetwork, crossNetwork.getXMapping(), externalDomainFolder, defaultExternalResourceID));

                    return ret;
                }
            }
        }
        LOG.info("OwCMISCrossDomainFolder.getChilds(...) returns null...");
        return null;
    }

    public String getClassName()
    {
        return "";
    }

    public OwObjectClass getObjectClass()
    {
        return new OwStandardObjectClass();
    }

    public OwResource getResource() throws Exception
    {
        return null;
    }

    public boolean hasChilds(int[] objectTypes_p, int context_p) throws Exception
    {
        //omits child count display through exception handling
        throw new OwStatusContextException("");
        //TODO: implement child count
    }

    public String getMIMEParameter() throws Exception
    {
        return "";
    }

    public String getMIMEType() throws Exception
    {
        return "ow_root/cmis_domain_cross";
    }

    public String getName()
    {
        OwCMISNetwork internalNetwork = crossNetwork.getInternalNetwork();
        return OwString.localize(internalNetwork.getLocale(), "cmis.OwCMISCrossDomainFolder.name", "CMIS Cross Network");
    }

    public int getPageCount() throws Exception
    {
        return 0;
    }

    public String getResourceID() throws Exception
    {
        return null;
    }

}
