package com.wewebu.ow.server.ecmimpl.cmis;

import com.wewebu.ow.server.ecmimpl.cmis.objectclasses.OwCMISObject;
import com.wewebu.ow.server.exceptions.OwException;

/**
 *<p>
 * OwCMISDMSID.
 * Interface for DMSID handling and object resolution.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 */
public interface OwCMISDMSID
{
    /**The char as String which should be used as separator in DMSID
     * @since 3.1.0.0*/
    public static final String DMSID_SEPARATOR = ",";
    /**The char which should be used as separator in DMSID
     * @since 3.1.0.0*/
    public static final char DMSID_SEPARATOR_CHAR = ',';

    /**
     * Return an OwCMISObject depending on the given DMSID information.
     * @param network_p OwCMISNetwork to use for retrieval
     * @return OwCMISObject
     * @throws OwException if any problems occur during retrieval
     */
    OwCMISObject getObject(OwCMISNetwork network_p) throws OwException;

    /**
     * Returning the specific DMSID
     * with all information to resolve the returned
     * String into an object back again.
     * @return String representing the DMSID of the object
     */
    String getDMSIDString();

    /**
     * Returning the native CMIS ID of the object.
     * @return String representing the native ID.
     */
    String getCMISID();

    /**
     * Returning the resource (repository) ID.
     * @return String representing resource ID.
     */
    String getResourceID();
}
