package com.wewebu.ow.server.ecmimpl.cmis;

import java.util.Iterator;

import org.apache.log4j.Logger;

import com.wewebu.ow.server.ecm.OwObjectClass;
import com.wewebu.ow.server.ecm.OwObjectCollection;
import com.wewebu.ow.server.ecm.OwObjectReference;
import com.wewebu.ow.server.ecm.OwResource;
import com.wewebu.ow.server.ecm.OwStandardObjectClass;
import com.wewebu.ow.server.ecm.OwStandardObjectCollection;
import com.wewebu.ow.server.ecm.OwStatusContextException;
import com.wewebu.ow.server.ecmimpl.cmis.log.OwLog;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.field.OwSearchNode;
import com.wewebu.ow.server.field.OwSort;
import com.wewebu.ow.server.util.OwString;

/**
 *<p>
 * Root folder of standard CMIS repositories.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 */
@SuppressWarnings("unchecked")
public class OwCMISDomainFolder extends OwCMISAbstractDomainFolder
{
    /** package logger for the class */
    private static final Logger LOG = OwLog.getLogger(OwCMISDomainFolder.class);

    /** constructs a CMIS domain root folder object wrapper
     *
     * @param network_p OwCMISNetwork reference
     */
    public OwCMISDomainFolder(OwCMISNetwork network_p) throws OwException
    {
        super(network_p);
    }

    public String getName()
    {
        return OwString.localize(getNetwork().getLocale(), "cmis.OwCMISDomainFolder.name", "CMIS Network");
    }

    public int getPageCount()
    {
        return 1;
    }

    public String getMIMEType()
    {
        return "ow_root/cmis_domain";
    }

    public OwObjectCollection getChilds(int[] iObjectTypes_p, java.util.Collection propertyNames_p, OwSort sort_p, int iMaxSize_p, int iVersionSelection_p, OwSearchNode filterCriteria_p) throws OwException
    {
        for (int iType = 0; iType < iObjectTypes_p.length; iType++)
        {
            switch (iObjectTypes_p[iType])
            {
                case OwObjectReference.OBJECT_TYPE_ALL_CONTAINER_OBJECTS:
                case OwObjectReference.OBJECT_TYPE_FOLDER:
                {
                    OwStandardObjectCollection ret = new OwStandardObjectCollection();
                    ret.addAll(createRepositoryFolders());
                    return ret;
                }
            }
        }
        LOG.info("OwCMISDomainFolder.getChilds(...) returns null...");
        return null;
    }

    public String getMIMEParameter() throws OwException
    {
        return "";
    }

    public OwObjectClass getObjectClass()
    {
        return new OwStandardObjectClass();
    }

    public String getClassName()
    {
        return "";
    }

    public OwResource getResource() throws OwException
    {
        return null;
    }

    public boolean hasChilds(int[] iObjectTypes_p, int iContext_p) throws OwException
    {
        OwCMISNetwork network = getNetwork();
        Iterator<String> ids = network.getResourceIDs();

        return ids.hasNext();
    }

    public int getChildCount(int[] iObjectTypes_p, int iContext_p) throws OwException
    {
        //omits child count display through exception handling
        throw new OwStatusContextException("");
        //TODO: implement child count
    }

    public String getResourceID() throws OwException
    {
        return null;
    }

}