package com.wewebu.ow.server.ecmimpl.cmis;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

import com.wewebu.ow.server.ecmimpl.cmis.extension.OwCMISExtensionLibrary;

/**
 *<p>
 * Extension points are extension call handling utilities used to provide default 
 * return values and other extensions call time behavior as {@link Proxy} handlers.
 * <br/>
 * Extensions are aspect-oriented like , id based cross-cutting concerns.<br/>
 * Extensions are provided by extension libraries - {@link OwCMISExtensionLibrary} - and implemented as 
 * interface methods. Extensions are uniquely determined by implementing interface type and extension id.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 *@since 3.1.0.0
 */
class OwCMISExtensionPoint implements InvocationHandler
{
    private String id;
    private Object extension;
    private Class<?> extensionInterface;

    private Object nullExtensionResult;

    /**
     * 
     * @param id_p  extension id
     * @param extensionInterface_p extension implementing interface
     * @param extension_p the extension interface implementor
     * @param nullExtensionResult_p default return value 
     */
    public OwCMISExtensionPoint(String id_p, Class<?> extensionInterface_p, Object extension_p, Object nullExtensionResult_p)
    {
        super();
        this.id = id_p;
        this.extension = extension_p;
        this.extensionInterface = extensionInterface_p;
        this.nullExtensionResult = nullExtensionResult_p;
    }

    public Object invoke(Object proxy_p, Method method_p, Object[] args_p) throws Throwable
    {
        if (this.extension == null)
        {
            Class<?> returnType = method_p.getReturnType();
            if (this.nullExtensionResult != null)
            {
                if (!returnType.isAssignableFrom(this.nullExtensionResult.getClass()))
                {
                    throw new ClassCastException("Invalid default return type " + this.nullExtensionResult.getClass());
                }
            }
            return this.nullExtensionResult;
        }
        else
        {
            return method_p.invoke(this.extension, args_p);
        }
    }

    /**
     * Get the class from which type the interface should be.
     * @return Class representing the extension interface
     */
    public Class<?> getExtensionInterface()
    {
        return this.extensionInterface;
    }

    /**
     * Get the ID of this extension.
     * @return String representing the ID
     */
    public String getExtensionID()
    {
        return this.id;
    }
}
