package com.wewebu.ow.server.ecmimpl.cmis;

import com.wewebu.ow.server.ecmimpl.cmis.wshandler.OwCMISSecurityHandlerInterface;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.mandator.OwMandator;
import com.wewebu.ow.server.util.OwXMLUtil;
import com.wewebu.ow.server.util.ldap.OwLdapConnector;

/**
 *<p>
 * LDAP Credentials implementation. Containing all 
 * references to the CMIS services, which are also initialized
 * in this class. Extra LDAP user information is provided through 
 * factored {@link OwCMISLDAPUserInfo}.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 */
public class OwCMISLDAPCredentials extends OwCMISCredentials
{

    private OwLdapConnector ldapConnector;

    /**
     * Constructor
     * @param ldapConnector_p
     * @param username_p
     * @param password_p
     * @param securityhandler_p OwCMISSecurityHandler
     * @param mandator_p current {@link OwMandator} , <code>null</code> for no mandator  
     * @throws OwException
     */
    public OwCMISLDAPCredentials(OwXMLUtil configuration_p, OwLdapConnector ldapConnector_p, String username_p, String password_p, OwCMISSecurityHandlerInterface securityhandler_p, OwMandator mandator_p) throws OwException
    {
        super(configuration_p, username_p, password_p, securityhandler_p, mandator_p);
        this.ldapConnector = ldapConnector_p;
    }

    @Override
    protected OwCMISUserInfo createUserInfo(String userName_p)
    {
        return new OwCMISLDAPUserInfo(userName_p, getMandator(), this.ldapConnector);
    }

    /**
     * Return the currently LDAP connector which was used by this credentials instance.
     * @return OwLdapConnector
     * @see OwLdapConnector
     * @since 3.1.0.0
     */
    public OwLdapConnector getLdapConnector()
    {
        return this.ldapConnector;
    }

}
