package com.wewebu.ow.server.ecmimpl.cmis;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

import javax.xml.ws.WebServiceException;
import javax.xml.ws.soap.SOAPFaultException;

import org.apache.log4j.Logger;
import org.oasis_open.docs.ns.cmis.core._200908.CmisObjectType;
import org.oasis_open.docs.ns.cmis.core._200908.CmisRepositoryCapabilitiesType;
import org.oasis_open.docs.ns.cmis.core._200908.CmisRepositoryInfoType;
import org.oasis_open.docs.ns.cmis.core._200908.EnumCapabilityACL;
import org.oasis_open.docs.ns.cmis.core._200908.EnumIncludeRelationships;
import org.oasis_open.docs.ns.cmis.messaging._200908.CmisObjectListType;
import org.oasis_open.docs.ns.cmis.messaging._200908.CmisRepositoryEntryType;
import org.oasis_open.docs.ns.cmis.ws._200908.ACLServicePort;
import org.oasis_open.docs.ns.cmis.ws._200908.CmisException;
import org.oasis_open.docs.ns.cmis.ws._200908.DiscoveryServicePort;
import org.oasis_open.docs.ns.cmis.ws._200908.MultiFilingServicePort;
import org.oasis_open.docs.ns.cmis.ws._200908.NavigationServicePort;
import org.oasis_open.docs.ns.cmis.ws._200908.ObjectServicePort;
import org.oasis_open.docs.ns.cmis.ws._200908.PolicyServicePort;
import org.oasis_open.docs.ns.cmis.ws._200908.RelationshipServicePort;
import org.oasis_open.docs.ns.cmis.ws._200908.RepositoryServicePort;
import org.oasis_open.docs.ns.cmis.ws._200908.VersioningServicePort;
import org.perf4j.StopWatch;
import org.perf4j.log4j.Log4JStopWatch;
import org.w3c.dom.Node;

import com.wewebu.ow.csqlc.OwSQLEntitiesResolver;
import com.wewebu.ow.csqlc.ast.OwExternal;
import com.wewebu.ow.csqlc.ast.OwQueryStatement;
import com.wewebu.ow.server.ao.OwAOManager;
import com.wewebu.ow.server.ao.OwAOManagerRegistry;
import com.wewebu.ow.server.ao.OwAOSupport;
import com.wewebu.ow.server.ao.OwAttributeBagsManager;
import com.wewebu.ow.server.ao.OwDBAttributeBagsSupport;
import com.wewebu.ow.server.ao.OwDefaultAOManager;
import com.wewebu.ow.server.ao.OwDefaultRegistry;
import com.wewebu.ow.server.ao.OwFileAOSupport;
import com.wewebu.ow.server.ao.OwSearchTemplateFactory;
import com.wewebu.ow.server.ao.OwSearchTemplatesManager;
import com.wewebu.ow.server.ao.OwVirtualFolderFactory;
import com.wewebu.ow.server.ao.OwVirtualFoldersManager;
import com.wewebu.ow.server.ao.OwXMLAOManager;
import com.wewebu.ow.server.auth.OwAuthentication;
import com.wewebu.ow.server.auth.OwAuthenticationContext;
import com.wewebu.ow.server.auth.OwCredentialsAuthentication;
import com.wewebu.ow.server.auth.OwLocalAuthenticationContext;
import com.wewebu.ow.server.dmsdialogs.views.OwUIGenericAccessRightsModul;
import com.wewebu.ow.server.ecm.OwAttributeBagsSupport;
import com.wewebu.ow.server.ecm.OwBatch;
import com.wewebu.ow.server.ecm.OwContentCollection;
import com.wewebu.ow.server.ecm.OwManagedSemiVirtualRecordConfiguration;
import com.wewebu.ow.server.ecm.OwNetwork;
import com.wewebu.ow.server.ecm.OwNetworkContext;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwObjectClass;
import com.wewebu.ow.server.ecm.OwObjectCollection;
import com.wewebu.ow.server.ecm.OwObjectReference;
import com.wewebu.ow.server.ecm.OwObjectSkeleton;
import com.wewebu.ow.server.ecm.OwPermissionCollection;
import com.wewebu.ow.server.ecm.OwPropertyCollection;
import com.wewebu.ow.server.ecm.OwResource;
import com.wewebu.ow.server.ecm.OwSearchPath;
import com.wewebu.ow.server.ecm.OwSearchPathField;
import com.wewebu.ow.server.ecm.OwSemiVirtualFolderAdapter;
import com.wewebu.ow.server.ecm.OwSemiVirtualRecordClass;
import com.wewebu.ow.server.ecm.OwStandardObjectCollection;
import com.wewebu.ow.server.ecm.OwStandardPropertyCollection;
import com.wewebu.ow.server.ecm.OwStandardSearchSpecialNodeOperator;
import com.wewebu.ow.server.ecm.OwStandardSearchTemplate;
import com.wewebu.ow.server.ecm.OwTransientBagsSupport;
import com.wewebu.ow.server.ecm.OwUserInfo;
import com.wewebu.ow.server.ecm.bpm.OwWorkitemRepository;
import com.wewebu.ow.server.ecm.eaop.OwBooleanCollector;
import com.wewebu.ow.server.ecm.eaop.OwJoinPoint;
import com.wewebu.ow.server.ecm.eaop.OwNativeSearchAdvice;
import com.wewebu.ow.server.ecm.ui.OwUIAccessRightsModul;
import com.wewebu.ow.server.ecm.ui.OwUILoginModul;
import com.wewebu.ow.server.ecm.ui.OwUIUserSelectModul;
import com.wewebu.ow.server.ecmimpl.cmis.auth.OwCMISCredentialsAuthenticator;
import com.wewebu.ow.server.ecmimpl.cmis.broker.OwCMISObjectBroker;
import com.wewebu.ow.server.ecmimpl.cmis.extension.OwCMISNetworkExtension;
import com.wewebu.ow.server.ecmimpl.cmis.log.OwLog;
import com.wewebu.ow.server.ecmimpl.cmis.object.OwCMISDocumentObject;
import com.wewebu.ow.server.ecmimpl.cmis.object.OwCMISObjectSkeleton;
import com.wewebu.ow.server.ecmimpl.cmis.objectclasses.OwCMISObject;
import com.wewebu.ow.server.ecmimpl.cmis.objectclasses.OwCMISObjectClass;
import com.wewebu.ow.server.ecmimpl.cmis.objectclasses.OwCMISObjectClassFactory;
import com.wewebu.ow.server.ecmimpl.cmis.objectclasses.OwCMISStandardObjectClassFactory;
import com.wewebu.ow.server.ecmimpl.cmis.property.OwCMISPropertyNames;
import com.wewebu.ow.server.ecmimpl.cmis.property.OwCMISStandardPropertyClassFactory;
import com.wewebu.ow.server.ecmimpl.cmis.propertyclasses.OwCMISPropertyClass;
import com.wewebu.ow.server.ecmimpl.cmis.propertyclasses.OwCMISPropertyClassFactory;
import com.wewebu.ow.server.ecmimpl.cmis.search.OwCMISCSQLCProcessor;
import com.wewebu.ow.server.ecmimpl.cmis.search.OwCMISLikeWildcardDefinitions;
import com.wewebu.ow.server.ecmimpl.cmis.ui.OwCMISAccessRightsModule;
import com.wewebu.ow.server.ecmimpl.cmis.ui.OwCMISLoginSubModul;
import com.wewebu.ow.server.ecmimpl.cmis.ui.OwCMISUIUserSelectionModul;
import com.wewebu.ow.server.ecmimpl.cmis.util.OwCMISPropertiesFilter;
import com.wewebu.ow.server.ecmimpl.cmis.viewer.info.OwCMISInfoProvider;
import com.wewebu.ow.server.ecmimpl.cmis.wshandler.OwCMISSecurityHandlerInterface;
import com.wewebu.ow.server.event.OwEventManager;
import com.wewebu.ow.server.exceptions.OwAuthenticationException;
import com.wewebu.ow.server.exceptions.OwConfigurationException;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.exceptions.OwNotSupportedException;
import com.wewebu.ow.server.exceptions.OwObjectNotFoundException;
import com.wewebu.ow.server.exceptions.OwServerException;
import com.wewebu.ow.server.field.OwFieldDefinition;
import com.wewebu.ow.server.field.OwSearchCriteria;
import com.wewebu.ow.server.field.OwSearchNode;
import com.wewebu.ow.server.field.OwSearchOperator;
import com.wewebu.ow.server.field.OwSearchTemplate;
import com.wewebu.ow.server.field.OwSort;
import com.wewebu.ow.server.field.OwWildCardDefinition;
import com.wewebu.ow.server.mandator.OwMandator;
import com.wewebu.ow.server.role.OwRoleManager;
import com.wewebu.ow.server.ui.viewer.OwInfoProvider;
import com.wewebu.ow.server.util.OwString;
import com.wewebu.ow.server.util.OwXMLDOMUtil;
import com.wewebu.ow.server.util.OwXMLUtil;
import com.wewebu.ow.server.util.ldap.OwLdapConnector;

/**
 *<p>
 * The implementation of the <code>{@link OwNetwork}</code> interface 
 * for the CMIS (Content Management Interoperability Services) adaptor. 
 * <br/><br/>
 * <B>Sun Metro WebService Stack for CMIS (cmis.OwCMISNetwork) is deprecated
 * please use the Apache Chemistry OpenCMIS (opencmis.OwCMISNetwork) adaptor instead.</B>
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 *@deprecated since 4.1.1.0, please use the Apache Chemistry OpenCMIS (opencmis.OwCMISNetwork) adaptor instead.
 */
public class OwCMISNetwork implements OwNetwork, OwCMISConnection, OwSearchTemplateFactory, OwVirtualFolderFactory, OwCMISLoginInfoNetwork
{
    private static final Logger LOG = OwLog.getLogger(OwCMISNetwork.class);

    /*-------------- bootstrap configuration nodes -------------------------*/
    /**Configuration node name for RepositoryService URL
     * @deprecated since 4.0.0.0 use {@link OwCMISCredentials#CONF_NODE_WSDL_REPOSITORY}*/
    public static final String CONF_NODE_WSDL_REPOSITORY = "WSDLRepository";
    /**Configuration node name for NavigationService URL
     * @deprecated since 4.0.0.0 use {@link OwCMISCredentials#CONF_NODE_WSDL_NAVIGATION}*/
    public static final String CONF_NODE_WSDL_NAVIGATION = "WSDLNavigation";
    /**Configuration node name for ObjectService URL
     * @deprecated since 4.0.0.0 use {@link OwCMISCredentials#CONF_NODE_WSDL_OBJECT}*/
    public static final String CONF_NODE_WSDL_OBJECT = "WSDLObject";
    /**Configuration node name for MultifilingService URL
     * @deprecated since 4.0.0.0 use {@link OwCMISCredentials#CONF_NODE_WSDL_MULTIFILING}*/
    public static final String CONF_NODE_WSDL_MULTIFILING = "WSDLMultifiling";
    /**Configuration node name for DiscoveryService (search service) URL
     * @deprecated since 4.0.0.0 use {@link OwCMISCredentials#CONF_NODE_WSDL_DISCOVERY}*/
    public static final String CONF_NODE_WSDL_DISCOVERY = "WSDLDiscovery";
    /**Configuration node name for VersioningService URL
     * @deprecated since 4.0.0.0 use {@link OwCMISCredentials#CONF_NODE_WSDL_VERSIONING}*/
    public static final String CONF_NODE_WSDL_VERSIONING = "WSDLVersioning";
    /**Configuration node name for RelationshipService URL
     * @deprecated since 4.0.0.0 use {@link OwCMISCredentials#CONF_NODE_WSDL_RELATIONSHIP}*/
    public static final String CONF_NODE_WSDL_RELATIONSHIP = "WSDLRelationship";
    /**Configuration node name for PolicyService URL
     * @deprecated since 4.0.0.0 use {@link OwCMISCredentials#CONF_NODE_WSDL_POLICY}*/
    public static final String CONF_NODE_WSDL_POLICY = "WSDLPolicy";
    /**Configuration node name for ACL-Service URL
     * @deprecated since 4.0.0.0 use {@link OwCMISCredentials#CONF_NODE_WSDL_ACL}*/
    public static final String CONF_NODE_WSDL_ACL = "WSDLACL";

    /**optional configuration node name containing the full qualified java class name*/
    public static final String CONF_NODE_SECURITY_HANDLER = "SecurityHandler";
    /**optional configuration node name containing the full qualified java class name
     * @since 3.2.0.0*/
    public static final String CONF_NODE_CSQLCPROCESSOR = "CSQLCProcessorClass";

    private OwCMISPropertyClassFactory m_propFactory;

    private OwNetworkContext m_context;

    /**Configuration helper, containing configuration node and other helper methods
     * @since 3.2.0.0*/
    private OwCMISNetworkConfiguration m_networkConfigurtaion;

    private OwEventManager m_eventmanager;

    private OwRoleManager m_rolemanager;

    private OwCMISResource m_defaultresource;

    private List<String> m_repositoryIDs;
    /**map of resource ID with depending resource*/
    private HashMap<String, OwCMISResource> m_resourcesIDs;
    /** map of resource name with depending resource*/
    private HashMap<String, OwCMISResource> m_resourcesNames;
    /**Domain root folder of CMIS*/
    private OwCMISDomainFolder m_domainroot;

    private OwCMISLikeWildcardDefinitions wildcardsDef;

    private OwCMISObjectClassFactory m_objectClassFactory;

    private OwManagedSemiVirtualRecordConfiguration managedVirtualConfiguration;

    private OwAOManagerRegistry m_aoManagerRegistry;

    private OwCMISObjectBroker m_objectBroker = new OwCMISObjectBroker();

    private OwCMISExternalEntitiesResolver externalEntitiesResolver;

    private OwWorkitemRepository m_WorkitemRepository;

    private OwAuthenticationContext localAuthenticationContext = new OwLocalAuthenticationContext();

    private OwVirtualFolderFactory virtualFolderFactory;

    public OwCMISNetwork()
    {
        this(null, null);
    }

    public OwCMISNetwork(OwCMISExternalEntitiesResolver externalEntitiesResolver_p)
    {
        this(externalEntitiesResolver_p, null);
    }

    public OwCMISNetwork(OwCMISExternalEntitiesResolver externalEntitiesResolver_p, OwVirtualFolderFactory virtualFolderFactory_p)
    {
        super();
        this.externalEntitiesResolver = externalEntitiesResolver_p;
        this.virtualFolderFactory = virtualFolderFactory_p;
    }

    public OwCMISObjectBroker getObjectBroker()
    {
        return m_objectBroker;
    }

    public boolean canCreateNewObject(OwResource resource_p, OwObject parent_p, int context_p) throws OwException
    {
        //if resource_p == null, default resource will be used
        if (parent_p != null)
        {
            return parent_p.getType() == OwObjectReference.OBJECT_TYPE_FOLDER || parent_p.getType() == OwObjectReference.OBJECT_TYPE_VIRTUAL_FOLDER || parent_p.getType() == OwObjectReference.OBJECT_TYPE_DYNAMIC_VIRTUAL_FOLDER
                    || parent_p.getType() == OwObjectReference.OBJECT_TYPE_ECM_ROOT_FOLDER;
        }
        else
        {
            //Unfilled handling will be done by createNewObject(...)
            return Boolean.TRUE.booleanValue();
        }
    }

    public boolean canCreateObjectCopy(OwObject parent_p, int[] childTypes_p, int context_p) throws OwException
    {
        return parent_p instanceof OwCMISObject;
    }

    public boolean canDo(OwObject obj_p, int functionCode_p, int context_p) throws OwException
    {
        switch (functionCode_p)
        {
            case OwNetwork.CAN_DO_FUNCTIONCODE_CREATE_ANNOTATION:
            case OwNetwork.CAN_DO_FUNCTIONCODE_EDIT_ANNOTATION:
            case OwNetwork.CAN_DO_FUNCTIONCODE_DELETE_ANNOTATION:
                return false;

            case OwNetwork.CAN_DO_FUNCTIONCODE_PRINT:
                return false;
            case OwNetwork.CAN_DO_FUNCTIONCODE_SAVE_CONTENT_TO_DISK:
                return false;

            default:
                return false;
        }
    }

    public boolean canEditAccessRights(OwObject object_p) throws OwException
    {
        OwCMISResource resource = null;
        try
        {
            resource = this.m_resourcesIDs.get(object_p.getResourceID());
        }
        catch (OwException e)
        {
            throw e;
        }
        catch (Exception ex)
        {
            LOG.error("OwCMISNetwork.canEditAccessRights():Error while checking access rights enablement!Problem retrieving resource ID from object", ex);
            throw new OwServerException(new OwString("ecmimpl.cmis.OwCMISNetwork.access.rights.error", "Access rights error!"), ex);
        }

        EnumCapabilityACL acl = resource.getCMISCapabilities().getCapabilityACL();

        if (acl != null)
        {
            try
            {
                return acl == EnumCapabilityACL.MANAGE && getCredentials().getACLServicePort() != null;
            }
            catch (Exception e)
            {
                if (LOG.isDebugEnabled())
                {
                    LOG.debug("WARNING: Verify that ACL WSDL is configured!", e);
                }
                else
                {
                    LOG.warn("OwCMISNetwork.canEditAccessRights(): Verify that ACL WSDL is configured.");
                }
                return false;
            }
        }
        else
        {
            return false;
        }
    }

    public String createNewObject(OwResource resource_p, String strObjectClassName_p, OwPropertyCollection properties_p, OwPermissionCollection permissions_p, OwContentCollection content_p, OwObject parent_p, String strMimeType_p,
            String strMimeParameter_p) throws OwException
    {
        return createNewObject(true, null, resource_p, strObjectClassName_p, properties_p, permissions_p, content_p, parent_p, strMimeType_p, strMimeParameter_p, false);
    }

    public String createNewObject(boolean promote_p, Object mode_p, OwResource resource_p, String strObjectClassName_p, OwPropertyCollection properties_p, OwPermissionCollection permissions_p, OwContentCollection content_p, OwObject parent_p,
            String strMimeType_p, String strMimeParameter_p) throws OwException
    {
        return createNewObject(promote_p, mode_p, resource_p, strObjectClassName_p, properties_p, permissions_p, content_p, parent_p, strMimeType_p, strMimeParameter_p, Boolean.FALSE.booleanValue());
    }

    public String createNewObject(boolean promote_p, Object mode_p, OwResource resource_p, String strObjectClassName_p, OwPropertyCollection properties_p, OwPermissionCollection permissions_p, OwContentCollection content_p, OwObject parent_p,
            String strMimeType_p, String strMimeParameter_p, boolean keepCheckedOut_p) throws OwException
    {
        OwCMISResource res = null;
        OwObject parent;
        try
        {
            parent = prepareParentObject(parent_p, resource_p, strObjectClassName_p, properties_p);

            if (parent != null)
            {
                res = (OwCMISResource) parent.getResource();
            }
            else
            {
                if (res == null)
                {
                    res = resource_p == null ? getDefaultResource() : getResource(resource_p.getID());
                }
                //check (un-)file capabilities of current repository
                if (!res.getRepositoryInfo().getCapabilities().isCapabilityUnfiling())
                {//add to repository/object store root folder
                    parent = getObjectFromPath(OwSearchPath.PATH_DELIMITER + res.getID() + OwSearchPath.PATH_DELIMITER, Boolean.FALSE.booleanValue());
                }
            }
        }
        catch (OwException owEx)
        {
            throw owEx;
        }
        catch (Exception ex)
        {
            LOG.error("OwCMISNetwork.createNewObject():Problem retrieving resource while creating object!", ex);
            throw new OwServerException(new OwString("ecmimpl.cmis.OwCMISNetwork.create.object.error", "An error occurred while creating object!"), ex);
        }

        //request the object type for creation
        OwCMISObjectClass clazz = getObjectClass(strObjectClassName_p, res);
        OwCMISNetworkExtension ext = res.getExtension(OwCMISNetworkExtension.PREPARE_FOR_CREATION_EP, OwCMISNetworkExtension.class, clazz);
        clazz = ext.prepareForCreation(clazz, this);
        return clazz.createNewObject(this, promote_p, mode_p, res, properties_p, permissions_p, content_p, parent, strMimeType_p, strMimeParameter_p, keepCheckedOut_p);

    }

    /**
     * Prepare parent object to resolve to specific object if current object represents something non-ECM based.
     * @param parent_p OwObject current object to be created (can be null)
     * @param resource_p OwResource provided resource (can be null, use default)
     * @param objectClass_p String object class name of the element
     * @param properties_p OwPropertCollection collection of properties for the new object
     * @return OwObject specific ECM object or null
     * @throws OwException
     * @since 4.0.0.0
     */
    protected OwObject prepareParentObject(OwObject parent_p, OwResource resource_p, String objectClass_p, OwPropertyCollection properties_p) throws OwException
    {
        OwObject parent = null;

        if (parent_p != null && parent_p.getType() == OwObjectReference.OBJECT_TYPE_VIRTUAL_FOLDER)
        {
            OwSearchNode specialNode = null;
            try
            {
                specialNode = parent_p.getSearchTemplate().getSearch(false).findSearchNode(OwSearchNode.NODE_TYPE_SPECIAL);
            }
            catch (OwException ex)
            {
                throw ex;
            }
            catch (Exception e)
            {
                LOG.error("Could not get/find special node for path identification", e);
                throw new OwServerException(new OwString("ecmimpl.cmis.OwCMISNetwork.prepareParent.error", "Could not get/find special node for path identification."), e);
            }

            if (specialNode != null)
            {
                Iterator<?> it = specialNode.getChilds().iterator();
                OwSearchNode vfolderPathNode = null;
                while (it.hasNext())
                {
                    OwSearchNode specialChild = (OwSearchNode) it.next();
                    OwSearchCriteria specialCriteria = specialChild.getCriteria();
                    String criteriaUName = specialCriteria.getUniqueName();
                    String criteriaClassName = specialCriteria.getClassName();
                    if (OwSemiVirtualFolderAdapter.VIRTUAL_FOLDER_SEARCH_PATH_PROPERTY.equals(criteriaUName) && OwSearchPathField.CLASS_NAME.equals(criteriaClassName))
                    {
                        vfolderPathNode = specialChild;
                        break;
                    }
                }
                if (vfolderPathNode != null)
                {
                    OwSearchCriteria virtualFolderPathCriteria = vfolderPathNode.getCriteria();
                    OwSearchPath virtualFolderPath = (OwSearchPath) virtualFolderPathCriteria.getValue();

                    String path = virtualFolderPath.getPathName();
                    parent = getObjectFromPath(path, true);
                }
            }
        }
        else
        {
            if (parent_p != null)
            {
                parent = parent_p;
            }
        }

        return parent;
    }

    public String createObjectCopy(OwObject obj_p, OwPropertyCollection properties_p, OwPermissionCollection permissions_p, OwObject parent_p, int[] childTypes_p) throws OwException
    {
        boolean sameRepository = false;
        try
        {
            String objectResourceId = obj_p.getResourceID();
            String parendResourceId = parent_p.getResourceID();
            sameRepository = objectResourceId.equals(parendResourceId);
        }
        catch (Exception e)
        {
            throw new OwInvalidOperationException(getContext().localize("ecmimpl.cmis.OwCMISNetwork.copy.error", "Could not copy object !"), e);
        }

        if (sameRepository && obj_p instanceof OwCMISObject && parent_p instanceof OwCMISObject)
        {
            OwCMISObject cmisObject = (OwCMISObject) obj_p;
            OwCMISObject cmisParent = (OwCMISObject) parent_p;
            OwCMISObject copy = cmisObject.createCopy(cmisParent, properties_p, permissions_p, childTypes_p);
            try
            {
                return copy.getDMSID();
            }
            catch (Exception e)
            {
                LOG.error("OwCMISNetwork.createObjectCopy():Could not retrieve object copy DMSID!", e);
                throw new OwInvalidOperationException(getContext().localize("ecmimpl.cmis.OwCMISNetwork.copy.error", "Could not copy object !"), e);
            }
        }
        else if (parent_p instanceof OwCMISObject)
        {
            try
            {
                String className = obj_p.getClassName();
                OwPropertyCollection copiedPorperties = obj_p.getProperties(null);
                OwPropertyCollection properties = new OwStandardPropertyCollection();

                properties.putAll(copiedPorperties);

                if (properties_p != null)
                {
                    properties.putAll(properties_p);
                }

                return createNewObject(true, null, parent_p.getResource(), className, properties, permissions_p, obj_p.getContentCollection(), parent_p, obj_p.getMIMEType(), obj_p.getMIMEParameter());
            }
            catch (Exception e)
            {
                LOG.error("Could not perform non-CMIS object copy!", e);
                throw new OwInvalidOperationException(getContext().localize("ecmimpl.cmis.OwCMISNetwork.copy.error", "Could not copy object !"), e);
            }
        }
        else
        {
            LOG.error("OwCMISNetwork.createObjectCopy(): paset can be performed only when the destination is a CMIS object!");
            throw new OwInvalidOperationException(getContext().localize("ecmimpl.cmis.OwCMISNetwork.copy.error", "Could not copy object !"));
        }

    }

    public OwObjectSkeleton createObjectSkeleton(OwObjectClass objectClass_p, OwResource resource_p) throws OwException
    {
        try
        {
            OwCMISResource res = resource_p == null ? getDefaultResource() : getResource(resource_p.getID());
            OwCMISNetworkExtension ext = res.getExtension(OwCMISNetworkExtension.PREPARE_FOR_CREATION_EP, OwCMISNetworkExtension.class, objectClass_p);
            OwCMISObjectClass clazz = ext.prepareForCreation((OwCMISObjectClass) objectClass_p, this);

            OwXMLUtil initValues = getNetworkConfiguration().getCreationInitialValuesConfig(clazz.getClassName());
            OwCMISObjectSkeleton skeleton = null;
            if (initValues == null)
            {
                skeleton = new OwCMISObjectSkeleton(this, clazz);
            }
            else
            {
                skeleton = new OwCMISObjectSkeleton(this, clazz, initValues);
            }
            skeleton.setField(objectClass_p.getPropertyClass(OwCMISPropertyNames.OBJECT_TYPE_ID.getId()).getClassName(), objectClass_p.getClassName());

            return skeleton;
        }
        catch (OwException e)
        {
            throw e;
        }
        catch (Exception ex)
        {
            LOG.error("OwCMISNetwork.createObjectSkeleton():Problem instantiation of Skeleton object!", ex);
            throw new OwServerException(getContext().localize("ecmimpl.cmis.OwCMISNetwork.skeleton.object.error", "An error occurred while creating object!"), ex);
        }
    }

    public Object getApplicationObject(int type_p, String strName_p, Object param_p, boolean forceUserSpecificObject_p, boolean createIfNotExist_p) throws OwException
    {
        OwAOManager typedManager = getAOManagerForType(type_p);
        Object appObject = typedManager.getApplicationObject(strName_p, param_p, forceUserSpecificObject_p, createIfNotExist_p);
        return appObject;
    }

    public Object getApplicationObject(int type_p, String strName_p, boolean forceUserSpecificObject_p, boolean createIfNotExist_p) throws OwException
    {
        OwAOManager typedManager = getAOManagerForType(type_p);
        Object appObject = typedManager.getApplicationObject(strName_p, forceUserSpecificObject_p, createIfNotExist_p);
        return appObject;
    }

    public Collection<?> getApplicationObjects(int type_p, String strName_p, boolean forceUserSpecificObject_p) throws OwException
    {
        OwAOManager typedManager = getAOManagerForType(type_p);
        Collection<?> appObjects = typedManager.getApplicationObjects(strName_p, forceUserSpecificObject_p);
        return appObjects;
    }

    protected synchronized OwAOManager getAOManagerForType(int type_p) throws OwException
    {
        if (m_aoManagerRegistry == null)
        {
            m_aoManagerRegistry = createAOManagerRegistry();
        }

        OwAOManager typedManager = m_aoManagerRegistry.getManager(type_p);
        return typedManager;
    }

    protected OwAOManagerRegistry createAOManagerRegistry() throws OwException
    {
        OwCMISNetworkConfiguration configuration = getNetworkConfiguration();
        OwAOSupport fileAOSupport = new OwFileAOSupport(this, configuration, "WEB-INF/cmis");
        //preferences configuration
        final String defaultPreferencesFolder = "owpreferences";
        String preferencesFolder = configuration.getConfigNode().getSafeTextValue("UserDefinedPreferencesFolder", defaultPreferencesFolder);

        OwDefaultRegistry stdRegistry = new OwDefaultRegistry();
        OwAttributeBagsSupport bagsSupport = null;
        try
        {
            bagsSupport = OwDBAttributeBagsSupport.createAndCheckDBSupport(this.getContext());
        }
        catch (OwNotSupportedException e)
        {
            LOG.warn("OwCMISNetwork.createAOManagerRegistry: DB bags are not supported - transient attribute bags will be used!");
            bagsSupport = new OwTransientBagsSupport();
        }
        stdRegistry.registerManager(new OwAttributeBagsManager(this.getContext(), OwNetwork.APPLICATION_OBJECT_TYPE_ATTRIBUTE_BAG_WRITABLE, false, bagsSupport));
        stdRegistry.registerManager(new OwAttributeBagsManager(this.getContext(), OwNetwork.APPLICATION_OBJECT_TYPE_INVERTED_ATTRIBUTE_BAG, true, bagsSupport));
        stdRegistry.registerManager(new OwSearchTemplatesManager(fileAOSupport, "", this, "owsearchtemplates", ""));
        stdRegistry.registerManager(new OwVirtualFoldersManager(fileAOSupport, virtualFolderFactory, m_rolemanager, configuration.getVirtualFoldersContainer(null)));
        stdRegistry.registerManager(new OwDefaultAOManager(OwNetwork.APPLICATION_OBJECT_TYPE_PREFERENCES, fileAOSupport, preferencesFolder));
        stdRegistry.registerManager(new OwXMLAOManager(fileAOSupport));
        return stdRegistry;
    }

    public OwUIAccessRightsModul getEditAccessRightsSubModul(OwObject object_p) throws OwException
    {
        if (canEditAccessRights(object_p))
        {
            Map<String, String> privilegeDisplayNames = new HashMap<String, String>();
            OwCMISAccessRightsModule accessRightsModul = new OwCMISAccessRightsModule(this, object_p, null, null, privilegeDisplayNames, OwUIGenericAccessRightsModul.PRIVILEGES_ONLY);
            return accessRightsModul;
        }
        else
        {
            return null;
        }
    }

    @SuppressWarnings("rawtypes")
    public Object getInterface(String strInterfaceName_p, Object object_p) throws OwException
    {
        try
        {
            Class interfaceClass = Class.forName(strInterfaceName_p);
            if (OwWorkitemRepository.class == interfaceClass)
            {
                if (null == this.m_WorkitemRepository)
                {
                    this.m_WorkitemRepository = createWorkItemRepository();
                }
                return this.m_WorkitemRepository;
            }
            if (com.wewebu.ow.csqlc.OwCSQLCProcessor.class.isAssignableFrom(interfaceClass))
            {
                return factorySearchNodeSQLProcessor();
            }
            if (OwInfoProvider.class.isAssignableFrom(interfaceClass))
            {
                return new OwCMISInfoProvider(this);
            }

        }
        catch (ClassNotFoundException e)
        {
            String message = "The requested interface was not found on classpath: " + strInterfaceName_p;
            LOG.error(message, e);
            throw new OwInvalidOperationException(message, e);
        }

        String message = "Requested interface is not supported by this network, interface = " + strInterfaceName_p;
        LOG.error(message);
        throw new OwNotSupportedException(message);
    }

    /**
     * @return An instance of {@link OwWorkitemRepository} as specified in the owbootstrap.xml configuration file.
     * @throws OwConfigurationException Thrown if we were unable to create the BPM instance or the owbootstrap.xml file does not have a BPM configured. 
     */
    @SuppressWarnings("rawtypes")
    private OwWorkitemRepository createWorkItemRepository() throws OwConfigurationException
    {
        OwXMLUtil bpmConfigNode = getNetworkConfiguration().getBpmNode();
        String implementationClassName = bpmConfigNode.getSafeTextValue("ClassName", "");

        if (0 == implementationClassName.length())
        {
            String message = "No BPM configured for this instance!";
            LOG.error(message);
            throw new OwConfigurationException(message);
        }

        try
        {
            Class implementationClass = Class.forName(implementationClassName);
            Constructor constructor = implementationClass.getConstructor(OwNetwork.class, OwXMLUtil.class);
            OwWorkitemRepository instance = (OwWorkitemRepository) constructor.newInstance(this, bpmConfigNode);
            return instance;
        }
        catch (ClassNotFoundException e)
        {
            String message = "Could not create instance.";
            LOG.error(message, e);
            throw new OwConfigurationException(message, e);
        }
        catch (SecurityException e)
        {
            String message = "Could not create instance.";
            LOG.error(message, e);
            throw new OwConfigurationException(message, e);
        }
        catch (NoSuchMethodException e)
        {
            String message = "Could not create instance.";
            LOG.error(message, e);
            throw new OwConfigurationException(message, e);
        }
        catch (IllegalArgumentException e)
        {
            String message = "Could not create instance.";
            LOG.error(message, e);
            throw new OwConfigurationException(message, e);
        }
        catch (InstantiationException e)
        {
            String message = "Could not create instance.";
            LOG.error(message, e);
            throw new OwConfigurationException(message, e);
        }
        catch (IllegalAccessException e)
        {
            String message = "Could not create instance.";
            LOG.error(message, e);
            throw new OwConfigurationException(message, e);
        }
        catch (InvocationTargetException e)
        {
            String message = "Could not create instance.";
            LOG.error(message, e);
            throw new OwConfigurationException(message, e);
        }
    }

    public Locale getLocale()
    {
        return m_context.getLocale();
    }

    public boolean hasInterface(String strInterfaceName_p)
    {
        if ("com.wewebu.ow.server.ecm.bpm.OwWorkitemRepository".equals(strInterfaceName_p))
        {
            try
            {
                return getNetworkConfiguration() != null && getNetworkConfiguration().getBpmNode() != null;
            }
            catch (OwConfigurationException ex)
            {
                if (LOG.isDebugEnabled())
                {
                    LOG.debug("Support for Workflow not available, caused by missing configuration");
                }
                return false;
            }
        }
        if (com.wewebu.ow.csqlc.OwCSQLCProcessor.class.getCanonicalName().equals(strInterfaceName_p))
        {
            return true;
        }
        if (OwInfoProvider.class.getCanonicalName().equals(strInterfaceName_p))
        {
            return true;
        }
        return false;
    }

    public void init(OwNetworkContext context_p, OwXMLUtil networkSettings_p) throws OwException
    {
        //        initResourceCache();

        m_context = context_p;
        m_networkConfigurtaion = new OwCMISNetworkConfiguration(networkSettings_p);
        if (virtualFolderFactory == null)
        {
            virtualFolderFactory = new OwCMISVirtualFolderFactory(this, getDMSIDDecoder());
        }
    }

    /**
     * Initialize complete new cache for current session.
     * <p>ATTENTION: if the cache already exist, it will
     * be cleared and recreated.</p>
     */
    protected void initResourceCache()
    {
        if (m_resourcesIDs != null)
        {
            m_resourcesIDs.clear();
            m_resourcesIDs = null;
        }
        if (m_resourcesNames != null)
        {
            m_resourcesNames.clear();
            m_resourcesNames = null;
        }
        if (m_repositoryIDs != null)
        {
            m_repositoryIDs.clear();
            m_repositoryIDs = null;
        }

        m_repositoryIDs = new LinkedList<String>();
        m_resourcesIDs = new HashMap<String, OwCMISResource>();
        m_resourcesNames = new HashMap<String, OwCMISResource>();
    }

    public void setEventManager(OwEventManager eventManager_p)
    {
        m_eventmanager = eventManager_p;
    }

    public void setRoleManager(OwRoleManager roleManager_p)
    {
        m_rolemanager = roleManager_p;
    }

    public boolean canBatch()
    {
        // TODO Auto-generated method stub
        return false;
    }

    public boolean canRefreshStaticClassdescriptions() throws OwException
    {
        // TODO Auto-generated method stub
        return false;
    }

    public void closeBatch(OwBatch batch_p) throws OwException
    {
        // TODO Auto-generated method stub

    }

    @SuppressWarnings("rawtypes")
    public final OwObjectCollection doSearch(OwSearchNode searchCriteria_p, OwSort sortCriteria_p, Collection propertyNames_p, int maxSize_p, int versionSelection_p) throws Exception
    {
        OwCMISSearchResult result = doCMISSearch(searchCriteria_p, sortCriteria_p, propertyNames_p, maxSize_p, versionSelection_p);
        return result.getCmisSearchResult();
    }

    @SuppressWarnings({ "unchecked", "rawtypes" })
    public OwCMISSearchResult doCMISSearch(OwSearchNode searchCriteria_p, OwSort sortCriteria_p, Collection propertyNames_p, int maxSize_p, int versionSelection_p) throws OwException
    {
        /*Repositories MUST support the escaping of characters using a backslash (\) in the query statement.  The 
          backslash character (\) will be used to escape characters within quoted strings in the query as follows: 
            1. \" will represent a double-quote (") character
            2. \’ will represent a single-quote(‘) character
            3. \ \ will represent a backslash (\) character
            4. Within a LIKE string, \% and \_ will represent the literal characters % and _, respectively.
            5. All other instances of a \ are errors*/

        BigInteger max = new BigInteger(Integer.toString(2 * maxSize_p));

        //results mapped on their repository IDs
        Map<String, List<OwCMISQueryResult>> searchResults = new HashMap<String, List<OwCMISQueryResult>>();
        OwCMISCSQLCProcessor processor = factorySearchNodeSQLProcessor();

        /*Execute the search query, against the defined repository*/
        try
        {
            OwExternal<List<OwQueryStatement>> statementsEx = processor.createSQLStatements(searchCriteria_p, propertyNames_p, sortCriteria_p);
            List<OwQueryStatement> statements = statementsEx.getInternal();

            for (OwQueryStatement statement : statements)
            {
                OwBooleanCollector adviceResut = OwBooleanCollector.newAND(true);
                OwNativeSearchAdvice sqlSearchAdvice = OwJoinPoint.joinPoint(OwNativeSearchAdvice.class, adviceResut);
                sqlSearchAdvice.adviceNativeSearch(statement);
                if (adviceResut.getResult())
                {
                    String searchOp = statement.createSQLString().toString();

                    StopWatch stopWatch = new Log4JStopWatch("OwCMISNetwork.doSearch", "OwCMISNetwork.doSearch: Search service");
                    LOG.debug("OwCMISNetwork.doSearch: " + searchOp);

                    final String repositoryID = statement.getTargetRepositoryID();
                    OwCMISResource resource = getResource(repositoryID);
                    final CmisRepositoryCapabilitiesType capabilities = resource.getCMISCapabilities();
                    boolean searchVersionAll = versionSelection_p == OwSearchTemplate.VERSION_SELECT_ALL;
                    if (searchVersionAll)
                    {
                        //check version selection is supported by repository
                        searchVersionAll = capabilities.isCapabilityAllVersionsSearchable();
                        if (!searchVersionAll)
                        {
                            //TODO may be throw an Invalid Exception, if not supported by repository
                            LOG.warn("OwCMISNetwork.doSearch: The repository does not support search in all versions! Search will be excuted for current versions only!");
                        }
                    }

                    LOG.debug("OwCMISNetwork.doSearch: searchVersionAll = " + searchVersionAll);

                    //delegate Search to CMIS-service
                    CmisObjectListType searchResultLst = getDiscoveryServicePort().query(repositoryID, searchOp, searchVersionAll, true, EnumIncludeRelationships.NONE, "", max, BigInteger.ZERO, null);
                    stopWatch.stop();
                    List<OwCMISQueryResult> repositoryResults = searchResults.get(repositoryID);
                    if (repositoryResults == null)
                    {
                        repositoryResults = new LinkedList<OwCMISQueryResult>();
                        searchResults.put(repositoryID, repositoryResults);
                    }
                    repositoryResults.add(new OwCMISQueryResult(statement, searchResultLst));
                }
            }

            OwObjectCollection cmisSearchResult = createSearchResult(searchResults, versionSelection_p, maxSize_p);
            return new OwCMISSearchResult(statementsEx, cmisSearchResult);
        }
        catch (CmisException e)
        {
            OwCMISExceptionCatcher catcher = new OwCMISExceptionCatcher(e, this.getContext().getLocale());
            LOG.error("OwCMISNetwork.doSearch: Search could not be executed because of a CMIS error : " + catcher.getLogMessage(), e);
            throw catcher.toOwException(getContext().localize("ecmimpl.cmis.OwCMISNetwork.backend.search.error", "Error executing search on backend! "), false);
        }
        catch (OwException e)
        {
            LOG.error("OwCMISNetwork.doSearch: Search could not be executed!", e);
            throw new OwServerException(getContext().localize("ecmimpl.cmis.OwCMISNetwork.search.error", "Error executing search !"), e);
        }
        catch (Exception e)
        {
            LOG.error("OwCMISNetwork.doSearch: Search could not be executed!", e);
            throw new OwServerException(getContext().localize("ecmimpl.cmis.OwCMISNetwork.search.error", "Error executing search !"), e);
        }
    }

    @SuppressWarnings("unchecked")
    /**
     * Wraps native search results into a framework defined search collection.
     * @param searchResults_p results mapped by their repository IDs 
     * @param versionSelection_p the value of the calling <code>doSearch</code> parameter   
     * @param maxSize_p the value of the calling <code>doSearch</code> parameter
     * @return an {@link OwObjectCollection} containing Workdesk objects corresponding to all objects in the given collections
     */
    private OwObjectCollection createSearchResult(Map<String, List<OwCMISQueryResult>> searchResults_p, int versionSelection_p, int maxSize_p) throws OwException
    {
        try
        {
            OwStandardObjectCollection result = new OwStandardObjectCollection();
            result.setAttribute(OwObjectCollection.ATTRIBUTE_IS_COMPLETE, Boolean.TRUE);
            for (Map.Entry<String, List<OwCMISQueryResult>> repositoryResult : searchResults_p.entrySet())
            {
                List<OwCMISQueryResult> resultObjects = repositoryResult.getValue();

                String repositoryID = repositoryResult.getKey();
                OwCMISResource resource = getResource(repositoryID);

                CmisRepositoryCapabilitiesType capabilities = resource.getCMISCapabilities();

                final boolean pwcSearchable = capabilities.isCapabilityPWCSearchable();
                final boolean searchCheckedOut = versionSelection_p == OwSearchTemplate.VERSION_SELECT_CHECKED_OUT;
                if (searchCheckedOut && !pwcSearchable)
                {
                    //TODO may be throw an Invalid Exception, if not supported by repository
                    LOG.warn("OwCMISNetwork.createSearchResult: The repository does not support search for checked-out documents! ");
                }

                boolean searchVersionAll = versionSelection_p == OwSearchTemplate.VERSION_SELECT_ALL;
                if (searchVersionAll)
                {
                    //check version selection is supported by repository
                    searchVersionAll = capabilities.isCapabilityAllVersionsSearchable();
                    if (!searchVersionAll)
                    {
                        //TODO may be throw an Invalid Exception, if not supported by repository
                        LOG.warn("OwCMISNetwork.createSearchResult: The repository does not support search in all versions! Search will be excuted for current versions only!");
                    }
                }

                for (OwCMISQueryResult qResult : resultObjects)
                {

                    CmisObjectListType searchResult = qResult.getObjectList();
                    List<CmisObjectType> objects = searchResult.getObjects();
                    if (result.size() > maxSize_p && searchResult.getNumItems().intValue() > 0)
                    {
                        result.setAttribute(OwObjectCollection.ATTRIBUTE_IS_COMPLETE, Boolean.FALSE);
                        break;
                    }
                    if (objects != null)
                    {
                        Map<String, OwCMISObject> candidates = new HashMap<String, OwCMISObject>();
                        for (Iterator<?> i = objects.iterator(); i.hasNext();)
                        {
                            CmisObjectType nativeCmisObject = (CmisObjectType) i.next();
                            OwCMISNetworkExtension networkExtension = resource.getExtension(OwCMISNetworkExtension.TWEAK_OBJECT_EP, OwCMISNetworkExtension.class, nativeCmisObject);
                            nativeCmisObject = networkExtension.tweakSearchResult(nativeCmisObject, qResult.getStatement(), this);

                            OwCMISObject cmisObject = createCMISObject(nativeCmisObject, resource);
                            result.add(cmisObject);
                            if (cmisObject instanceof OwCMISDocumentObject)
                            {
                                if (pwcSearchable)
                                {

                                    if (!searchVersionAll)
                                    {
                                        String versionSeriesID = OwCMISPropertyNames.VERSION_SERIES_ID.getIdValue(nativeCmisObject);
                                        if (!searchCheckedOut)
                                        {
                                            final Boolean seriesCheckedOut = OwCMISPropertyNames.IS_VERSION_SERIES_CHECKED_OUT.getBooleanValue(nativeCmisObject);
                                            final Boolean latestVersion = OwCMISPropertyNames.IS_LATEST_VERSION.getBooleanValue(nativeCmisObject);
                                            //fast NON PWC detection
                                            if (seriesCheckedOut != null && latestVersion != null && (!seriesCheckedOut || !latestVersion))
                                            {
                                                OwCMISObject candidate = candidates.get(versionSeriesID);
                                                if (candidate != null)
                                                {
                                                    result.remove(candidate);
                                                }
                                                candidates.put(versionSeriesID, cmisObject);
                                            }
                                            else
                                            {
                                                if (!candidates.containsKey(versionSeriesID))
                                                {
                                                    candidates.put(versionSeriesID, cmisObject);
                                                }
                                                else
                                                {
                                                    result.remove(cmisObject);
                                                }
                                            }
                                        }
                                        else
                                        {
                                            final Boolean seriesCheckedOut = OwCMISPropertyNames.IS_VERSION_SERIES_CHECKED_OUT.getBooleanValue(nativeCmisObject);
                                            final Boolean latestVersion = OwCMISPropertyNames.IS_LATEST_VERSION.getBooleanValue(nativeCmisObject);
                                            //fast PWC detection
                                            if (seriesCheckedOut != null && latestVersion != null && seriesCheckedOut && latestVersion)
                                            {
                                                OwCMISObject candidate = candidates.get(versionSeriesID);
                                                if (candidate != null)
                                                {
                                                    result.remove(candidate);
                                                }
                                                candidates.put(versionSeriesID, cmisObject);
                                            }
                                            else
                                            {
                                                if (!candidates.containsKey(versionSeriesID))
                                                {
                                                    candidates.put(versionSeriesID, cmisObject);
                                                }
                                                else
                                                {
                                                    result.remove(cmisObject);
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                            if (result.size() >= maxSize_p && i.hasNext())
                            {
                                result.setAttribute(OwObjectCollection.ATTRIBUTE_IS_COMPLETE, Boolean.FALSE);
                                break;
                            }
                        }
                    }
                }
                if (result.size() >= maxSize_p)
                {
                    break;
                }
            }
            result.setAttribute(OwObjectCollection.ATTRIBUTE_SIZE, Integer.valueOf(result.size()));
            return result;

        }
        catch (OwException e)
        {
            LOG.error("OwCMISNetwork.createSearchResult: Search resoult cold not be created!", e);
            throw e;
        }
        catch (Exception e)
        {
            LOG.error("OwCMISNetwork.createSearchResult: Search resoult cold not be created!", e);
            throw new OwServerException(getContext().localize("ecmimpl.cmis.OwCMISNetwork.search.error", "Error executing search !"), e);
        }
    }

    public String getDMSPrefix()
    {
        return getDMSIDDecoder().getDMSIDPrefix();
    }

    public OwEventManager getEventManager()
    {
        return m_eventmanager;
    }

    public OwNetworkContext getContext()
    {
        return m_context;
    }

    public OwCMISObjectClass getObjectClass(String strClassName_p, OwResource resource_p) throws OwException
    {
        OwCMISResource cmisResource = (OwCMISResource) resource_p;
        if (null == resource_p)
        {
            cmisResource = getDefaultResource();
        }

        OwCMISObjectModel objectModel = cmisResource.getObjectModel();
        OwCMISObjectClass clazz = objectModel.getObjectClass(strClassName_p);
        OwCMISNetworkExtension ext = cmisResource.getExtension(OwCMISNetworkExtension.PREPARE_OBJECT_CLASS_EP, OwCMISNetworkExtension.class, clazz);
        return ext.prepareObjectClass(clazz, this);
    }

    public Map<String, String> getObjectClassNames(int[] types_p, boolean excludeHiddenAndNonInstantiable_p, boolean rootOnly_p, OwResource resource_p) throws OwException
    {
        OwCMISResource cmisResource = (OwCMISResource) resource_p;

        if (null == cmisResource)
        {
            cmisResource = getDefaultResource();
        }
        OwCMISObjectModel objectModel = cmisResource.getObjectModel();

        return objectModel.getObjectClassNames(types_p, excludeHiddenAndNonInstantiable_p, rootOnly_p, getLocale());
    }

    public OwCMISObject getObjectFromDMSID(String strDMSID_p, boolean refresh_p) throws OwException
    {
        OwCMISDMSIDDecoder dmsidCodec = getDMSIDDecoder();
        OwCMISDMSID dmsid = dmsidCodec.createDMSID(strDMSID_p);
        return dmsid.getObject(this);

    }

    public OwObject getObjectFromPath(String strPath_p, boolean refresh_p) throws OwException
    {
        if (strPath_p.equals(OwObject.STANDARD_PATH_DELIMITER))
        {
            return m_domainroot;
        }
        else
        {
            int end = strPath_p.indexOf(OwObject.STANDARD_PATH_DELIMITER, 1);
            String strRepoName = null;
            if (strPath_p.startsWith(OwObject.STANDARD_PATH_DELIMITER))
            {
                strRepoName = strPath_p.substring(1, end);
            }
            else
            {
                strRepoName = strPath_p.substring(0, end);
            }
            OwCMISResource res = getResource(strRepoName);

            if (res == null)
            {//check if resource was defined by name
                for (OwCMISResource entry : m_resourcesIDs.values())
                {
                    if (entry.getDisplayName(getLocale()).equals(strRepoName))
                    {
                        res = entry;
                        break;
                    }
                }
            }

            if (res == null)
            {//no resource was defined by path, use default
                LOG.debug("repository could not be found by the given path, using default repository!");
                res = getDefaultResource();
            }

            try
            {
                OwCMISPropertiesFilter filter = new OwCMISPropertiesFilter();
                filter.add(OwCMISPropertyNames.OBJECT_ID.getId());
                filter.add(OwCMISPropertyNames.OBJECT_TYPE_ID.getId());
                CmisObjectType obj = getObjectServicePort().getObjectByPath(res.getID(), strPath_p.substring(end), filter.getFilterString(), Boolean.TRUE, EnumIncludeRelationships.NONE, null, Boolean.FALSE, Boolean.FALSE, null);
                return createCMISObject(obj, res);
            }
            catch (CmisException e)
            {
                OwCMISExceptionCatcher catcher = new OwCMISExceptionCatcher(e, this.getContext().getLocale());
                LOG.error("OwCMISNetwork.getObjectFromPath(): Can not find object by path " + strPath_p + ". A CMIS error occurred :  " + catcher.getLogMessage(), e);
                throw catcher.toOwException(getContext().localize1("ecmimpl.cmis.OwCMISNetwork.objectbypath.error", "Could not find object by path (%1)", strPath_p), true);
            }
        }
    }

    public OwCMISResource getResource(String strIdOrName_p) throws OwException
    {
        if (strIdOrName_p == null)
        {
            return getDefaultResource();
        }
        else
        {
            OwCMISResource resource = m_resourcesIDs.get(strIdOrName_p);
            //if it's not an ID may be a name
            if (resource == null)
            {
                resource = m_resourcesNames.get(strIdOrName_p);
            }
            if (null == resource)
            {
                try
                {
                    List<CmisRepositoryEntryType> lst = getRepositoryServicePort().getRepositories(null);
                    for (CmisRepositoryEntryType repositoryEntry : lst)
                    {
                        if (repositoryEntry.getRepositoryId().equals(strIdOrName_p) || repositoryEntry.getRepositoryName().equals(strIdOrName_p))
                        {
                            RepositoryServicePort repositoryServicePort = getRepositoryServicePort();
                            CmisRepositoryInfoType repositoryInfo = repositoryServicePort.getRepositoryInfo(repositoryEntry.getRepositoryId(), null);
                            resource = new OwCMISResource(repositoryEntry, repositoryInfo, this, getObjectClassFactory());
                            m_resourcesIDs.put(strIdOrName_p, resource);
                            m_resourcesNames.put(repositoryEntry.getRepositoryName(), resource);

                            break;
                        }
                    }
                }
                catch (CmisException e)
                {
                    OwCMISExceptionCatcher catcher = new OwCMISExceptionCatcher(e);
                    LOG.error("OwCMISNetwork.getResource(): Could not retrieve CMIS repository information for resource ID " + strIdOrName_p + ". A CMIS error occurred :  " + catcher.getLogMessage(), e);
                    throw catcher.toOwException(getContext().localize1("ecmimpl.cmis.OwCMISNetwork.resource.info.error", "An error occurred while retrieving repository information  for resource with ID %1", strIdOrName_p));
                }
            }

            if (resource == null)
            {//resource could not be found by name or id
                LOG.warn("OwCMISNetwork.getResource(Id): Could not retrive resource by Id = " + strIdOrName_p);
                throw new OwObjectNotFoundException(getContext().localize1("ecmimpl.cmis.OwCMISNetwork.resourceNotFoundById", "Could not find resource by Id = %1", strIdOrName_p));
            }
            return resource;
        }
    }

    public Iterator<String> getResourceIDs() throws OwException
    {
        return m_repositoryIDs.iterator();
    }

    public OwBatch openBatch() throws OwException
    {
        // TODO Auto-generated method stub
        return null;
    }

    public void refreshStaticClassdescriptions() throws OwException
    {
        // TODO Auto-generated method stub
    }

    public void releaseResources() throws OwException
    {
        // TODO Auto-generated method stub
    }

    /**
     * Handle the getFieldDefinition(String,String) call.
     * <p>If the given resource name string is not null, the method
     * try to resolve the string as name or ID of the resource.</p>
     * @param strFieldDefinitionName_p String specifying the field name
     * @param strResourceName_p String resource name, can be null then the default source is used
     * @return OwFieldDefinition which was found for given <b>strQualifiedFieldName_p</p>
     * @throws OwException if resource name could not be resolved an OwObjectNotFoundException is thrown
     */
    public OwFieldDefinition getFieldDefinition(String strFieldDefinitionName_p, String strResourceName_p) throws OwException
    {
        OwCMISResource cmisResource = strResourceName_p == null ? getDefaultResource() : getResource(strResourceName_p);

        if (cmisResource == null)
        {
            cmisResource = getResource(strResourceName_p);
            if (cmisResource == null)
            {
                LOG.error("OwCMISNetwork.getFieldDefinition():Could not find a requested field definition!Resource could not be found, or incorrect resource ID/name (" + strResourceName_p + ")");
                throw new OwObjectNotFoundException(getContext().localize("ecmimpl.cmis.OwCMISNetwork.field.definition.not.found.error", "Could not find a requested field definition!"));
            }
        }

        OwCMISObjectModel objectModel = cmisResource.getObjectModel();
        return objectModel.getPropertyClass(strFieldDefinitionName_p);
    }

    public Collection<OwWildCardDefinition> getWildCardDefinitions(String strFieldDefinitionName_p, String strResourceName_p, int op_p) throws OwException
    {
        switch (op_p)
        {
            case OwSearchOperator.CRIT_OP_NOT_LIKE:
            case OwSearchOperator.CRIT_OP_LIKE:
            {
                if (this.wildcardsDef == null)
                {
                    this.wildcardsDef = new OwCMISLikeWildcardDefinitions(getContext());
                }

                return this.wildcardsDef.getWildCardDefinitions();
            }
            default:
                return null;
        }
    }

    public boolean canUserSelect() throws OwException
    {
        try
        {
            Node authenticationNode = getNetworkConfiguration().getConfigNode().getSubNode("Authentication");
            return OwCMISCredentials.AUTH_LDAP.equals(OwXMLDOMUtil.getSafeStringAttributeValue(authenticationNode, "mode", ""));
        }
        catch (Exception e)
        {
            String msg = "Invalid Credentials - maybe there are problems on reading the network config node/subnode \"(Authentication)\"...";
            LOG.error("OwCMISNetwork.createCredentials():" + msg, e);
            throw new OwServerException(getContext().localize("ecmimpl.cmis.OwCMISNetwork.invalid.authentication.configuration.error", "Invalid CMIS authentication configuration!"), e);
        }
    }

    public OwUILoginModul<OwCMISNetwork> getLoginSubModul() throws OwException
    {
        OwCMISLoginSubModul loginSubModul = new OwCMISLoginSubModul();
        loginSubModul.init(this);

        return loginSubModul;
    }

    public String getRoleDisplayName(String strRoleName_p) throws OwException
    {
        // TODO retrieve display name if possible
        return strRoleName_p;
    }

    public OwUserInfo getUserFromID(String strID_p) throws OwException
    {
        OwCMISCredentials objCred = this.getCredentials();
        if (!OwCMISLDAPCredentials.class.isAssignableFrom(objCred.getClass()))
        {
            throw new OwServerException("This method only works for LDAP.");
        }

        OwCMISLDAPCredentials cred = (OwCMISLDAPCredentials) objCred;
        OwLdapConnector con = cred.getLdapConnector();
        try
        {
            OwUserInfo userInfo = con.findUserByDNAnonymously(strID_p);
            return userInfo;
        }
        catch (OwObjectNotFoundException e)
        {
        }

        //try by ID
        OwUserInfo userInfo = con.findUserByIdAnonymously(strID_p);
        return userInfo;
    }

    public OwUIUserSelectModul getUserSelectSubModul(String strID_p, int[] types_p) throws OwException
    {
        OwCMISUIUserSelectionModul modul = null;
        if (canUserSelect())
        {
            modul = new OwCMISUIUserSelectionModul();
            modul.setFilter(types_p);
            modul.setCurrentUserID(strID_p);
            try
            {
                modul.init(this);
            }
            catch (Exception e)
            {
                String msg = "Cannot initialize the User selection module";
                LOG.error(msg, e);
                throw new OwServerException(getContext().localize("ecmimpl.cmis.OwCMISNetwork.initUserSelectEx", "Cannot initialize the User Selection dialog."), e);
            }
        }

        return modul;
    }

    public void loginDefault(String strUser_p, String strPassword_p) throws OwException
    {
        if (strUser_p == null && strPassword_p == null)
        {
            getCredentials();
        }
        else
        {
            try
            {
                authenticate(strUser_p, strPassword_p);
            }
            catch (OwException e)
            {
                logout();
                throw e;
            }
        }
        postLogin();

    }

    private OwAuthenticationContext getAuthenticationContext()
    {
        OwNetworkContext context = getContext();
        if (context instanceof OwAuthenticationContext)
        {
            return (OwAuthenticationContext) context;
        }
        else
        {
            return localAuthenticationContext;
        }
    }

    public OwCMISCredentials getCredentials() throws OwAuthenticationException
    {
        OwAuthenticationContext authenticationContext = getAuthenticationContext();
        OwAuthentication authentication = authenticationContext.getAuthentication();
        if (authentication == null || !authentication.isAuthenticated())
        {
            LOG.trace("OwCMISNetwork.getCredentials : No authenticated credentials found.");
            return null;
        }
        else
        {
            OwCMISCredentials cmisCredentials = (OwCMISCredentials) authentication.getOWDCredentials();
            return cmisCredentials;
        }
    }

    public void authenticate(String strUser_p, String strPassword_p) throws OwAuthenticationException, OwConfigurationException, OwServerException
    {
        OwCMISCredentialsAuthenticator authenticator = new OwCMISCredentialsAuthenticator(getNetworkConfiguration().getConfigNode());
        OwAuthentication authentication = new OwCredentialsAuthentication(null, strUser_p, strPassword_p);
        authentication = authenticator.authenticate(authentication);

        if (authentication.isAuthenticated())
        {

            OwCMISCredentials credentials = (OwCMISCredentials) authentication.getOWDCredentials();

            //authenticated 
            TimeZone clientTimeZone = getContext().getClientTimeZone();
            OwMandator mandator = getContext().getMandator();

            credentials.setMandator(mandator);
            OwCMISSecurityHandlerInterface securityHandler = credentials.getSecurityHandler();
            securityHandler.setWsi18nTimeZone(clientTimeZone);
            securityHandler.setLocale(getLocale());

            OwAuthenticationContext authenticationContext = getAuthenticationContext();
            authenticationContext.setAuthentication(authentication);
        }

    }

    protected void postLogin() throws OwException
    {
        try
        {
            RepositoryServicePort repositoryServicePort = getRepositoryServicePort();
            List<CmisRepositoryEntryType> rlist = repositoryServicePort.getRepositories(null);
            initResourceCache();

            // iterate the repositories
            for (CmisRepositoryEntryType repositoryEntry : rlist)
            {
                // create default resource
                if (getDefaultResource() == null)
                {
                    CmisRepositoryInfoType repositoryInfo = repositoryServicePort.getRepositoryInfo(repositoryEntry.getRepositoryId(), null);
                    m_defaultresource = new OwCMISResource(repositoryEntry, repositoryInfo, this, getObjectClassFactory());
                    m_resourcesIDs.put(repositoryEntry.getRepositoryId(), m_defaultresource);
                    m_resourcesNames.put(repositoryEntry.getRepositoryName(), m_defaultresource);
                }

                m_repositoryIDs.add(repositoryEntry.getRepositoryId());
            }

            // create domain root
            m_domainroot = new OwCMISDomainFolder(this);
            getContext().onLogin(this.getCredentials().getUserInfo());
        }
        catch (CmisException cmisEx)
        {
            OwCMISExceptionCatcher catcher = new OwCMISExceptionCatcher(cmisEx, this.getContext().getLocale());
            LOG.error("OwCMISNetwork.loginDefault(): Could not login. A CMIS error occurred :  " + catcher.getLogMessage(), cmisEx);
            logout();
            throw catcher.toOwException(getContext().localize("ecmimpl.cmis.OwCMISNetwork.login.cmis.error", "An error occurred during login!"), true);
        }
        catch (SOAPFaultException ex)
        {
            logout();
            LOG.debug("OwCMISNetwork.loginDefault(): Login failed: Wrong username or password!", ex);
            throw new OwAuthenticationException(getContext().localize("ecmimpl.cmis.OwCMISNetwork.login.failed", "Login failed: Wrong username or password!"), ex);
        }
        catch (WebServiceException serviceEx)
        {
            logout();
            LOG.fatal("OwCMISNetwork.loginDefault(): Can not create communication to the Webservices!", serviceEx);
            throw new OwServerException(getContext().localize("ecmimpl.cmis.OwCMISNetwork.login.communication.error", "Cannot create communication to the Webservices!"), serviceEx);
        }
        catch (OwConfigurationException conEx)
        {
            logout();
            throw conEx;
        }
        catch (Error err)
        {
            logout();
            throw err;
        }
        catch (Exception e)
        {
            logout();
            throw new OwServerException(getContext().localize("ecmimpl.cmis.OwCMISNetwork.login.cmis.error", "An error occurred during login!"), e);
        }
    }

    public void logout() throws OwException
    {
        try
        {
            OwCMISCredentials credentials = getCredentials();
            if (credentials != null)
            {
                credentials.invalidate();
            }
        }
        catch (Exception e)
        {
            LOG.warn("OwCMISNetwork.logout(): Invalidate credentials errors...", e);
        }
        finally
        {
            OwAuthenticationContext authenticationContext = getAuthenticationContext();
            authenticationContext.setAuthentication(null);

            if (this.m_repositoryIDs != null)
            {
                this.m_repositoryIDs.clear();
                this.m_repositoryIDs = null;
            }
            if (this.m_resourcesIDs != null)
            {
                this.m_resourcesIDs.clear();
                this.m_resourcesIDs = null;
            }
            if (this.m_resourcesNames != null)
            {
                this.m_resourcesNames.clear();
                this.m_resourcesNames = null;
            }
        }
    }

    public RepositoryServicePort getRepositoryServicePort() throws OwException
    {
        return getCredentials().getRepositoryServicePort();
    }

    public NavigationServicePort getNavigationServicePort() throws OwException
    {
        return getCredentials().getNavigationServicePort();
    }

    public ObjectServicePort getObjectServicePort() throws OwException
    {
        return getCredentials().getObjectServicePort();
    }

    public DiscoveryServicePort getDiscoveryServicePort() throws OwException
    {
        return getCredentials().getDiscoveryServicePort();
    }

    public MultiFilingServicePort getMultiFilingServicePort() throws OwException
    {
        return getCredentials().getMultiFilingservicePort();
    }

    public PolicyServicePort getPolicyServicePort() throws OwException
    {
        return getCredentials().getPolicyServicePort();
    }

    public RelationshipServicePort getRelationshipServicePort() throws OwException
    {
        return getCredentials().getRelationshipServicePort();
    }

    public VersioningServicePort getVersionServicePort() throws OwException
    {
        return getCredentials().getVersionServicePort();
    }

    /**
     * 
     * @return the current {@link ACLServicePort}
     * @throws OwException
     * @since 3.2.0.0
     */
    public ACLServicePort getACLServicePort() throws OwException
    {
        return getCredentials().getACLServicePort();
    }

    /**
     * Return the default resource which was set during 
     * Initialization of this network.
     * @return OwCMISResouce or null if login was not successful
     */
    protected OwCMISResource getDefaultResource()
    {
        return this.m_defaultresource;
    }

    /**(overridable)
     * Returns a factory class which has implemented
     * methods to create native CMIS objects and also the
     * wrapping OwCMISProperty.
     * <p>Implementation of factory should have a constructor
     * class.getConsturtor({OwCMISNetwork.class})</p>
     * @return OwCMISPropertyFactoryInterface
     * @throws OwException
     * @see OwCMISPropertyClassFactory
     */
    public OwCMISPropertyClassFactory getPropertyClassFactory() throws OwException
    {
        if (this.m_propFactory == null)
        {
            m_propFactory = new OwCMISStandardPropertyClassFactory(getContext().getClientTimeZone(), this.getNetworkConfiguration());
        }
        return m_propFactory;
    }

    /**
     * Getter for current object class factory, will instantiate 
     * and initialize the factory.
     * @return the object class factory of this network
     * @throws OwException 
     */
    public OwCMISObjectClassFactory getObjectClassFactory() throws OwException
    {
        if (this.m_objectClassFactory == null)
        {
            OwCMISPropertyClassFactory propertyClassFactory = getPropertyClassFactory();
            this.m_objectClassFactory = createObjectClassFactory(propertyClassFactory);
            this.m_objectClassFactory.setPreferredPropertyOrder(getNetworkConfiguration().getPreferedPropertyOrder());
        }

        return this.m_objectClassFactory;
    }

    /**
     * (overridable)create search template from given OwObject,
     * where the content of given OwObject is the search definition. 
     * @param obj_p OwObject search template
     * @return OwSearchTemplate
     * @throws OwException
     */
    public OwSearchTemplate createSearchTemplate(OwObject obj_p) throws OwException
    {
        try
        {
            return new OwStandardSearchTemplate(getContext(), obj_p);
        }
        catch (OwException e)
        {
            throw e;
        }
        catch (Exception e)
        {
            LOG.error("OwCMISNetwork.createSearchTemplate():Could not instantiate search template: " + e.getMessage(), e);
            throw new OwServerException(getContext().localize("ecmimpl.cmis.OwCMISNetwork.search.template.error", "Search template error!"), e);
        }
    }

    /**(overridable) 
     * Factory which creates the SQLProcessor instance to 
     * be used for parsing the OwSearchNode tree in the doSearch-method.
     * @return OwCMISSearchNodeSQLProcessor
     * @throws OwException if initialization of SQLOperator class failed
     * @see #doSearch(OwSearchNode, OwSort, Collection, int, int)
     */
    @SuppressWarnings({ "rawtypes", "unchecked" })
    protected OwCMISCSQLCProcessor factorySearchNodeSQLProcessor() throws OwException
    {
        OwSQLEntitiesResolver resolver = createSQLEntitiesResolver();
        String pClass = getNetworkConfiguration().getConfigNode().getSafeTextValue(CONF_NODE_CSQLCPROCESSOR, null);
        if (pClass != null && !"".equals(pClass))
        {
            try
            {
                Class clazz = Class.forName(pClass);
                Constructor constructor = clazz.getConstructor(OwSQLEntitiesResolver.class);

                return (OwCMISCSQLCProcessor) constructor.newInstance(resolver);
            }
            catch (SecurityException e)
            { //permission denied to access the defined class/constructor
                LOG.error("SecurityManager restrict the instantiation of type " + pClass + "!", e);
                throw new OwServerException(getContext().localize1("ecmimpl.cmis.OwCMISNetwork.factorySQLProc.securityEx", "Instantiation of type %1 is restricted by security.", pClass), e);
            }
            catch (InstantiationException e)
            { //cannot instantiate defined class
                LOG.error("Cannot Instantiate the defined class " + pClass, e);
                throw new OwConfigurationException(getContext().localize1("ecmimpl.cmis.OwCMISNetwork.factorySQLProc.instanceEx", "The defined class %1 is not allowed to be instantiated.", pClass), e);
            }
            catch (IllegalAccessException e)
            { //default constructor is not accessible
                LOG.fatal("Cannot Instantiate defined class " + pClass + " because it is not accessible.", e);
                throw new OwServerException(getContext().localize1("ecmimpl.cmis.OwCMISNetwork.factorySQLProc.illegalAccessEx", "The default constructor of class %1 is not accessible or does not exist.", pClass), e);
            }
            catch (ClassNotFoundException e)
            { //defined class could not be found
                LOG.error("The class " + pClass + " could not be found by current ClassLoader.", e);
                throw new OwConfigurationException(getContext().localize1("ecmimpl.cmis.OwCMISNetwork.factorySQLProc.classNotFoundEx", "The defined class %1 could not be found.", pClass), e);
            }
            catch (NoSuchMethodException e)
            {
                LOG.error("The class " + pClass + " does not contain a Constructor(OwSQLEntitiesResolver.class).", e);
                throw new OwConfigurationException(getContext().localize1("ecmimpl.cmis.OwCMISNetwork.factorySQLProc.missingConstructor", "The defined class %1 miss a Constructor(OwSQLEntitiesResolver.class).", pClass), e);
            }
            catch (IllegalArgumentException e)
            {
                LOG.fatal("Provided entieties resolver is not implementing com.wewebu.ow.csqlc.OwSQLEntitiesResolver", e);
                throw new OwServerException(getContext().localize("ecmimpl.cmis.OwCMISNetwork.factorySQLProc.invalidResolver", "The defined the provided resolver does not implement OwSQLEntitiesResolver.class)."), e);
            }
            catch (InvocationTargetException e)
            {
                LOG.error("Creation of CSQLCProcessor (" + pClass + ") failed.", e);
                throw new OwConfigurationException(getContext().localize1("ecmimpl.cmis.OwCMISNetwork.factorySQLProc.instanceFailed", "The defined SQLProcessor %1 could not be instantiated.", pClass), e);
            }
        }
        else
        {
            return new OwCMISCSQLCProcessor(resolver);
        }
    }

    /**(overridable)
     * Create an entities resolver which will be used by the OwCMISCSQLCProcessor.
     * @return OwSQLEntitiesResolver
     * @throws OwException
     * @since 3.2.0.0
     */
    protected OwSQLEntitiesResolver createSQLEntitiesResolver() throws OwException
    {
        return new OwCMISSQLStandardEntitiesResolver(this, externalEntitiesResolver);
    }

    public OwCMISPropertyClass getPropertyClass(String cmisPropertyName_p, String resourceID_p) throws OwException
    {
        OwCMISResource resource = getResource(resourceID_p);
        OwCMISObjectModel objectModel = resource.getObjectModel();
        return objectModel.getPropertyClass(cmisPropertyName_p);
    }

    /**
     * Creates a {@link OwCMISObject} for the given native {@link CmisObjectType},
     * will use the network configuration to create the OwObject as configured. 
     * @param object_p CmisObjectType native object
     * @param resource_p OwCMISResource resource from where
     * @return the {@link OwCMISObject} for the given native object
     * @throws OwException
     * @since 3.2.0.1
     */
    public OwCMISObject createCMISObject(CmisObjectType object_p, OwCMISResource resource_p) throws OwException
    {
        return createCMISObject(object_p, resource_p, getNetworkConfiguration().isPreservedVersion());
    }

    /**
     * Creates a {@link OwCMISObject} for the given native {@link CmisObjectType}
     * @param object_p
     * @param resource_p
     * @return the {@link OwCMISObject} for the given native object
     * @throws OwException
     */
    public OwCMISObject createCMISObject(CmisObjectType object_p, OwCMISResource resource_p, boolean preserveVersion_p) throws OwException
    {
        String objectTypeId = OwCMISPropertyNames.OBJECT_TYPE_ID.getIdValue(object_p);
        if (objectTypeId != null)
        {
            OwCMISObjectClass objectClass = getObjectClass(objectTypeId, resource_p);
            if (objectClass.getType() == OwObjectReference.OBJECT_TYPE_DOCUMENT)
            {
                return objectClass.createCMISObject(this, object_p, preserveVersion_p);
            }
            else
            {
                if (objectClass.getType() == OwObjectReference.OBJECT_TYPE_FOLDER)
                {
                    String className = objectClass.getClassName();
                    OwSemiVirtualRecordClass virtualFolderEntry = semivirtualFolderForObjectClass(className);
                    if (null != virtualFolderEntry)
                    {
                        return new OwCMISSemiVirtualFolderObject(this, resource_p.getObjectModel(), object_p, virtualFolderEntry);
                    }
                    else
                    {
                        return objectClass.createCMISObject(this, object_p, preserveVersion_p);
                    }
                }
                else
                {
                    LOG.error("OwCMISNetwork.createOwCMISObject():Could not create object!Creation of other types than folder and document currently not supported! Got object type " + objectClass.getType());
                    throw new OwNotSupportedException(getContext().localize("ecmimpl.cmis.OwCMISNetwork.create.object.error", "Could not create object!"));
                }
            }
        }
        else
        {
            String msg = "Could not create OwCMISObject : both base type ID and object type ID are missing from the given CMIS object!";
            LOG.error("OwCMISNetwork.createOwCMISObject()" + msg);
            throw new OwInvalidOperationException(getContext().localize("ecmimpl.cmis.OwCMISNetwork.create.object.error", "Could not create object! Missing property: " + OwCMISPropertyNames.OBJECT_TYPE_ID.getId()));
        }
    }

    protected OwSemiVirtualRecordClass semivirtualFolderForObjectClass(String className_p) throws OwConfigurationException, OwException
    {
        OwManagedSemiVirtualRecordConfiguration virtualConfiguration = getManagedVirtualConfiguration();

        OwSemiVirtualRecordClass virtualFolderEntry = virtualConfiguration.semiVirtualFolderForObjectClass(className_p, m_rolemanager);

        return virtualFolderEntry;
    }

    protected OwManagedSemiVirtualRecordConfiguration getManagedVirtualConfiguration() throws OwConfigurationException
    {
        if (null == managedVirtualConfiguration)
        {
            OwXMLUtil ecmAdapterConfig = getNetworkConfiguration().getConfigNode();
            managedVirtualConfiguration = new OwManagedSemiVirtualRecordConfiguration(ecmAdapterConfig);
        }

        return managedVirtualConfiguration;
    }

    /**(overridable)
     * 
     * @return the {@link OwCMISDMSIDDecoder} associated with this network
     */
    public OwCMISDMSIDDecoder getDMSIDDecoder()
    {
        OwCMISNetworkConfiguration configuration = getNetworkConfiguration();
        return configuration.getDMSIDDecoder();
    }

    /**
     * 
     * @deprecated since 4.0.0.0 the virtual folder is aggregated via constructor {@link #OwCMISNetwork(OwCMISExternalEntitiesResolver, OwVirtualFolderFactory)}
     */
    public OwObject createVirtualFolder(Node xmlVirtualFolderDescriptionNode_p, String strName_p, String strDmsIDPart_p) throws OwException
    {
        return this.virtualFolderFactory.createVirtualFolder(xmlVirtualFolderDescriptionNode_p, strName_p, strDmsIDPart_p);
    }

    /**
     * (overridable) Method to return the class which should be used
     * for scanning and retrieving special node (Object stores/repositories,
     * search path's...) for virtual folder handling.
     * @return OwStandardSearchSpecialNodeOperator
     * @deprecated since 4.0.0.0 method no more used see {@link #prepareParentObject(OwObject, OwResource, String, OwPropertyCollection)}
     */
    protected OwStandardSearchSpecialNodeOperator getSpecialNodeOperator()
    {
        return new OwStandardSearchSpecialNodeOperator();
    }

    /**
     * Getter for the network configuration node of 
     * current instance. 
     * @return OwNetworkConfiguration
     * @since 3.2.0.0
     */
    public OwCMISNetworkConfiguration getNetworkConfiguration()
    {
        return m_networkConfigurtaion;
    }

    /**(overridable)
     * Factory method for OwCMISObjectClassFactory, to be used for object model creation. 
     * @param propFactory_p OwCMISPropertyClassFactory
     * @return OwCMISObjectClassFactory
     * @since 4.0.0.0
     */
    protected OwCMISObjectClassFactory createObjectClassFactory(OwCMISPropertyClassFactory propFactory_p)
    {
        return new OwCMISStandardObjectClassFactory(propFactory_p);
    }

    /**
     * @deprecated There is no need to call this method anymore. The {@link OwCMISLoginInfoNetwork} will be removed.
     */
    @Override
    public void initLoginMap(HashMap<String, String> loginMap_p) throws OwException
    {
        // TODO Auto-generated method stub
    }
}