package com.wewebu.ow.server.ecmimpl.cmis;

import java.util.Locale;
import java.util.Map;

import com.wewebu.ow.server.ecm.OwNetwork;
import com.wewebu.ow.server.ecm.OwResource;
import com.wewebu.ow.server.ecmimpl.cmis.objectclasses.OwCMISObjectClass;
import com.wewebu.ow.server.ecmimpl.cmis.propertyclasses.OwCMISPropertyClass;
import com.wewebu.ow.server.ecmimpl.cmis.version.OwCMISVersionModel;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwNotSupportedException;

/**
 *<p>
 * OwCMISObjectModel.
 * Interface for handling and querying of meta-model information form
 * current connected CMIS repository.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 */
public interface OwCMISObjectModel
{
    /**
     * Should return the corresponding property, which was requested by the 
     * given property class name.
     * @param propertyClassName_p String, non-null value
     * @return OwCMISPropertyClass 
     * @throws OwException if could not resolve/retrieve the by given name 
     */
    OwCMISPropertyClass getPropertyClass(String propertyClassName_p) throws OwException;

    /**
     * Returning the OwCMISObjectClass for the given <b><code>objectClassName_p</code></b>.
     * @param objectClassName_p String representing unique symbolic name 
     * @return OwCMISObjectClass
     * @throws OwException if object class could not be found
     */
    OwCMISObjectClass getObjectClass(String objectClassName_p) throws OwException;

    /**
     *This method is called by network to request the map.
     *@param types_p array of types or null,
     *@param excludeHiddenAndNonInstantiable_p boolean to filter hidden or not instantiable classes
     *@param rootOnly_p requesting only root classes
     *@see OwNetwork#getObjectClassNames(int[],boolean, boolean, OwResource)
     *@return a map of symbolic class name to display name
     */
    public Map<String, String> getObjectClassNames(int[] types_p, boolean excludeHiddenAndNonInstantiable_p, boolean rootOnly_p, Locale locale_p) throws OwException;

    /**
     * Return a handler for versioning, version and version series
     * creation.
     * @return OwCMISVersionModel
     * @throws OwException
     * @see OwCMISVersionModel
     */
    OwCMISVersionModel getVersionModel() throws OwException;

    /**
     * Return the ACL model of current repository.
     * @return OwCMISACLModel
     * @throws OwException if could not retrieve information about possible ACL handling
     * @throws OwNotSupportedException
     */
    OwCMISACLModel getACLModel() throws OwException, OwNotSupportedException;

    /**
     * Return the depending OwCMISResource which is used for
     * the meta-model calls.
     * @return OwCMISResource
     */
    OwCMISResource getResource();
}
