package com.wewebu.ow.server.ecmimpl.cmis;

import org.oasis_open.docs.ns.cmis.messaging._200908.CmisObjectListType;

import com.wewebu.ow.csqlc.ast.OwQueryStatement;

/**
 *<p>
 * Packs a query result its SQL statement.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 *@since 3.1.0.0
 */
public class OwCMISQueryResult
{
    private OwQueryStatement statement;
    private CmisObjectListType objectList;

    /**
     * Constructor
     * @param statement_p an SQL statement structure 
     * @param objectList_p the statements CMIS query based result
     */
    public OwCMISQueryResult(OwQueryStatement statement_p, CmisObjectListType objectList_p)
    {
        super();
        this.statement = statement_p;
        this.objectList = objectList_p;
    }

    public OwQueryStatement getStatement()
    {
        return statement;
    }

    public CmisObjectListType getObjectList()
    {
        return objectList;
    }

}
