package com.wewebu.ow.server.ecmimpl.cmis;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import org.apache.log4j.Logger;

import com.wewebu.ow.server.ecm.OwSemiVirtualRecordClass;
import com.wewebu.ow.server.ecmimpl.cmis.log.OwLog;
import com.wewebu.ow.server.exceptions.OwConfigurationException;
import com.wewebu.ow.server.util.OwString;
import com.wewebu.ow.server.util.OwXMLDOMUtil;

/**
 *<p>
 * OwCMISSemiVirtualFolderEntry.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 *@deprecated since 4.0.0.0 use {@link OwSemiVirtualRecordClass}
 */
public class OwCMISSemiVirtualFolderEntry
{
    /** package logger for the class */
    private static final Logger LOG = OwLog.getLogger(OwCMISSemiVirtualFolderEntry.class);

    private String m_sVirtualFolder;
    private String m_sFolderClassName;
    private boolean m_fIncludePhysicalChilds;
    private Map<String, String> m_propertyMapping;

    public OwCMISSemiVirtualFolderEntry(org.w3c.dom.Node n_p) throws OwConfigurationException
    {
        m_sVirtualFolder = OwXMLDOMUtil.getSafeStringAttributeValue(n_p, "virtualfolder", null);
        if (null == m_sVirtualFolder)
        {
            String msg = "OwCMISSemiVirtualFolderEntry.OwCMISSemiVirtualFolderEntry(): Please define \"virtualfolder\" attribute for SemiVirtualRecordClassName node in the owbootstrap.xml.";
            LOG.fatal(msg);
            throw new OwConfigurationException(new OwString("ecmimpl.cmis.OwCMISSemiVirtualFolderEntry.invalid.virtualfolder.configuration.error", "Invalid virtual folder configuration!"));
        }

        m_sFolderClassName = OwXMLDOMUtil.getSafeStringAttributeValue(n_p, "folderclassname", null);
        if (null == m_sFolderClassName)
        {
            String msg = "OwCMISSemiVirtualFolderEntry.OwCMISSemiVirtualFolderEntry(): Please define \"folderclassname\" attribute for SemiVirtualRecordClassName node in the owbootstrap.xml.";
            LOG.fatal(msg);
            throw new OwConfigurationException(new OwString("ecmimpl.cmis.OwCMISSemiVirtualFolderEntry.invalid.virtualfolder.configuration.error", "Invalid virtual folder configuration!"));
        }

        m_fIncludePhysicalChilds = OwXMLDOMUtil.getSafeBooleanAttributeValue(n_p, "includephysicalchilds", false);

        // create map of property mappings keyed by the virtual folder property
        m_propertyMapping = new HashMap<String, String>();

        Collection<?> propertymappings = OwXMLDOMUtil.getSafeNodeList(n_p);

        Iterator<?> it = propertymappings.iterator();
        while (it.hasNext())
        {
            org.w3c.dom.Node vfProperty = (org.w3c.dom.Node) it.next();

            // add to map
            if (null != vfProperty.getFirstChild())
            {
                m_propertyMapping.put(vfProperty.getFirstChild().getNodeValue(), OwXMLDOMUtil.getSafeStringAttributeValue(vfProperty, "folderproperty", null));
            }
        }

    }

    public String getFolderClassName()
    {
        return m_sFolderClassName;
    }

    public String getVirtualFolder()
    {
        return m_sVirtualFolder;
    }

    public boolean getIsIncludePhysicalChilds()
    {
        return m_fIncludePhysicalChilds;
    }

    public Map<String, String> getPropertyMapping()
    {
        return m_propertyMapping;
    }
}
