package com.wewebu.ow.server.ecmimpl.cmis;

import java.util.Collection;
import java.util.Map;

import org.apache.log4j.Logger;
import org.oasis_open.docs.ns.cmis.core._200908.CmisObjectType;

import com.wewebu.ow.server.ecm.OwObjectCollection;
import com.wewebu.ow.server.ecm.OwSemiVirtualFolder;
import com.wewebu.ow.server.ecm.OwSemiVirtualFolderAdapter;
import com.wewebu.ow.server.ecm.OwSemiVirtualRecordClass;
import com.wewebu.ow.server.ecm.OwStandardSemiVirtualFolderAdapter;
import com.wewebu.ow.server.ecm.OwVirtualFolderObject;
import com.wewebu.ow.server.ecmimpl.cmis.log.OwLog;
import com.wewebu.ow.server.ecmimpl.cmis.object.OwCMISFolderObject;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.field.OwSearchNode;
import com.wewebu.ow.server.field.OwSearchTemplate;
import com.wewebu.ow.server.field.OwSort;
import com.wewebu.ow.server.util.OwString;

/**
 *<p>
 * CMIS Adaptor: Semi Virtual FolderObject.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 */
public class OwCMISSemiVirtualFolderObject extends OwCMISFolderObject implements OwSemiVirtualFolder
{
    private static final Logger LOG = OwLog.getLogger(OwCMISSemiVirtualFolderObject.class);

    /**
     * The semi virtual folder entry configured in owbootstrap.xml
     */
    protected OwSemiVirtualRecordClass semiVirtualEntry;

    private OwSemiVirtualFolderAdapter adapter;

    /**
     * Create a new <code>OwCMISSemiVirtualFolderObject</code> representing a given CMIS <code>{@link CmisObjectType}</code>.
     * 
     * @param network_p The <code>{@link OwCMISNetwork}</code> this object belongs to
     * @param objectModel_p The <code>{@link OwCMISObjectModel}</code> this object belongs to
     * @param cmisObject_p The CMIS object that should be represented by this <code>OwCMISObject</code>.
     * @param semiVirtualEntry_p The semi-virtual folder definition of this semi-virtual folder
     * @throws OwException 
     * 
     * @throws IllegalArgumentException if the given node is null
     */
    public OwCMISSemiVirtualFolderObject(OwCMISNetwork network_p, OwCMISObjectModel objectModel_p, CmisObjectType cmisObject_p, OwSemiVirtualRecordClass semiVirtualEntry_p) throws OwException
    {
        super(network_p, objectModel_p, cmisObject_p);

        this.semiVirtualEntry = semiVirtualEntry_p;
        this.adapter = new OwStandardSemiVirtualFolderAdapter(network_p);
    }

    public OwObjectCollection getChilds(int[] iObjectTypes_p, java.util.Collection propertyNames_p, OwSort sort_p, int iMaxSize_p, int iVersionSelection_p, OwSearchNode filterCriteria_p) throws OwException
    {
        return this.adapter.getChildren(this, iObjectTypes_p, propertyNames_p, sort_p, iMaxSize_p, iVersionSelection_p, filterCriteria_p);
    }

    public OwSearchTemplate getSearchTemplate() throws OwException
    {
        OwVirtualFolderObject virtualFolder = this.adapter.getVirtualFolder(this);
        try
        {
            return virtualFolder.getSearchTemplate();
        }
        catch (OwException ce)
        {
            throw ce;
        }
        catch (Exception e)
        {
            String msg = "OwCMISSemiVirtualFolderObject.getSearchTemplate():Error retrieving search template.";
            LOG.error(msg, e);
            throw new OwInvalidOperationException(new OwString("ecmimpl.cmis.OwCMISSemiVirtualFolderObject.children.enumeration.error", "Error enumerating virtual folder contents!"), e);
        }
    }

    public OwObjectCollection getPhysicalChildren(int[] objectTypes_p, Collection propertyNames_p, OwSort sort_p, int maxSize_p, int versionSelection_p, OwSearchNode filterCriteria_p) throws OwException
    {
        try
        {
            return super.getChilds(objectTypes_p, propertyNames_p, sort_p, maxSize_p, versionSelection_p, filterCriteria_p);
        }
        catch (OwException e)
        {
            throw e;
        }
        catch (Exception e)
        {
            LOG.error("OwCMISSemiVirtualFolderObject.getPhysicalChildren():Could not retrieve the semi-virtual-folder physical children!", e);
            throw new OwInvalidOperationException(new OwString("ecmimpl.cmis.OwCMISSemiVirtualFolderObject.children.enumeration.error", "Error enumerating virtual folder contents!"), e);
        }
    }

    public Map getPropertyMap()
    {
        return this.semiVirtualEntry.getPropertyMapping();
    }

    public String getVirtualFolderName()
    {
        return this.semiVirtualEntry.getVirtualFolder();
    }

    public boolean includesPhysicalChildren()
    {
        return this.semiVirtualEntry.isIncludePhysicalChilds();
    }

    public boolean searchSubstructure()
    {
        return semiVirtualEntry.isSearchSubstructure();
    }

}