package com.wewebu.ow.server.ecmimpl.cmis;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

import org.apache.log4j.Logger;

import com.wewebu.ow.server.ecm.OwRole;
import com.wewebu.ow.server.ecm.OwUserInfo;
import com.wewebu.ow.server.ecmimpl.cmis.log.OwLog;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.mandator.OwMandator;

/**
 *<p>
 * User info for simple user authentication.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 */
public class OwCMISSimpleUserInfo extends OwCMISUserInfo
{
    /** package logger for the class */
    private static final Logger LOG = OwLog.getLogger(OwCMISSimpleUserInfo.class);

    private List<OwUserInfo> defaultGroups = Arrays.asList(new OwUserInfo[] {});
    private List<String> defaultRoleNames = null;
    private OwMandator mandator;

    public OwCMISSimpleUserInfo(String name_p, OwMandator mandator_p)
    {
        super(name_p);
        this.mandator = mandator_p;
    }

    /**
     * 
     * @return default Workdesk groups for this user 
     */
    protected synchronized List<OwUserInfo> getDefaulfGroups() throws OwException
    {
        return this.defaultGroups;
    }

    /**
     * 
     * @return default user roles for this user
     * @throws OwException
     */
    protected synchronized List<String> getDefaultRoleNames() throws OwException
    {
        if (this.defaultRoleNames == null)
        {
            this.defaultRoleNames = new LinkedList<String>();

            List<OwUserInfo> defaulGroups = getDefaulfGroups();
            for (OwUserInfo group : defaulGroups)
            {
                try
                {
                    String roleName = group.getUserName();
                    if (this.mandator != null)
                    {
                        roleName = this.mandator.filterRoleName(roleName);
                    }
                    this.defaultRoleNames.add(roleName);
                }
                catch (Exception e)
                {
                    LOG.error("OwCMISSimpleUserInfo.getDefaultRoleNames(): could not create default role names ", e);
                    throw new OwInvalidOperationException("Could not create default role names !", e);
                }
            }

            String authenticatedRole = OwRole.OW_AUTHENTICATED;
            if (this.mandator != null)
            {
                authenticatedRole = this.mandator.filterRoleName(authenticatedRole);
            }
            this.defaultRoleNames.add(authenticatedRole);
        }

        return this.defaultRoleNames;
    }

    public Collection<OwUserInfo> getGroups() throws OwException
    {
        return getDefaulfGroups();
    }

    public Collection<String> getRoleNames() throws OwException
    {
        return getDefaultRoleNames();
    }

    public final boolean isGroup()
    {
        return false;
    }

    protected OwMandator getMandator()
    {
        return this.mandator;
    }
}
