package com.wewebu.ow.server.ecmimpl.cmis;

import org.apache.log4j.Logger;
import org.w3c.dom.Node;

import com.wewebu.ow.server.ao.OwVirtualFolderFactory;
import com.wewebu.ow.server.ecm.OwNetwork;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwVirtualFolderObjectFactory;
import com.wewebu.ow.server.ecmimpl.cmis.log.OwLog;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.util.OwStandardXMLUtil;
import com.wewebu.ow.server.util.OwXMLUtil;

/**
 *<p>
 * Default virtual factory implementation for CMIS.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 *@since 4.0.0.0
 */
public class OwCMISVirtualFolderFactory implements OwVirtualFolderFactory
{
    private static final Logger LOG = OwLog.getLogger(OwCMISVirtualFolderFactory.class);

    private OwNetwork network;
    private OwCMISDMSIDDecoder dmisdDecoder;

    public OwCMISVirtualFolderFactory(OwNetwork network, OwCMISDMSIDDecoder dmisdDecoder)
    {
        super();
        this.network = network;
        this.dmisdDecoder = dmisdDecoder;
    }

    public OwObject createVirtualFolder(Node xmlVirtualFolderDescriptionNode_p, String strName_p, String strDmsIDPart_p) throws OwException
    {
        // read the classname to instantiate from XML, default is OwStandardVirtualFolderObject
        OwXMLUtil description;
        try
        {
            description = new OwStandardXMLUtil(xmlVirtualFolderDescriptionNode_p);
            String strVirtualFolderClassName = description.getSafeTextValue(OwVirtualFolderObjectFactory.CLASSNAME_TAG_NAME, "com.wewebu.ow.server.ecmimpl.cmis.OwCMISVirtualFolderObjectFactory");
            Class<?> virtualFolderClass = Class.forName(strVirtualFolderClassName);

            OwVirtualFolderObjectFactory retObject = (OwVirtualFolderObjectFactory) virtualFolderClass.newInstance();

            Node rootNode = description.getSubNode(OwVirtualFolderObjectFactory.ROOT_NODE_TAG_NAME);
            String dmisdPrefix = dmisdDecoder.getDMSIDPrefix();
            final String virtualFolderPrefix = "vf";
            retObject.init(network.getContext(), network, dmisdPrefix + "," + virtualFolderPrefix + "," + strName_p, strName_p, rootNode);

            return retObject.getInstance(strDmsIDPart_p);
        }
        catch (OwException e)
        {
            throw e;
        }
        catch (Exception e)
        {
            LOG.error("OwCMISNetwork.createVirtualFolder():Could not create virtual folder named " + strName_p + " and dmisd part " + strDmsIDPart_p);
            throw new OwInvalidOperationException(network.getContext().localize("ecmimpl.cmis.OwCMISNetwork.create.virtual.folder.error", "Could not create virtual folder!"), e);
        }
    }

}
